/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFConstPi
implements UDTF {
    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        configurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putDouble(row.getTime(), Math.PI);
    }

    @Override
    public Object transform(Row row) throws IOException {
        return Math.PI;
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        int colCount = columns[0].getPositionCount();
        for (int i = 0; i < colCount; ++i) {
            boolean hasWritten = false;
            for (Column column : columns) {
                if (column.isNull(i)) continue;
                builder.writeDouble(Math.PI);
                hasWritten = true;
                break;
            }
            if (hasWritten) continue;
            builder.appendNull();
        }
    }
}

