/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.runtime.SerializationRunTimeException;
import org.apache.iotdb.commons.sync.PipeMessage;
import org.apache.iotdb.commons.sync.PipeStatus;
import org.apache.iotdb.commons.sync.TsFilePipeInfo;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class PipeInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInfo.class);
    protected String pipeName;
    protected String pipeSinkName;
    protected PipeStatus status;
    protected long createTime;
    protected PipeMessage.PipeMessageType messageType;

    protected PipeInfo() {
    }

    protected PipeInfo(String pipeName, String pipeSinkName, long createTime) {
        this.pipeName = pipeName;
        this.pipeSinkName = pipeSinkName;
        this.createTime = createTime;
        this.status = PipeStatus.STOP;
        this.messageType = PipeMessage.PipeMessageType.NORMAL;
    }

    protected PipeInfo(String pipeName, String pipeSinkName, PipeStatus status, long createTime) {
        this.pipeName = pipeName;
        this.pipeSinkName = pipeSinkName;
        this.createTime = createTime;
        this.status = status;
        this.messageType = PipeMessage.PipeMessageType.NORMAL;
    }

    abstract PipeType getType();

    public String getPipeName() {
        return this.pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public PipeStatus getStatus() {
        return this.status;
    }

    public void setStatus(PipeStatus status) {
        this.status = status;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.getType().ordinal(), outputStream);
        ReadWriteIOUtils.write(this.pipeName, outputStream);
        ReadWriteIOUtils.write(this.pipeSinkName, outputStream);
        ReadWriteIOUtils.write(this.status.getType(), outputStream);
        ReadWriteIOUtils.write(this.createTime, outputStream);
        ReadWriteIOUtils.write((byte)this.messageType.ordinal(), outputStream);
    }

    protected void deserialize(InputStream inputStream) throws IOException {
        this.pipeName = ReadWriteIOUtils.readString(inputStream);
        this.pipeSinkName = ReadWriteIOUtils.readString(inputStream);
        this.status = PipeStatus.getPipeStatus(ReadWriteIOUtils.readByte(inputStream));
        this.createTime = ReadWriteIOUtils.readLong(inputStream);
        this.messageType = PipeMessage.PipeMessageType.values()[ReadWriteIOUtils.readByte(inputStream)];
    }

    protected void deserialize(ByteBuffer byteBuffer) {
        this.pipeName = ReadWriteIOUtils.readString(byteBuffer);
        this.pipeSinkName = ReadWriteIOUtils.readString(byteBuffer);
        this.status = PipeStatus.getPipeStatus(ReadWriteIOUtils.readByte(byteBuffer));
        this.createTime = ReadWriteIOUtils.readLong(byteBuffer);
        this.messageType = PipeMessage.PipeMessageType.values()[ReadWriteIOUtils.readByte(byteBuffer)];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer serializeToByteBuffer() {
        try (PublicBAOS publicBAOS = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream dataOutputStream = new DataOutputStream(publicBAOS);){
                this.serialize(dataOutputStream);
                byteBuffer = ByteBuffer.wrap(publicBAOS.getBuf(), 0, publicBAOS.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error occurred when serializing PipeInfo.");
            throw new SerializationRunTimeException(e);
        }
    }

    public static PipeInfo deserializePipeInfo(ByteBuffer byteBuffer) {
        TsFilePipeInfo pipeInfo;
        PipeType pipeType = PipeType.values()[ReadWriteIOUtils.readByte(byteBuffer)];
        switch (pipeType) {
            case TsFilePipe: {
                pipeInfo = new TsFilePipeInfo();
                ((PipeInfo)pipeInfo).deserialize(byteBuffer);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Can not recognize PipeType %s.", pipeType.name()));
            }
        }
        return pipeInfo;
    }

    static enum PipeType {
        TsFilePipe,
        WALPipe;

    }
}

