/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.concurrent.threadpool.IThreadPoolMBean;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;

public class ThreadPoolMetrics
implements IMetricSet {
    private AbstractMetricService metricService;
    private Map<String, IThreadPoolMBean> notRegisteredPoolMap = new HashMap<String, IThreadPoolMBean>();
    private Map<String, IThreadPoolMBean> registeredPoolMap = new HashMap<String, IThreadPoolMBean>();

    public static ThreadPoolMetrics getInstance() {
        return ThreadPoolMetricsHolder.INSTANCE;
    }

    private ThreadPoolMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThreadPool(IThreadPoolMBean pool, String name) {
        ThreadPoolMetrics threadPoolMetrics = this;
        synchronized (threadPoolMetrics) {
            if (this.metricService == null) {
                this.notRegisteredPoolMap.put(name, pool);
            } else {
                this.registeredPoolMap.put(name, pool);
                this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_ACTIVE_THREAD_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getActiveCount(), SystemTag.POOL_NAME.toString(), name);
                this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_CORE_SIZE.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getCorePoolSize(), SystemTag.POOL_NAME.toString(), name);
                this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_WAITING_TASK_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getQueueLength(), SystemTag.POOL_NAME.toString(), name);
                this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_DONE_TASK_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getCompletedTaskCount(), SystemTag.POOL_NAME.toString(), name);
                this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_LARGEST_POOL_SIZE.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> this.registeredPoolMap.get(name).getLargestPoolSize(), SystemTag.POOL_NAME.toString(), name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTo(AbstractMetricService metricService) {
        ThreadPoolMetrics threadPoolMetrics = this;
        synchronized (threadPoolMetrics) {
            this.metricService = metricService;
            for (Map.Entry<String, IThreadPoolMBean> entry : this.notRegisteredPoolMap.entrySet()) {
                metricService.createAutoGauge(SystemMetric.THREAD_POOL_ACTIVE_THREAD_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getActiveCount(), SystemTag.POOL_NAME.toString(), entry.getKey());
                metricService.createAutoGauge(SystemMetric.THREAD_POOL_CORE_SIZE.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getCorePoolSize(), SystemTag.POOL_NAME.toString(), entry.getKey());
                metricService.createAutoGauge(SystemMetric.THREAD_POOL_WAITING_TASK_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getQueue().size(), SystemTag.POOL_NAME.toString(), entry.getKey());
                metricService.createAutoGauge(SystemMetric.THREAD_POOL_DONE_TASK_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getCompletedTaskCount(), SystemTag.POOL_NAME.toString(), entry.getKey());
                metricService.createAutoGauge(SystemMetric.THREAD_POOL_LARGEST_POOL_SIZE.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> ((IThreadPoolMBean)entry.getValue()).getLargestPoolSize(), SystemTag.POOL_NAME.toString(), entry.getKey());
            }
            this.registeredPoolMap.putAll(this.notRegisteredPoolMap);
            this.notRegisteredPoolMap.clear();
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        for (Map.Entry<String, IThreadPoolMBean> entry : this.registeredPoolMap.entrySet()) {
            metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_ACTIVE_THREAD_COUNT.toString(), SystemTag.POOL_NAME.toString(), entry.getKey());
            metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_CORE_SIZE.toString(), SystemTag.POOL_NAME.toString(), entry.getKey());
            metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_WAITING_TASK_COUNT.toString(), SystemTag.POOL_NAME.toString(), entry.getKey());
            metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_DONE_TASK_COUNT.toString(), SystemTag.POOL_NAME.toString(), entry.getKey());
            metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_LARGEST_POOL_SIZE.toString(), SystemTag.POOL_NAME.toString(), entry.getKey());
        }
    }

    private static class ThreadPoolMetricsHolder {
        private static final ThreadPoolMetrics INSTANCE = new ThreadPoolMetrics();

        private ThreadPoolMetricsHolder() {
        }
    }
}

