/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientManagerMetrics;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncConfigNodeIServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.client.property.ClientPoolProperty;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.client.sync.SyncConfigNodeIServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;

public class ClientPoolFactory {
    private static final CommonConfig conf = CommonDescriptor.getInstance().getConfig();

    private ClientPoolFactory() {
    }

    public static class AsyncPipeDataTransferServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncPipeDataTransferServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncPipeDataTransferServiceClient> createClientPool(ClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, AsyncPipeDataTransferServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, AsyncPipeDataTransferServiceClient>(new AsyncPipeDataTransferServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs((int)conf.getPipeConnectorTimeoutMs()).setRpcThriftCompressionEnabled(conf.isPipeConnectorRPCThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getPipeAsyncConnectorSelectorNumber()).build(), ThreadName.PIPE_ASYNC_CONNECTOR_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getPipeAsyncConnectorCoreClientNumber()).setMaxClientNumForEachNode(conf.getPipeAsyncConnectorMaxClientNumber()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncDataNodeMPPDataExchangeServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient>(new AsyncDataNodeMPPDataExchangeServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_MPP_DATA_EXCHANGE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class SyncDataNodeMPPDataExchangeServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient>(new SyncDataNodeMPPDataExchangeServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).build()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncDataNodeHeartbeatServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeInternalServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient>(new AsyncDataNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).setPrintLogWhenEncounterException(false).build(), ThreadName.ASYNC_DATANODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncConfigNodeHeartbeatServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncConfigNodeIServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncConfigNodeIServiceClient> createClientPool(ClientManager<TEndPoint, AsyncConfigNodeIServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, AsyncConfigNodeIServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, AsyncConfigNodeIServiceClient>(new AsyncConfigNodeIServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).setPrintLogWhenEncounterException(false).build(), ThreadName.ASYNC_CONFIGNODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeInternalServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient>(new AsyncDataNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class SyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeInternalServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, SyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, SyncDataNodeInternalServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, SyncDataNodeInternalServiceClient>(new SyncDataNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).build()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncConfigNodeIServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncConfigNodeIServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncConfigNodeIServiceClient> createClientPool(ClientManager<TEndPoint, AsyncConfigNodeIServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, AsyncConfigNodeIServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, AsyncConfigNodeIServiceClient>(new AsyncConfigNodeIServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_CONFIGNODE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class SyncConfigNodeIServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncConfigNodeIServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, SyncConfigNodeIServiceClient> createClientPool(ClientManager<TEndPoint, SyncConfigNodeIServiceClient> manager) {
            GenericKeyedObjectPool<TEndPoint, SyncConfigNodeIServiceClient> clientPool = new GenericKeyedObjectPool<TEndPoint, SyncConfigNodeIServiceClient>(new SyncConfigNodeIServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).build()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }
}

