/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.user.IUserAccessor;
import org.apache.iotdb.commons.auth.user.IUserManager;
import org.apache.iotdb.commons.concurrent.HashLock;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicUserManager
implements IUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicUserManager.class);
    private static final String NO_SUCH_USER_ERROR = "No such user %s";
    protected Map<String, User> userMap = new HashMap<String, User>();
    protected IUserAccessor accessor;
    protected HashLock lock;
    private boolean preVersion = false;

    @Override
    public void setPreVersion(boolean preVersion) {
        this.preVersion = preVersion;
    }

    @Override
    public boolean preVersion() {
        return this.preVersion;
    }

    protected BasicUserManager(IUserAccessor accessor) throws AuthException {
        this.accessor = accessor;
        this.lock = new HashLock();
        this.reset();
    }

    private void initAdmin() throws AuthException {
        User admin;
        try {
            admin = this.getUser(CommonDescriptor.getInstance().getConfig().getAdminName());
        }
        catch (AuthException e) {
            LOGGER.warn("Cannot load admin, Creating a new one", e);
            admin = null;
        }
        if (admin == null) {
            this.createUser(CommonDescriptor.getInstance().getConfig().getAdminName(), CommonDescriptor.getInstance().getConfig().getAdminPassword(), true);
            this.setUserUseWaterMark(CommonDescriptor.getInstance().getConfig().getAdminName(), false);
        }
        admin = this.getUser(CommonDescriptor.getInstance().getConfig().getAdminName());
        try {
            PartialPath rootPath = new PartialPath("root.**");
            PathPrivilege pathPri = new PathPrivilege(rootPath);
            for (PrivilegeType item : PrivilegeType.values()) {
                if (!item.isPathRelevant()) {
                    admin.getSysPrivilege().add(item.ordinal());
                    admin.getSysPriGrantOpt().add(item.ordinal());
                    continue;
                }
                pathPri.grantPrivilege(item.ordinal(), true);
            }
            admin.getPathPrivilegeList().add(pathPri);
        }
        catch (IllegalPathException e) {
            LOGGER.warn("Got a wrong path for root to init");
        }
        LOGGER.info("Admin initialized");
    }

    @Override
    public User getUser(String username) throws AuthException {
        this.lock.readLock(username);
        User user = this.userMap.get(username);
        this.lock.readUnlock(username);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createUser(String username, String password, boolean validCheck) throws AuthException {
        User user;
        if (validCheck) {
            AuthUtils.validateUsername(username);
            AuthUtils.validatePassword(password);
        }
        if ((user = this.getUser(username)) != null) {
            return false;
        }
        this.lock.writeLock(username);
        try {
            user = new User(username, AuthUtils.encryptPassword(password));
            this.userMap.put(username, user);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    @Override
    public boolean deleteUser(String username) {
        this.lock.writeLock(username);
        try {
            boolean bl = this.userMap.remove(username) != null;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivilegeToUser(String username, PartialPath path, int privilegeId, boolean grantOpt) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (this.preVersion) {
                AuthUtils.validatePath(path);
                if (privilegeId == PriPrivilegeType.ALL.ordinal()) {
                    for (PriPrivilegeType type : PriPrivilegeType.values()) {
                        user.addPathPrivilege(path, type.ordinal(), false);
                    }
                } else {
                    user.addPathPrivilege(path, privilegeId, false);
                }
                if (user.getServiceReady()) {
                    user.setServiceReady(false);
                }
                boolean bl = true;
                return bl;
            }
            if (path != null) {
                AuthUtils.validatePatternPath(path);
                user.addPathPrivilege(path, privilegeId, grantOpt);
            } else {
                user.addSysPrivilege(privilegeId);
                if (grantOpt) {
                    user.getSysPriGrantOpt().add(privilegeId);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivilegeFromUser(String username, PartialPath path, int privilegeId) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (this.preVersion) {
                if (!AuthUtils.hasPrivilege(path, privilegeId, user.getPathPrivilegeList())) {
                    boolean bl = false;
                    return bl;
                }
                AuthUtils.removePrivilegePre(path, privilegeId, user.getPathPrivilegeList());
                boolean bl = true;
                return bl;
            }
            if (!user.hasPrivilegeToRevoke(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            if (path != null) {
                AuthUtils.validatePatternPath(path);
                user.removePathPrivilege(path, privilegeId);
            } else {
                user.getSysPrivilege().remove(privilegeId);
                user.getSysPriGrantOpt().remove(privilegeId);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateUserPassword(String username, String newPassword) throws AuthException {
        try {
            if (this.preVersion) {
                AuthUtils.validatePasswordPre(newPassword);
            } else {
                AuthUtils.validatePassword(newPassword);
            }
        }
        catch (AuthException e) {
            LOGGER.debug("An illegal password detected ", e);
            return false;
        }
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            user.setPassword(AuthUtils.encryptPassword(newPassword));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantRoleToUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (user.hasRole(roleName)) {
                boolean bl = false;
                return bl;
            }
            user.getRoleList().add(roleName);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeRoleFromUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getUser(username);
            if (user == null) {
                throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
            }
            if (!user.hasRole(roleName)) {
                boolean bl = false;
                return bl;
            }
            user.getRoleList().remove(roleName);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    @Override
    public void reset() throws AuthException {
        this.accessor.reset();
        this.userMap.clear();
        for (String name : this.accessor.listAllUsers()) {
            try {
                this.userMap.put(name, this.accessor.loadUser(name));
            }
            catch (IOException e) {
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
        }
        this.initAdmin();
    }

    @Override
    public List<String> listAllUsers() {
        ArrayList<String> rtlist = new ArrayList<String>();
        this.userMap.forEach((name, item) -> rtlist.add((String)name));
        rtlist.sort(null);
        return rtlist;
    }

    @Override
    public boolean isUserUseWaterMark(String username) throws AuthException {
        User user = this.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
        }
        return user.isUseWaterMark();
    }

    @Override
    public void setUserUseWaterMark(String username, boolean useWaterMark) throws AuthException {
        User user = this.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_ERROR, username));
        }
        boolean oldFlag = user.isUseWaterMark();
        if (oldFlag == useWaterMark) {
            return;
        }
        user.setUseWaterMark(useWaterMark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAllUsers(Map<String, User> users) throws AuthException {
        BasicUserManager basicUserManager = this;
        synchronized (basicUserManager) {
            this.reset();
            this.userMap = users;
            for (Map.Entry<String, User> entry : this.userMap.entrySet()) {
                User user = entry.getValue();
                try {
                    this.accessor.saveUser(user);
                }
                catch (IOException e) {
                    throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void checkAndRefreshPathPri() {
        this.userMap.forEach((rolename, user) -> AuthUtils.checkAndRefreshPri(user));
    }
}

