/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class MethodKey {
    private static final int PRIMITIVE_SIZE = 11;
    private final int hashCode;
    private final String method;
    private final Class<?>[] params;
    private static final Class<?>[] NOARGS = new Class[0];
    private static final int HASH = 37;
    private static final Map<Class<?>, Class<?>[]> CONVERTIBLES = new HashMap(11);
    private static final Map<Class<?>, Class<?>[]> STRICT_CONVERTIBLES;
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INCOMPARABLE = 2;

    public MethodKey(String aMethod, Object[] args) {
        int size;
        this.method = aMethod;
        int hash = this.method.hashCode();
        if (args != null && (size = args.length) > 0) {
            this.params = new Class[size];
            for (int p = 0; p < size; ++p) {
                Object arg = args[p];
                Class parm = arg == null ? Void.class : arg.getClass();
                hash = 37 * hash + parm.hashCode();
                this.params[p] = parm;
            }
        } else {
            this.params = NOARGS;
        }
        this.hashCode = hash;
    }

    MethodKey(Executable aMethod) {
        this(aMethod.getName(), aMethod.getParameterTypes());
    }

    MethodKey(String aMethod, Class<?>[] args) {
        int size;
        this.method = aMethod.intern();
        int hash = this.method.hashCode();
        if (args != null && (size = args.length) > 0) {
            this.params = new Class[size];
            for (int p = 0; p < size; ++p) {
                Class<?> parm = MethodKey.primitiveClass(args[p]);
                hash = 37 * hash + parm.hashCode();
                this.params[p] = parm;
            }
        } else {
            this.params = NOARGS;
        }
        this.hashCode = hash;
    }

    String getMethod() {
        return this.method;
    }

    Class<?>[] getParameters() {
        return this.params;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodKey) {
            MethodKey key = (MethodKey)obj;
            return this.method.equals(key.method) && Arrays.equals(this.params, key.params);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.method);
        for (Class<?> c : this.params) {
            builder.append(c == Void.class ? "null" : c.getName());
        }
        return builder.toString();
    }

    public String debugString() {
        StringBuilder builder = new StringBuilder(this.method);
        builder.append('(');
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(Void.class == this.params[i] ? "null" : this.params[i].getName());
        }
        builder.append(')');
        return builder.toString();
    }

    public static boolean isVarArgs(Executable method) {
        if (method == null) {
            return false;
        }
        if (method.isVarArgs()) {
            return true;
        }
        Class<?>[] ptypes = method.getParameterTypes();
        if (ptypes.length == 0 || ptypes[ptypes.length - 1].getComponentType() == null) {
            return false;
        }
        String mname = method.getName();
        Class<?> clazz = method.getDeclaringClass();
        do {
            try {
                Method m4 = clazz.getMethod(mname, ptypes);
                if (m4.isVarArgs()) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public Method getMostSpecificMethod(Method[] methods) {
        return (Method)this.getMostSpecific(methods);
    }

    public Constructor<?> getMostSpecificConstructor(Constructor<?>[] methods) {
        return (Constructor)this.getMostSpecific(methods);
    }

    public static boolean isInvocationConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
        return MethodKey.isInvocationConvertible(formal, actual, false, possibleVarArg);
    }

    public static boolean isStrictInvocationConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
        return MethodKey.isInvocationConvertible(formal, actual, true, possibleVarArg);
    }

    static Class<?> primitiveClass(Class<?> parm) {
        Class<?>[] prim = CONVERTIBLES.get(parm);
        return prim == null ? parm : prim[0];
    }

    private static Class<?>[] asArray(Class<?> ... args) {
        return args;
    }

    private static boolean isInvocationConvertible(Class<?> formal, Class<?> type, boolean strict, boolean possibleVarArg) {
        Class<?> actual = type;
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (actual != null && formal.isAssignableFrom(actual) && actual.isArray() == formal.isArray()) {
            return true;
        }
        if (!strict && formal == Object.class) {
            return true;
        }
        if (formal.isPrimitive()) {
            Class<?>[] clist;
            Class<?>[] classArray = clist = strict ? STRICT_CONVERTIBLES.get(formal) : CONVERTIBLES.get(formal);
            if (clist != null) {
                for (Class<?> aClass : clist) {
                    if (actual != aClass) continue;
                    return true;
                }
            }
            return false;
        }
        if (possibleVarArg && formal.isArray()) {
            if (actual.isArray()) {
                actual = actual.getComponentType();
            }
            return MethodKey.isInvocationConvertible(formal.getComponentType(), actual, strict, false);
        }
        return false;
    }

    private <T extends Executable> T getMostSpecific(T[] methods) {
        Class[] args = this.getParameters();
        Deque applicables = MethodKey.getApplicables(methods, (Class[])args);
        if (applicables.isEmpty()) {
            return null;
        }
        if (applicables.size() == 1) {
            return (T)((Executable)applicables.getFirst());
        }
        LinkedList<Executable> maximals = new LinkedList<Executable>();
        for (Executable app : applicables) {
            Class<?>[] parms = app.getParameterTypes();
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            while (!lessSpecific && maximal.hasNext()) {
                Executable max = (Executable)maximal.next();
                switch (MethodKey.moreSpecific(args, parms, max.getParameterTypes())) {
                    case 0: {
                        maximal.remove();
                        break;
                    }
                    case 1: {
                        lessSpecific = true;
                        break;
                    }
                }
            }
            if (lessSpecific) continue;
            maximals.addLast(app);
        }
        if (maximals.size() > 1) {
            throw MethodKey.ambiguousException(args, applicables);
        }
        return (T)((Executable)maximals.getFirst());
    }

    private static <T extends Executable> AmbiguousException ambiguousException(Class<?>[] classes, Iterable<T> applicables) {
        boolean severe = false;
        int instanceArgCount = 0;
        block0: for (int c = 0; c < classes.length; ++c) {
            Class<?> argClazz = classes[c];
            if (Void.class.equals(argClazz)) {
                int objectParmCount = 0;
                for (Executable app : applicables) {
                    Class<?>[] parmClasses = app.getParameterTypes();
                    Class<?> parmClass = parmClasses[c];
                    if (!Object.class.equals(parmClass) || objectParmCount++ != 2) continue;
                    severe = true;
                    continue block0;
                }
                continue;
            }
            ++instanceArgCount;
        }
        return new AmbiguousException(severe || instanceArgCount == classes.length);
    }

    private static int moreSpecific(Class<?>[] a, Class<?>[] c1, Class<?>[] c2) {
        if (c1.length > a.length) {
            return 1;
        }
        if (c2.length > a.length) {
            return 0;
        }
        if (c1.length > c2.length) {
            return 0;
        }
        if (c2.length > c1.length) {
            return 1;
        }
        int length = c1.length;
        int ultimate = c1.length - 1;
        for (int i = 0; i < length; ++i) {
            boolean c2s;
            boolean c1s;
            boolean last;
            if (c1[i] == c2[i]) continue;
            boolean bl = last = i == ultimate;
            if (a[i] == Void.class) {
                if (c1[i] == Object.class && c2[i] != Object.class) {
                    return 0;
                }
                if (c1[i] != Object.class && c2[i] == Object.class) {
                    return 1;
                }
            }
            if ((c1s = MethodKey.isPrimitive(c1[i], last)) != (c2s = MethodKey.isPrimitive(c2[i], last))) {
                return c1s == (a[i] != Void.class) ? 0 : 1;
            }
            c1s = MethodKey.isStrictConvertible(c2[i], c1[i], last);
            if (c1s == (c2s = MethodKey.isStrictConvertible(c1[i], c2[i], last))) continue;
            return c1s ? 0 : 1;
        }
        return 2;
    }

    private static boolean isPrimitive(Class<?> c, boolean possibleVarArg) {
        if (c != null) {
            if (c.isPrimitive()) {
                return true;
            }
            if (possibleVarArg) {
                Class<?> t2 = c.getComponentType();
                return t2 != null && t2.isPrimitive();
            }
        }
        return false;
    }

    private static <T extends Executable> Deque<T> getApplicables(T[] methods, Class<?>[] classes) {
        LinkedList<T> list = new LinkedList<T>();
        for (T method : methods) {
            if (!MethodKey.isApplicable(method, classes)) continue;
            list.add(method);
        }
        return list;
    }

    private static <T extends Executable> boolean isApplicable(T method, Class<?>[] actuals) {
        Class<?>[] formals = method.getParameterTypes();
        if (formals.length == actuals.length) {
            for (int i = 0; i < actuals.length; ++i) {
                if (MethodKey.isConvertible(formals[i], actuals[i], false)) continue;
                if (i == actuals.length - 1 && formals[i].isArray()) {
                    return MethodKey.isConvertible(formals[i], actuals[i], true);
                }
                return false;
            }
            return true;
        }
        if (!MethodKey.isVarArgs(method)) {
            return false;
        }
        if (formals.length > actuals.length) {
            if (formals.length - actuals.length > 1) {
                return false;
            }
            for (int i = 0; i < actuals.length; ++i) {
                if (MethodKey.isConvertible(formals[i], actuals[i], false)) continue;
                return false;
            }
            return true;
        }
        if (formals.length > 0) {
            for (int i = 0; i < formals.length - 1; ++i) {
                if (MethodKey.isConvertible(formals[i], actuals[i], false)) continue;
                return false;
            }
            Class<?> vararg = formals[formals.length - 1].getComponentType();
            for (int i = formals.length - 1; i < actuals.length; ++i) {
                if (MethodKey.isConvertible(vararg, actuals[i], false)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
        return MethodKey.isInvocationConvertible(formal, actual.equals(Void.class) ? null : actual, possibleVarArg);
    }

    private static boolean isStrictConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
        return MethodKey.isStrictInvocationConvertible(formal, actual.equals(Void.class) ? null : actual, possibleVarArg);
    }

    static {
        CONVERTIBLES.put(Boolean.TYPE, MethodKey.asArray(Boolean.class));
        CONVERTIBLES.put(Character.TYPE, MethodKey.asArray(Character.class));
        CONVERTIBLES.put(Byte.TYPE, MethodKey.asArray(Byte.class));
        CONVERTIBLES.put(Short.TYPE, MethodKey.asArray(Short.class, Byte.class));
        CONVERTIBLES.put(Integer.TYPE, MethodKey.asArray(Integer.class, Short.class, Byte.class));
        CONVERTIBLES.put(Long.TYPE, MethodKey.asArray(Long.class, Integer.class, Short.class, Byte.class));
        CONVERTIBLES.put(Float.TYPE, MethodKey.asArray(Float.class, Long.class, Integer.class, Short.class, Byte.class));
        CONVERTIBLES.put(Double.TYPE, MethodKey.asArray(Double.class, Float.class, Long.class, Integer.class, Short.class, Byte.class));
        STRICT_CONVERTIBLES = new HashMap(11);
        STRICT_CONVERTIBLES.put(Short.TYPE, MethodKey.asArray(Byte.TYPE));
        STRICT_CONVERTIBLES.put(Integer.TYPE, MethodKey.asArray(Short.TYPE, Byte.TYPE));
        STRICT_CONVERTIBLES.put(Long.TYPE, MethodKey.asArray(Integer.TYPE, Short.TYPE, Byte.TYPE));
        STRICT_CONVERTIBLES.put(Float.TYPE, MethodKey.asArray(Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE));
        STRICT_CONVERTIBLES.put(Double.TYPE, MethodKey.asArray(Float.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE));
    }

    public static class AmbiguousException
    extends RuntimeException {
        private static final long serialVersionUID = -201801091655L;
        private final boolean severe;

        AmbiguousException(boolean flag) {
            this.severe = flag;
        }

        public boolean isSevere() {
            return this.severe;
        }
    }
}

