/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.iotdb.jdbc.WatermarkEncoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.thrift.EncodingUtils;

public class GroupedLSBWatermarkEncoder
implements WatermarkEncoder {
    private String secretKey;
    private String bitString;
    private int markRate = 2;
    private int groupNumber;
    private int maxBitPosition = 5;
    private int minBitPosition = 0;

    public GroupedLSBWatermarkEncoder(String secretKey, String bitString, int markRate, int minBitPosition) {
        this.secretKey = secretKey;
        this.bitString = bitString;
        this.groupNumber = bitString.length();
        this.markRate = markRate;
        this.maxBitPosition = minBitPosition;
    }

    public static int hashMod(String val, Integer base) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("ERROR: Cannot find MD5 algorithm!");
        }
        md.update(val.getBytes());
        BigInteger resultInteger = new BigInteger(1, md.digest());
        return resultInteger.mod(new BigInteger(base.toString())).intValue();
    }

    @Override
    public boolean needEncode(long timestamp) {
        return GroupedLSBWatermarkEncoder.hashMod(String.format("%s%d", this.secretKey, timestamp), this.markRate) == 0;
    }

    private int getGroupId(long timestamp) {
        return GroupedLSBWatermarkEncoder.hashMod(String.format("%d%s", timestamp, this.secretKey), this.groupNumber);
    }

    private int getBitPosition(long timestamp) {
        if (this.maxBitPosition <= this.minBitPosition) {
            throw new RuntimeException("Error: minBitPosition is bigger than maxBitPosition");
        }
        int range = this.maxBitPosition - this.minBitPosition;
        return this.minBitPosition + GroupedLSBWatermarkEncoder.hashMod(String.format("%s%d%s", this.secretKey, timestamp, this.secretKey), range);
    }

    private boolean getBitValue(long timestamp) {
        int groupId = this.getGroupId(timestamp);
        int bitIndex = groupId % this.bitString.length();
        return this.bitString.charAt(bitIndex) == '1';
    }

    @Override
    public int encodeInt(int value, long timestamp) {
        int targetBitPosition = this.getBitPosition(timestamp);
        boolean targetBitValue = this.getBitValue(timestamp);
        return EncodingUtils.setBit((int)value, (int)targetBitPosition, (boolean)targetBitValue);
    }

    @Override
    public long encodeLong(long value, long timestamp) {
        int targetBitPosition = this.getBitPosition(timestamp);
        boolean targetBitValue = this.getBitValue(timestamp);
        return EncodingUtils.setBit((long)value, (int)targetBitPosition, (boolean)targetBitValue);
    }

    @Override
    public float encodeFloat(float value, long timestamp) {
        int intBits = Float.floatToIntBits(value);
        return Float.intBitsToFloat(this.encodeInt(intBits, timestamp));
    }

    @Override
    public double encodeDouble(double value, long timestamp) {
        long longBits = Double.doubleToLongBits(value);
        return Double.longBitsToDouble(this.encodeLong(longBits, timestamp));
    }

    @Override
    public RowRecord encodeRecord(RowRecord rowRecord) {
        long timestamp = rowRecord.getTimestamp();
        if (!this.needEncode(timestamp)) {
            return rowRecord;
        }
        List fields = rowRecord.getFields();
        for (Field field : fields) {
            if (field == null || field.getDataType() == null) continue;
            TSDataType dataType = field.getDataType();
            switch (dataType) {
                case INT32: {
                    int originIntValue = field.getIntV();
                    field.setIntV(this.encodeInt(originIntValue, timestamp));
                    break;
                }
                case INT64: {
                    long originLongValue = field.getLongV();
                    field.setLongV(this.encodeLong(originLongValue, timestamp));
                    break;
                }
                case FLOAT: {
                    float originFloatValue = field.getFloatV();
                    field.setFloatV(this.encodeFloat(originFloatValue, timestamp));
                    break;
                }
                case DOUBLE: {
                    double originDoubleValue = field.getDoubleV();
                    field.setDoubleV(this.encodeDouble(originDoubleValue, timestamp));
                    break;
                }
            }
        }
        return rowRecord;
    }
}

