/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoding;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class RunLengthEncodedColumn
implements Column {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RunLengthEncodedColumn.class).instanceSize();
    private final Column value;
    private final int positionCount;

    public RunLengthEncodedColumn(Column value, int positionCount) {
        Objects.requireNonNull(value, "value is null");
        if (value.getPositionCount() != 1) {
            throw new IllegalArgumentException(String.format("Expected value to contain a single position but has %s positions", value.getPositionCount()));
        }
        this.value = value instanceof RunLengthEncodedColumn ? ((RunLengthEncodedColumn)value).getValue() : value;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
    }

    public Column getValue() {
        return this.value;
    }

    public TSDataType getDataType() {
        return this.value.getDataType();
    }

    public ColumnEncoding getEncoding() {
        return ColumnEncoding.RLE;
    }

    public boolean getBoolean(int position) {
        return this.value.getBoolean(0);
    }

    public int getInt(int position) {
        return this.value.getInt(0);
    }

    public long getLong(int position) {
        return this.value.getLong(0);
    }

    public float getFloat(int position) {
        return this.value.getFloat(0);
    }

    public double getDouble(int position) {
        return this.value.getDouble(0);
    }

    public Binary getBinary(int position) {
        return this.value.getBinary(0);
    }

    public Object getObject(int position) {
        return this.value.getObject(0);
    }

    public boolean[] getBooleans() {
        boolean[] res = new boolean[this.positionCount];
        Arrays.fill(res, this.value.getBoolean(0));
        return res;
    }

    public int[] getInts() {
        int[] res = new int[this.positionCount];
        Arrays.fill(res, this.value.getInt(0));
        return res;
    }

    public long[] getLongs() {
        long[] res = new long[this.positionCount];
        Arrays.fill(res, this.value.getLong(0));
        return res;
    }

    public float[] getFloats() {
        float[] res = new float[this.positionCount];
        Arrays.fill(res, this.value.getFloat(0));
        return res;
    }

    public double[] getDoubles() {
        double[] res = new double[this.positionCount];
        Arrays.fill(res, this.value.getDouble(0));
        return res;
    }

    public Binary[] getBinaries() {
        Object[] res = new Binary[this.positionCount];
        Arrays.fill(res, this.value.getBinary(0));
        return res;
    }

    public Object[] getObjects() {
        Object[] res = new Object[this.positionCount];
        Arrays.fill(res, this.value.getObject(0));
        return res;
    }

    public TsPrimitiveType getTsPrimitiveType(int position) {
        return this.value.getTsPrimitiveType(0);
    }

    public boolean mayHaveNull() {
        return this.value.mayHaveNull();
    }

    public boolean isNull(int position) {
        return this.value.isNull(0);
    }

    public boolean[] isNull() {
        boolean[] res = new boolean[this.positionCount];
        Arrays.fill(res, this.value.isNull(0));
        return res;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.value.getRetainedSizeInBytes();
    }

    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return new RunLengthEncodedColumn(this.value, length);
    }

    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new RunLengthEncodedColumn(this.value, this.positionCount - fromIndex);
    }

    public void reverse() {
    }

    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }
}

