/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.flush;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.ICacheManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBTreeFlushExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PBTreeFlushExecutor.class);
    private final ICachedMNode subtreeRoot;
    private final ICacheManager cacheManager;
    private final ISchemaFile file;

    public PBTreeFlushExecutor(ICachedMNode subtreeRoot, ICacheManager cacheManager, ISchemaFile file) {
        this.subtreeRoot = subtreeRoot;
        this.cacheManager = cacheManager;
        this.file = file;
    }

    public void flushVolatileNodes() throws MetadataException, IOException {
        try {
            this.file.writeMNode(this.subtreeRoot);
        }
        catch (IOException | MetadataException e) {
            logger.warn("Error occurred during MTree flush, current node is {}", (Object)this.subtreeRoot.getFullPath(), (Object)e);
            this.cacheManager.updateCacheStatusAfterFlushFailure(this.subtreeRoot);
            throw e;
        }
        ArrayDeque<Iterator<ICachedMNode>> volatileSubtreeStack = new ArrayDeque<Iterator<ICachedMNode>>();
        volatileSubtreeStack.push(this.cacheManager.updateCacheStatusAndRetrieveSubtreeAfterPersist(this.subtreeRoot));
        while (!volatileSubtreeStack.isEmpty()) {
            Iterator subtreeIterator = (Iterator)volatileSubtreeStack.peek();
            if (!subtreeIterator.hasNext()) {
                volatileSubtreeStack.pop();
                continue;
            }
            ICachedMNode subtreeRoot = (ICachedMNode)subtreeIterator.next();
            try {
                this.file.writeMNode(subtreeRoot);
            }
            catch (IOException | MetadataException e) {
                logger.warn("Error occurred during MTree flush, current node is {}", (Object)subtreeRoot.getFullPath(), (Object)e);
                this.processNotFlushedSubtrees(subtreeRoot, volatileSubtreeStack);
                throw e;
            }
            volatileSubtreeStack.push(this.cacheManager.updateCacheStatusAndRetrieveSubtreeAfterPersist(subtreeRoot));
        }
    }

    private void processNotFlushedSubtrees(ICachedMNode currentNode, Deque<Iterator<ICachedMNode>> volatileSubtreeStack) {
        this.cacheManager.updateCacheStatusAfterFlushFailure(currentNode);
        while (!volatileSubtreeStack.isEmpty()) {
            Iterator<ICachedMNode> subtreeIterator = volatileSubtreeStack.pop();
            while (subtreeIterator.hasNext()) {
                this.cacheManager.updateCacheStatusAfterFlushFailure(subtreeIterator.next());
            }
        }
    }
}

