/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.estimator.MNodeSizeEstimator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.iterator.MNodeIterator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.iterator.MemoryTraverserIterator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.snapshot.MemMTreeSnapshotUtil;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MNodeUtils;
import org.apache.iotdb.db.schemaengine.template.Template;

public class MemMTreeStore
implements IMTreeStore<IMemMNode> {
    private final MemSchemaRegionStatistics regionStatistics;
    private final IMNodeFactory<IMemMNode> nodeFactory = MNodeFactoryLoader.getInstance().getMemMNodeIMNodeFactory();
    private IMemMNode root;

    public MemMTreeStore(PartialPath rootPath, MemSchemaRegionStatistics regionStatistics) {
        this.root = (IMemMNode)this.nodeFactory.createDatabaseMNode(null, rootPath.getTailNode(), CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs()).getAsMNode();
        this.regionStatistics = regionStatistics;
    }

    private MemMTreeStore(IMemMNode root, MemSchemaRegionStatistics regionStatistics) {
        this.root = root;
        this.regionStatistics = regionStatistics;
    }

    @Override
    public IMemMNode generatePrefix(PartialPath storageGroupPath) {
        IMemMNode res;
        String[] nodes = storageGroupPath.getNodes();
        IMemMNode cur = res = (IMemMNode)this.nodeFactory.createAboveDatabaseMNode(null, nodes[0]);
        for (int i = 1; i < nodes.length - 1; ++i) {
            IMemMNode child = (IMemMNode)this.nodeFactory.createAboveDatabaseMNode((IMNode)cur, nodes[i]);
            cur.addChild(nodes[i], child);
            cur = child;
        }
        this.root.setParent(cur);
        cur.addChild(this.root);
        this.requestMemory(this.root.estimateSize());
        return res;
    }

    @Override
    public IMemMNode getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChild(IMemMNode parent, String name) {
        return parent.hasChild(name);
    }

    @Override
    public IMemMNode getChild(IMemMNode parent, String name) {
        return (IMemMNode)parent.getChild(name);
    }

    @Override
    public IMNodeIterator<IMemMNode> getChildrenIterator(IMemMNode parent) {
        return new MNodeIterator<IMemMNode>(parent.getChildren().values().iterator());
    }

    @Override
    public IMNodeIterator<IMemMNode> getTraverserIterator(IMemMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        if (parent.isDevice()) {
            MemoryTraverserIterator<IMemMNode> iterator = new MemoryTraverserIterator<IMemMNode>(this, parent.getAsDeviceMNode(), templateMap, this.nodeFactory);
            iterator.setSkipPreDeletedSchema(skipPreDeletedSchema);
            return iterator;
        }
        return this.getChildrenIterator(parent);
    }

    @Override
    public IMemMNode addChild(IMemMNode parent, String childName, IMemMNode child) {
        IMemMNode result = (IMemMNode)parent.addChild(childName, child);
        if (result == child) {
            this.requestMemory(child.estimateSize());
        }
        return result;
    }

    @Override
    public void deleteChild(IMemMNode parent, String childName) {
        this.releaseMemory(((IMemMNode)parent.deleteChild(childName)).estimateSize());
    }

    @Override
    public void updateMNode(IMemMNode node) {
    }

    @Override
    public IDeviceMNode<IMemMNode> setToEntity(IMemMNode node) {
        IDeviceMNode<IMemMNode> result = MNodeUtils.setToEntity(node, this.nodeFactory);
        if (result != node) {
            this.regionStatistics.addDevice();
            this.requestMemory(result.estimateSize() - node.estimateSize());
        }
        if (result.isDatabase()) {
            this.root = (IMemMNode)result.getAsMNode();
        }
        return result;
    }

    @Override
    public IMemMNode setToInternal(IDeviceMNode<IMemMNode> entityMNode) {
        IMemMNode result = MNodeUtils.setToInternal(entityMNode, this.nodeFactory);
        if (result != entityMNode) {
            this.regionStatistics.deleteDevice();
            this.releaseMemory(entityMNode.estimateSize() - result.estimateSize());
        }
        if (result.isDatabase()) {
            this.root = result;
        }
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode<IMemMNode> measurementMNode, String alias) {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        measurementMNode.setAlias(alias);
        if (existingAlias != null && alias != null) {
            int delta = alias.length() - existingAlias.length();
            if (delta > 0) {
                this.requestMemory(delta);
            } else if (delta < 0) {
                this.releaseMemory(-delta);
            }
        } else if (alias == null) {
            this.releaseMemory(MNodeSizeEstimator.getAliasBaseSize() + existingAlias.length());
        } else {
            this.requestMemory(MNodeSizeEstimator.getAliasBaseSize() + alias.length());
        }
    }

    @Override
    public void pin(IMemMNode node) {
    }

    @Override
    public void unPin(IMemMNode node) {
    }

    @Override
    public void unPinPath(IMemMNode node) {
    }

    @Override
    public IMTreeStore<IMemMNode> getWithReentrantReadLock() {
        return this;
    }

    @Override
    public void clear() {
        this.root = (IMemMNode)this.nodeFactory.createInternalMNode(null, "root");
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        return MemMTreeSnapshotUtil.createSnapshot(snapshotDir, this);
    }

    public static MemMTreeStore loadFromSnapshot(File snapshotDir, Consumer<IMeasurementMNode<IMemMNode>> measurementProcess, Consumer<IDeviceMNode<IMemMNode>> deviceProcess, MemSchemaRegionStatistics regionStatistics) throws IOException {
        return new MemMTreeStore(MemMTreeSnapshotUtil.loadSnapshot(snapshotDir, measurementProcess, deviceProcess, regionStatistics), regionStatistics);
    }

    private void requestMemory(int size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.requestMemory(size);
        }
    }

    private void releaseMemory(int size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.releaseMemory(size);
        }
    }
}

