/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.rescon;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.schema.ClusterSchemaQuotaLevel;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;

public class DataNodeSchemaQuotaManager {
    private boolean seriesLimit = false;
    private boolean deviceLimit = false;
    private final AtomicLong seriesRemain = new AtomicLong(0L);
    private final AtomicLong deviceRemain = new AtomicLong(0L);

    public void updateRemain(long seriesRemain, long deviceRemain) {
        if (seriesRemain == -1L) {
            this.seriesLimit = false;
        } else {
            this.seriesLimit = true;
            this.seriesRemain.set(seriesRemain);
        }
        if (deviceRemain == -1L) {
            this.deviceLimit = false;
        } else {
            this.deviceLimit = true;
            this.deviceRemain.set(deviceRemain);
        }
    }

    private void checkMeasurementLevel(long acquireNumber) throws SchemaQuotaExceededException {
        if (this.seriesLimit) {
            if (this.seriesRemain.get() <= 0L) {
                throw new SchemaQuotaExceededException(ClusterSchemaQuotaLevel.TIMESERIES);
            }
            this.seriesRemain.addAndGet(-acquireNumber);
        }
    }

    private void checkDeviceLevel() throws SchemaQuotaExceededException {
        if (this.deviceLimit) {
            if (this.deviceRemain.get() <= 0L) {
                throw new SchemaQuotaExceededException(ClusterSchemaQuotaLevel.DEVICE);
            }
            this.deviceRemain.addAndGet(-1L);
        }
    }

    public void check(long acquireSeriesNumber, int acquireDeviceNumber) throws SchemaQuotaExceededException {
        if (acquireDeviceNumber > 0) {
            this.checkDeviceLevel();
        }
        try {
            this.checkMeasurementLevel(acquireSeriesNumber);
        }
        catch (SchemaQuotaExceededException e) {
            if (acquireDeviceNumber > 0) {
                this.deviceRemain.addAndGet(1L);
            }
            throw e;
        }
    }

    public boolean isSeriesLimit() {
        return this.seriesLimit;
    }

    public boolean isDeviceLimit() {
        return this.deviceLimit;
    }

    private DataNodeSchemaQuotaManager() {
    }

    public static DataNodeSchemaQuotaManager getInstance() {
        return DataNodeSchemaQuotaManagerHolder.INSTANCE;
    }

    private static class DataNodeSchemaQuotaManagerHolder {
        private static final DataNodeSchemaQuotaManager INSTANCE = new DataNodeSchemaQuotaManager();

        private DataNodeSchemaQuotaManagerHolder() {
        }
    }
}

