/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.udf;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTFInformationInferrer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDTFInformationInferrer.class);
    protected final String functionName;

    public UDTFInformationInferrer(String functionName) {
        this.functionName = functionName;
    }

    public TSDataType inferOutputType(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        try {
            return UDFDataTypeTransformer.transformToTsDataType((Type)this.reflectAndGetConfigurations(childExpressions, childExpressionDataTypes, attributes).getOutputDataType());
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred during inferring UDF data type", (Throwable)e);
            throw new SemanticException(String.format("Error occurred during inferring UDF data type: %s", System.lineSeparator()) + e);
        }
    }

    public AccessStrategy getAccessStrategy(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        try {
            return this.reflectAndGetConfigurations(childExpressions, childExpressionDataTypes, attributes).getAccessStrategy();
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred during getting UDF access strategy", (Throwable)e);
            throw new SemanticException(String.format("Error occurred during getting UDF access strategy: %s", System.lineSeparator()) + e);
        }
    }

    private UDTFConfigurations reflectAndGetConfigurations(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) throws Exception {
        UDTF udtf = (UDTF)UDFManagementService.getInstance().reflect(this.functionName);
        UDFParameters parameters = new UDFParameters(childExpressions, UDFDataTypeTransformer.transformToUDFDataTypeList(childExpressionDataTypes), attributes);
        udtf.validate(new UDFParameterValidator(parameters));
        UDTFConfigurations configurations = new UDTFConfigurations(ZoneId.systemDefault());
        udtf.beforeStart(parameters, configurations);
        udtf.beforeDestroy();
        return configurations;
    }
}

