/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.AbstractSchemaMergeNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SchemaFetchMergeNode
extends AbstractSchemaMergeNode {
    private List<String> storageGroupList;

    public SchemaFetchMergeNode(PlanNodeId id, List<String> storageGroupList) {
        super(id);
        this.storageGroupList = storageGroupList;
    }

    public List<String> getStorageGroupList() {
        return this.storageGroupList;
    }

    public void setStorageGroupList(List<String> storageGroupList) {
        this.storageGroupList = storageGroupList;
    }

    @Override
    public PlanNode clone() {
        return new SchemaFetchMergeNode(this.getPlanNodeId(), this.storageGroupList);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SCHEMA_FETCH_MERGE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.storageGroupList.size(), (ByteBuffer)byteBuffer);
        for (String storageGroup : this.storageGroupList) {
            ReadWriteIOUtils.write((String)storageGroup, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SCHEMA_FETCH_MERGE.serialize(stream);
        ReadWriteIOUtils.write((int)this.storageGroupList.size(), (OutputStream)stream);
        for (String storageGroup : this.storageGroupList) {
            ReadWriteIOUtils.write((String)storageGroup, (OutputStream)stream);
        }
    }

    public static PlanNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> storageGroupList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            storageGroupList.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SchemaFetchMergeNode(planNodeId, storageGroupList);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSchemaFetchMerge(this, context);
    }

    @Override
    public String toString() {
        return String.format("SchemaFetchMergeNode-%s", this.getPlanNodeId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaFetchMergeNode that = (SchemaFetchMergeNode)o;
        return Objects.equals(this.storageGroupList, that.storageGroupList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.storageGroupList);
    }
}

