/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.IPartitionRelatedNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.SimplePlanNodeRewriter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.HorizontallyConcatNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryCollectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;

public class SourceRewriter
extends SimplePlanNodeRewriter<DistributionPlanContext> {
    private final Analysis analysis;

    public SourceRewriter(Analysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public List<PlanNode> visitMergeSort(MergeSortNode node, DistributionPlanContext context) {
        MergeSortNode newRoot = this.cloneMergeSortNodeWithoutChild(node, context);
        for (int i = 0; i < node.getChildren().size(); ++i) {
            List<PlanNode> rewroteNodes = this.rewrite(node.getChildren().get(i), context);
            rewroteNodes.forEach(newRoot::addChild);
        }
        return Collections.singletonList(newRoot);
    }

    private MergeSortNode cloneMergeSortNodeWithoutChild(MergeSortNode node, DistributionPlanContext context) {
        return new MergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames());
    }

    @Override
    public List<PlanNode> visitSingleDeviceView(SingleDeviceViewNode node, DistributionPlanContext context) {
        if (this.analysis.isDeviceViewSpecialProcess()) {
            List<PlanNode> rewroteChildren = this.rewrite(node.getChild(), context);
            if (rewroteChildren.size() != 1) {
                throw new IllegalStateException("SingleDeviceViewNode have only one child");
            }
            node.setChild(rewroteChildren.get(0));
            return Collections.singletonList(node);
        }
        String device = node.getDevice();
        List<TRegionReplicaSet> regionReplicaSets = this.analysis.getPartitionInfo(device, this.analysis.getGlobalTimeFilter());
        ArrayList<PlanNode> singleDeviceViewList = new ArrayList<PlanNode>();
        for (TRegionReplicaSet tRegionReplicaSet : regionReplicaSets) {
            singleDeviceViewList.add(this.buildSingleDeviceViewNodeInRegion(node, tRegionReplicaSet, context.queryContext));
        }
        return singleDeviceViewList;
    }

    private PlanNode buildSingleDeviceViewNodeInRegion(PlanNode root, TRegionReplicaSet regionReplicaSet, MPPQueryContext context) {
        List<PlanNode> children = root.getChildren().stream().map(child -> this.buildSingleDeviceViewNodeInRegion((PlanNode)child, regionReplicaSet, context)).collect(Collectors.toList());
        PlanNode newRoot = root.cloneWithChildren(children);
        newRoot.setPlanNodeId(context.getQueryId().genPlanNodeId());
        if (newRoot instanceof SourceNode) {
            ((SourceNode)newRoot).setRegionReplicaSet(regionReplicaSet);
        }
        return newRoot;
    }

    @Override
    public List<PlanNode> visitDeviceView(DeviceViewNode node, DistributionPlanContext context) {
        Preconditions.checkArgument((node.getDevices().size() == node.getChildren().size() ? 1 : 0) != 0, (Object)"size of devices and its children in DeviceViewNode should be same");
        if (this.analysis.isDeviceViewSpecialProcess()) {
            return this.processSpecialDeviceView(node, context);
        }
        HashSet<TRegionReplicaSet> relatedDataRegions = new HashSet<TRegionReplicaSet>();
        ArrayList<DeviceViewSplit> deviceViewSplits = new ArrayList<DeviceViewSplit>();
        Map<String, List<String>> outputDeviceToQueriedDevicesMap = this.analysis.getOutputDeviceToQueriedDevicesMap();
        for (int i = 0; i < node.getDevices().size(); ++i) {
            String outputDevice = node.getDevices().get(i);
            PlanNode child = node.getChildren().get(i);
            ArrayList<TRegionReplicaSet> regionReplicaSets = new ArrayList<TRegionReplicaSet>();
            for (String string : outputDeviceToQueriedDevicesMap.get(outputDevice)) {
                regionReplicaSets.addAll(this.analysis.getPartitionInfo(string, this.analysis.getGlobalTimeFilter()));
            }
            deviceViewSplits.add(new DeviceViewSplit(outputDevice, child, regionReplicaSets));
            relatedDataRegions.addAll(regionReplicaSets);
        }
        ArrayList<PlanNode> deviceViewNodeList = new ArrayList<PlanNode>();
        for (TRegionReplicaSet regionReplicaSet : relatedDataRegions) {
            ArrayList<String> devices = new ArrayList<String>();
            ArrayList<PlanNode> children = new ArrayList<PlanNode>();
            for (DeviceViewSplit split : deviceViewSplits) {
                if (!split.needDistributeTo(regionReplicaSet)) continue;
                devices.add(split.device);
                children.add(split.buildPlanNodeInRegion(regionReplicaSet, context.queryContext));
            }
            DeviceViewNode deviceViewNode = this.cloneDeviceViewNodeWithoutChild(node, context);
            for (int i = 0; i < devices.size(); ++i) {
                deviceViewNode.addChildDeviceNode((String)devices.get(i), (PlanNode)children.get(i));
            }
            deviceViewNodeList.add(deviceViewNode);
        }
        if (deviceViewNodeList.size() == 1 || this.analysis.isHasSort() || this.analysis.isUseTopKNode()) {
            return deviceViewNodeList;
        }
        MergeSortNode mergeSortNode = new MergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames());
        for (PlanNode deviceViewNode : deviceViewNodeList) {
            mergeSortNode.addChild(deviceViewNode);
        }
        return Collections.singletonList(mergeSortNode);
    }

    private List<PlanNode> processSpecialDeviceView(DeviceViewNode node, DistributionPlanContext context) {
        DeviceViewNode newRoot = this.cloneDeviceViewNodeWithoutChild(node, context);
        for (int i = 0; i < node.getDevices().size(); ++i) {
            List<PlanNode> rewroteNode = this.rewrite(node.getChildren().get(i), context);
            for (PlanNode planNode : rewroteNode) {
                newRoot.addChildDeviceNode(node.getDevices().get(i), planNode);
            }
        }
        return Collections.singletonList(newRoot);
    }

    private DeviceViewNode cloneDeviceViewNodeWithoutChild(DeviceViewNode node, DistributionPlanContext context) {
        return new DeviceViewNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames(), node.getDeviceToMeasurementIndexesMap());
    }

    @Override
    public List<PlanNode> visitSort(SortNode node, DistributionPlanContext context) {
        this.analysis.setHasSort(true);
        List<PlanNode> children = this.rewrite(node.getChild(), context);
        if (children.size() == 1) {
            node.setChild(children.get(0));
            return Collections.singletonList(node);
        }
        MergeSortNode mergeSortNode = new MergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getOrderByParameter(), node.getOutputColumnNames());
        for (PlanNode child : children) {
            SortNode sortNode = this.cloneSortNodeWithOutChild(node, context);
            sortNode.setChild(child);
            mergeSortNode.addChild(sortNode);
        }
        return Collections.singletonList(mergeSortNode);
    }

    private SortNode cloneSortNodeWithOutChild(SortNode node, DistributionPlanContext context) {
        return new SortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getOrderByParameter());
    }

    @Override
    public List<PlanNode> visitSchemaQueryMerge(SchemaQueryMergeNode node, DistributionPlanContext context) {
        SchemaQueryMergeNode root = (SchemaQueryMergeNode)node.clone();
        SchemaQueryScanNode seed = (SchemaQueryScanNode)node.getChildren().get(0);
        List<PartialPath> pathPatternList = seed.getPathPatternList();
        HashSet regionsOfSystemDatabase = new HashSet();
        if (pathPatternList.size() == 1) {
            TreeSet<TRegionReplicaSet> schemaRegions = new TreeSet<TRegionReplicaSet>(Comparator.comparingInt(region -> region.getRegionId().getId()));
            this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> {
                if (storageGroup.equals("root.__system")) {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> regionsOfSystemDatabase.add(schemaRegionReplicaSet));
                } else {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> schemaRegions.add((TRegionReplicaSet)schemaRegionReplicaSet));
                }
            });
            schemaRegions.forEach(region -> this.addSchemaSourceNode(root, seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
            regionsOfSystemDatabase.forEach(region -> this.addSchemaSourceNode(root, seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
        } else {
            PathPatternTree patternTree = new PathPatternTree();
            for (PartialPath pathPattern : pathPatternList) {
                patternTree.appendPathPattern(pathPattern);
            }
            HashMap<String, Set> storageGroupSchemaRegionMap = new HashMap<String, Set>();
            this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> {
                if (storageGroup.equals("root.__system")) {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> regionsOfSystemDatabase.add(schemaRegionReplicaSet));
                } else {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> storageGroupSchemaRegionMap.computeIfAbsent((String)storageGroup, k -> new HashSet()).add(schemaRegionReplicaSet));
                }
            });
            storageGroupSchemaRegionMap.forEach((storageGroup, schemaRegionSet) -> {
                List<PartialPath> filteredPathPatternList = this.filterPathPattern(patternTree, (String)storageGroup);
                schemaRegionSet.forEach(region -> this.addSchemaSourceNode(root, filteredPathPatternList.size() == 1 ? (PartialPath)filteredPathPatternList.get(0) : seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
            });
            if (!regionsOfSystemDatabase.isEmpty()) {
                List<PartialPath> filteredPathPatternList = this.filterPathPattern(patternTree, "root.__system");
                regionsOfSystemDatabase.forEach(region -> this.addSchemaSourceNode(root, filteredPathPatternList.size() == 1 ? (PartialPath)filteredPathPatternList.get(0) : seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
            }
        }
        return Collections.singletonList(root);
    }

    private List<PartialPath> filterPathPattern(PathPatternTree patternTree, String database) {
        HashSet filteredPathPatternSet = new HashSet();
        try {
            PartialPath storageGroupPath = new PartialPath(database);
            filteredPathPatternSet.addAll(patternTree.getOverlappedPathPatterns(storageGroupPath));
            filteredPathPatternSet.addAll(patternTree.getOverlappedPathPatterns(storageGroupPath.concatNode("**")));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        return new ArrayList<PartialPath>(filteredPathPatternSet);
    }

    private void addSchemaSourceNode(SchemaQueryMergeNode root, PartialPath pathPattern, TRegionReplicaSet schemaRegion, PlanNodeId planNodeId, SchemaQueryScanNode seed) {
        SchemaQueryScanNode schemaQueryScanNode = (SchemaQueryScanNode)seed.clone();
        schemaQueryScanNode.setPlanNodeId(planNodeId);
        schemaQueryScanNode.setRegionReplicaSet(schemaRegion);
        schemaQueryScanNode.setPath(pathPattern);
        root.addChild(schemaQueryScanNode);
    }

    @Override
    public List<PlanNode> visitCountMerge(CountSchemaMergeNode node, DistributionPlanContext context) {
        CountSchemaMergeNode root = (CountSchemaMergeNode)node.clone();
        SchemaQueryScanNode seed = (SchemaQueryScanNode)node.getChildren().get(0);
        HashSet schemaRegions = new HashSet();
        this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> schemaRegions.add(schemaRegionReplicaSet)));
        schemaRegions.forEach(region -> {
            SchemaQueryScanNode schemaQueryScanNode = (SchemaQueryScanNode)seed.clone();
            schemaQueryScanNode.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            schemaQueryScanNode.setRegionReplicaSet((TRegionReplicaSet)region);
            root.addChild(schemaQueryScanNode);
        });
        return Collections.singletonList(root);
    }

    @Override
    public List<PlanNode> visitSeriesScan(SeriesScanNode node, DistributionPlanContext context) {
        TimeJoinNode timeJoinNode = new TimeJoinNode(context.queryContext.getQueryId().genPlanNodeId(), node.getScanOrder());
        return this.processRawSeriesScan(node, context, timeJoinNode);
    }

    @Override
    public List<PlanNode> visitAlignedSeriesScan(AlignedSeriesScanNode node, DistributionPlanContext context) {
        TimeJoinNode timeJoinNode = new TimeJoinNode(context.queryContext.getQueryId().genPlanNodeId(), node.getScanOrder());
        return this.processRawSeriesScan(node, context, timeJoinNode);
    }

    @Override
    public List<PlanNode> visitLastQueryScan(LastQueryScanNode node, DistributionPlanContext context) {
        LastQueryNode mergeNode = new LastQueryNode(context.queryContext.getQueryId().genPlanNodeId(), node.getPartitionTimeFilter(), null, false);
        return this.processRawSeriesScan(node, context, mergeNode);
    }

    @Override
    public List<PlanNode> visitAlignedLastQueryScan(AlignedLastQueryScanNode node, DistributionPlanContext context) {
        LastQueryNode mergeNode = new LastQueryNode(context.queryContext.getQueryId().genPlanNodeId(), node.getPartitionTimeFilter(), null, false);
        return this.processRawSeriesScan(node, context, mergeNode);
    }

    private List<PlanNode> processRawSeriesScan(SeriesSourceNode node, DistributionPlanContext context, MultiChildProcessNode parent) {
        List<PlanNode> sourceNodes = this.splitSeriesSourceNodeByPartition(node, context);
        if (sourceNodes.size() == 1) {
            return sourceNodes;
        }
        sourceNodes.forEach(parent::addChild);
        return Collections.singletonList(parent);
    }

    private List<PlanNode> splitSeriesSourceNodeByPartition(SeriesSourceNode node, DistributionPlanContext context) {
        ArrayList<PlanNode> ret = new ArrayList<PlanNode>();
        List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(node.getPartitionPath(), node.getPartitionTimeFilter());
        if (dataDistribution.size() == 1) {
            node.setRegionReplicaSet(dataDistribution.get(0));
            ret.add(node);
            return ret;
        }
        for (TRegionReplicaSet dataRegion : dataDistribution) {
            SeriesSourceNode split = (SeriesSourceNode)node.clone();
            split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            split.setRegionReplicaSet(dataRegion);
            ret.add(split);
        }
        return ret;
    }

    @Override
    public List<PlanNode> visitSeriesAggregationScan(SeriesAggregationScanNode node, DistributionPlanContext context) {
        return this.processSeriesAggregationSource(node, context);
    }

    @Override
    public List<PlanNode> visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, DistributionPlanContext context) {
        return this.processSeriesAggregationSource(node, context);
    }

    private List<PlanNode> processSeriesAggregationSource(SeriesAggregationSourceNode node, DistributionPlanContext context) {
        List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(node.getPartitionPath(), node.getPartitionTimeFilter());
        if (dataDistribution.size() == 1) {
            node.setRegionReplicaSet(dataDistribution.get(0));
            return Collections.singletonList(node);
        }
        ArrayList<AggregationDescriptor> leafAggDescriptorList = new ArrayList<AggregationDescriptor>();
        node.getAggregationDescriptorList().forEach(descriptor -> leafAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), AggregationStep.PARTIAL, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
        leafAggDescriptorList.forEach(d -> LogicalPlanBuilder.updateTypeProviderByPartialAggregation(d, context.queryContext.getTypeProvider()));
        ArrayList<AggregationDescriptor> rootAggDescriptorList = new ArrayList<AggregationDescriptor>();
        node.getAggregationDescriptorList().forEach(descriptor -> rootAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), context.isRoot ? AggregationStep.FINAL : AggregationStep.INTERMEDIATE, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
        AggregationNode aggregationNode = new AggregationNode(context.queryContext.getQueryId().genPlanNodeId(), rootAggDescriptorList, node.getGroupByTimeParameter(), node.getScanOrder());
        for (TRegionReplicaSet dataRegion : dataDistribution) {
            SeriesAggregationSourceNode split = (SeriesAggregationSourceNode)node.clone();
            split.setAggregationDescriptorList(leafAggDescriptorList);
            split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            split.setRegionReplicaSet(dataRegion);
            aggregationNode.addChild(split);
        }
        return Collections.singletonList(aggregationNode);
    }

    @Override
    public List<PlanNode> visitSchemaFetchMerge(SchemaFetchMergeNode node, DistributionPlanContext context) {
        SchemaFetchMergeNode root = (SchemaFetchMergeNode)node.clone();
        HashMap storageGroupSchemaRegionMap = new HashMap();
        this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> {
            storageGroupSchemaRegionMap.put(storageGroup, new HashSet());
            deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> ((Set)storageGroupSchemaRegionMap.get(storageGroup)).add(schemaRegionReplicaSet));
        });
        for (PlanNode child : node.getChildren()) {
            for (TRegionReplicaSet schemaRegion : (Set)storageGroupSchemaRegionMap.get(((SchemaFetchScanNode)child).getStorageGroup().getFullPath())) {
                SchemaFetchScanNode schemaFetchScanNode = (SchemaFetchScanNode)child.clone();
                schemaFetchScanNode.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                schemaFetchScanNode.setRegionReplicaSet(schemaRegion);
                root.addChild(schemaFetchScanNode);
            }
        }
        return Collections.singletonList(root);
    }

    @Override
    public List<PlanNode> visitLastQuery(LastQueryNode node, DistributionPlanContext context) {
        context.setForceAddParent();
        PlanNode root = this.processRawMultiChildNode(node, context, false);
        if (context.queryMultiRegion) {
            PlanNode newRoot = this.genLastQueryRootNode(node, context);
            if (newRoot instanceof LastQueryMergeNode && !node.needOrderByTimeseries()) {
                this.addSortForEachLastQueryNode(root, Ordering.ASC);
            }
            root.getChildren().forEach(newRoot::addChild);
            return Collections.singletonList(newRoot);
        }
        return Collections.singletonList(root);
    }

    private void addSortForEachLastQueryNode(PlanNode root, Ordering timeseriesOrdering) {
        if (root instanceof LastQueryNode && (root.getChildren().get(0) instanceof LastQueryScanNode || root.getChildren().get(0) instanceof AlignedLastQueryScanNode)) {
            LastQueryNode lastQueryNode = (LastQueryNode)root;
            lastQueryNode.setTimeseriesOrdering(timeseriesOrdering);
            lastQueryNode.setChildren(lastQueryNode.getChildren().stream().sorted(Comparator.comparing(child -> {
                String sortKey = "";
                if (child instanceof LastQueryScanNode) {
                    sortKey = ((LastQueryScanNode)child).getOutputSymbolForSort();
                } else if (child instanceof AlignedLastQueryScanNode) {
                    sortKey = ((AlignedLastQueryScanNode)child).getOutputSymbolForSort();
                }
                return sortKey;
            })).collect(Collectors.toList()));
            lastQueryNode.getChildren().forEach(child -> {
                if (child instanceof AlignedLastQueryScanNode) {
                    ((AlignedLastQueryScanNode)child).getSeriesPath().sortMeasurement(Comparator.naturalOrder());
                }
            });
        } else {
            for (PlanNode child2 : root.getChildren()) {
                this.addSortForEachLastQueryNode(child2, timeseriesOrdering);
            }
        }
    }

    private PlanNode genLastQueryRootNode(LastQueryNode node, DistributionPlanContext context) {
        PlanNodeId id = context.queryContext.getQueryId().genPlanNodeId();
        if (context.oneSeriesInMultiRegion || node.needOrderByTimeseries()) {
            return new LastQueryMergeNode(id, node.getTimeseriesOrdering(), node.isContainsLastTransformNode());
        }
        return new LastQueryCollectNode(id, node.isContainsLastTransformNode());
    }

    @Override
    public List<PlanNode> visitTimeJoin(TimeJoinNode node, DistributionPlanContext context) {
        if (this.containsAggregationSource(node)) {
            return this.planAggregationWithTimeJoin(node, context);
        }
        return Collections.singletonList(this.processRawMultiChildNode(node, context, true));
    }

    private PlanNode processRawMultiChildNode(MultiChildProcessNode node, DistributionPlanContext context, boolean isTimeJoin) {
        MultiChildProcessNode root = (MultiChildProcessNode)node.clone();
        Map<TRegionReplicaSet, List<SourceNode>> sourceGroup = this.groupBySourceNodes(node, context);
        boolean addParent = false;
        for (Map.Entry<TRegionReplicaSet, List<SourceNode>> entry : sourceGroup.entrySet()) {
            boolean appendToRootDirectly;
            TRegionReplicaSet region = entry.getKey();
            List<SourceNode> seriesScanNodes = entry.getValue();
            if (seriesScanNodes.size() == 1 && (!context.isForceAddParent() || isTimeJoin)) {
                root.addChild(seriesScanNodes.get(0));
                continue;
            }
            boolean bl = appendToRootDirectly = sourceGroup.size() == 1 || !addParent && !context.isForceAddParent();
            if (appendToRootDirectly) {
                context.queryContext.setMainFragmentLocatedRegion(region);
                seriesScanNodes.forEach(root::addChild);
                addParent = true;
                continue;
            }
            MultiChildProcessNode parentOfGroup = (MultiChildProcessNode)root.clone();
            parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            seriesScanNodes.forEach(parentOfGroup::addChild);
            root.addChild(parentOfGroup);
        }
        for (PlanNode child : node.getChildren()) {
            if (child instanceof SeriesSourceNode) continue;
            List<PlanNode> children = this.visit(child, context);
            children.forEach(root::addChild);
        }
        return root;
    }

    private Map<TRegionReplicaSet, List<SourceNode>> groupBySourceNodes(MultiChildProcessNode node, DistributionPlanContext context) {
        ArrayList<SeriesSourceNode> sources = new ArrayList<SeriesSourceNode>();
        for (PlanNode child : node.getChildren()) {
            if (!(child instanceof SeriesSourceNode)) continue;
            SeriesSourceNode sourceNode = (SeriesSourceNode)child;
            List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(sourceNode.getPartitionPath(), sourceNode.getPartitionTimeFilter());
            if (dataDistribution.size() > 1) {
                context.setOneSeriesInMultiRegion(true);
            }
            for (TRegionReplicaSet dataRegion : dataDistribution) {
                SeriesSourceNode split = (SeriesSourceNode)sourceNode.clone();
                split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                split.setRegionReplicaSet(dataRegion);
                sources.add(split);
            }
        }
        Map<TRegionReplicaSet, List<SourceNode>> sourceGroup = sources.stream().collect(Collectors.groupingBy(IPartitionRelatedNode::getRegionReplicaSet));
        if (sourceGroup.size() > 1) {
            context.setQueryMultiRegion(true);
        }
        return sourceGroup;
    }

    private boolean containsAggregationSource(TimeJoinNode node) {
        for (PlanNode child : node.getChildren()) {
            if (!(child instanceof SeriesAggregationScanNode) && !(child instanceof AlignedSeriesAggregationScanNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PlanNode> visitSlidingWindowAggregation(SlidingWindowAggregationNode node, DistributionPlanContext context) {
        DistributionPlanContext childContext = context.copy().setRoot(false);
        List<PlanNode> children = this.visit(node.getChild(), childContext);
        PlanNode newRoot = node.clone();
        children.forEach(newRoot::addChild);
        return Collections.singletonList(newRoot);
    }

    private List<PlanNode> planAggregationWithTimeJoin(TimeJoinNode root, DistributionPlanContext context) {
        MultiChildProcessNode newRoot;
        Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup;
        if (context.isRoot) {
            ArrayList<SeriesAggregationSourceNode> sources = new ArrayList<SeriesAggregationSourceNode>();
            HashMap<PartialPath, Integer> regionCountPerSeries = new HashMap<PartialPath, Integer>();
            boolean[] eachSeriesOneRegion = new boolean[]{true};
            sourceGroup = this.splitAggregationSourceByPartition(root, context, sources, eachSeriesOneRegion, regionCountPerSeries);
            if (eachSeriesOneRegion[0]) {
                newRoot = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
            } else {
                ArrayList<AggregationDescriptor> rootAggDescriptorList = new ArrayList<AggregationDescriptor>();
                for (PlanNode child : root.getChildren()) {
                    SeriesAggregationSourceNode handle = (SeriesAggregationSourceNode)child;
                    handle.getAggregationDescriptorList().forEach(descriptor -> rootAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), (Integer)regionCountPerSeries.get(handle.getPartitionPath()) == 1 ? AggregationStep.STATIC : AggregationStep.FINAL, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
                }
                SeriesAggregationSourceNode seed = (SeriesAggregationSourceNode)root.getChildren().get(0);
                newRoot = new AggregationNode(context.queryContext.getQueryId().genPlanNodeId(), rootAggDescriptorList, seed.getGroupByTimeParameter(), seed.getScanOrder());
            }
        } else {
            sourceGroup = this.splitAggregationSourceByPartition(root, context);
            ArrayList<AggregationDescriptor> rootAggDescriptorList = new ArrayList<AggregationDescriptor>();
            for (PlanNode child : root.getChildren()) {
                SeriesAggregationSourceNode handle = (SeriesAggregationSourceNode)child;
                handle.getAggregationDescriptorList().forEach(descriptor -> rootAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), AggregationStep.INTERMEDIATE, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
            }
            SeriesAggregationSourceNode seed = (SeriesAggregationSourceNode)root.getChildren().get(0);
            newRoot = new AggregationNode(context.queryContext.getQueryId().genPlanNodeId(), rootAggDescriptorList, seed.getGroupByTimeParameter(), seed.getScanOrder());
        }
        boolean[] addParent = new boolean[]{false};
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            if (sourceNodes.size() == 1) {
                newRoot.addChild((PlanNode)sourceNodes.get(0));
            } else if (!addParent[0]) {
                sourceNodes.forEach(newRoot::addChild);
                addParent[0] = true;
            } else {
                HorizontallyConcatNode parentOfGroup = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(parentOfGroup::addChild);
                newRoot.addChild(parentOfGroup);
            }
        });
        return Collections.singletonList(newRoot);
    }

    @Override
    public List<PlanNode> visitGroupByLevel(GroupByLevelNode root, DistributionPlanContext context) {
        if (this.shouldUseNaiveAggregation(root)) {
            return this.defaultRewrite(root, context);
        }
        Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup = this.splitAggregationSourceByPartition(root, context);
        boolean containsSlidingWindow = root.getChildren().size() == 1 && root.getChildren().get(0) instanceof SlidingWindowAggregationNode;
        GroupByLevelNode newRoot = containsSlidingWindow ? this.groupSourcesForGroupByLevelWithSlidingWindow(root, (SlidingWindowAggregationNode)root.getChildren().get(0), sourceGroup, context) : this.groupSourcesForGroupByLevel(root, sourceGroup, context);
        HashMap<String, Expression> columnNameToExpression = new HashMap<String, Expression>();
        for (CrossSeriesAggregationDescriptor originalDescriptor : newRoot.getGroupByLevelDescriptors()) {
            for (Expression exp : originalDescriptor.getInputExpressions()) {
                columnNameToExpression.put(exp.getExpressionString(), exp);
            }
            columnNameToExpression.put(originalDescriptor.getOutputExpression().getExpressionString(), originalDescriptor.getOutputExpression());
        }
        context.setColumnNameToExpression(columnNameToExpression);
        this.calculateGroupByLevelNodeAttributes(newRoot, 0, context);
        return Collections.singletonList(newRoot);
    }

    @Override
    public List<PlanNode> visitGroupByTag(GroupByTagNode root, DistributionPlanContext context) {
        Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup = this.splitAggregationSourceByPartition(root, context);
        boolean containsSlidingWindow = root.getChildren().size() == 1 && root.getChildren().get(0) instanceof SlidingWindowAggregationNode;
        return Collections.singletonList(containsSlidingWindow ? this.groupSourcesForGroupByTagWithSlidingWindow(root, (SlidingWindowAggregationNode)root.getChildren().get(0), sourceGroup, context) : this.groupSourcesForGroupByTag(root, sourceGroup, context));
    }

    @Override
    public List<PlanNode> visitLimit(LimitNode node, DistributionPlanContext context) {
        ArrayList<PlanNode> result = new ArrayList<PlanNode>();
        for (PlanNode planNode : this.rewrite(node.getChild(), context)) {
            LimitNode newNode = new LimitNode(context.queryContext.getQueryId().genPlanNodeId(), planNode, node.getLimit());
            result.add(newNode);
        }
        return result;
    }

    private boolean shouldUseNaiveAggregation(PlanNode root) {
        if (root instanceof AggregationNode) {
            return true;
        }
        for (PlanNode child : root.getChildren()) {
            if (!this.shouldUseNaiveAggregation(child)) continue;
            return true;
        }
        return false;
    }

    private GroupByLevelNode groupSourcesForGroupByLevelWithSlidingWindow(GroupByLevelNode root, SlidingWindowAggregationNode slidingWindowNode, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByLevelNode newRoot = (GroupByLevelNode)root.clone();
        ArrayList groups = new ArrayList();
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            SlidingWindowAggregationNode parentOfGroup = (SlidingWindowAggregationNode)slidingWindowNode.clone();
            parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            if (sourceNodes.size() == 1) {
                parentOfGroup.addChild((PlanNode)sourceNodes.get(0));
            } else {
                HorizontallyConcatNode verticallyConcatNode = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(verticallyConcatNode::addChild);
                parentOfGroup.addChild(verticallyConcatNode);
            }
            groups.add(parentOfGroup);
        });
        for (int i = 0; i < groups.size(); ++i) {
            if (i == 0) {
                newRoot.addChild((PlanNode)groups.get(i));
                continue;
            }
            GroupByLevelNode parent = (GroupByLevelNode)root.clone();
            parent.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            parent.addChild((PlanNode)groups.get(i));
            newRoot.addChild(parent);
        }
        return newRoot;
    }

    private GroupByLevelNode groupSourcesForGroupByLevel(GroupByLevelNode root, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByLevelNode newRoot = (GroupByLevelNode)root.clone();
        boolean[] addParent = new boolean[]{false};
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            if (sourceNodes.size() == 1) {
                newRoot.addChild((PlanNode)sourceNodes.get(0));
            } else if (!addParent[0]) {
                sourceNodes.forEach(newRoot::addChild);
                addParent[0] = true;
            } else {
                GroupByLevelNode parentOfGroup = (GroupByLevelNode)root.clone();
                parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(parentOfGroup::addChild);
                newRoot.addChild(parentOfGroup);
            }
        });
        return newRoot;
    }

    private void calculateGroupByLevelNodeAttributes(PlanNode node, int level, DistributionPlanContext context) {
        ArrayList<AggregationDescriptor> descriptorList;
        ProcessNode handle;
        if (node == null) {
            return;
        }
        node.getChildren().forEach(child -> this.calculateGroupByLevelNodeAttributes((PlanNode)child, level + 1, context));
        HashSet childrenOutputColumns = new HashSet();
        node.getChildren().forEach(child -> childrenOutputColumns.addAll(child.getOutputColumnNames()));
        if (node instanceof SlidingWindowAggregationNode) {
            handle = (SlidingWindowAggregationNode)node;
            descriptorList = new ArrayList<AggregationDescriptor>();
            for (AggregationDescriptor originalDescriptor : ((SlidingWindowAggregationNode)handle).getAggregationDescriptorList()) {
                boolean keep = false;
                for (String childColumn : childrenOutputColumns) {
                    for (Expression exp : originalDescriptor.getInputExpressions()) {
                        if (!this.isAggColumnMatchExpression(childColumn, exp)) continue;
                        keep = true;
                    }
                }
                if (!keep) continue;
                descriptorList.add(originalDescriptor);
                LogicalPlanBuilder.updateTypeProviderByPartialAggregation(originalDescriptor, context.queryContext.getTypeProvider());
            }
            ((SlidingWindowAggregationNode)handle).setAggregationDescriptorList(descriptorList);
        }
        if (node instanceof GroupByLevelNode) {
            handle = (GroupByLevelNode)node;
            descriptorList = new ArrayList();
            Map<String, Expression> columnNameToExpression = context.getColumnNameToExpression();
            HashSet<Expression> childrenExpressionSet = new HashSet<Expression>();
            for (String childColumn : childrenOutputColumns) {
                Expression childExpression = columnNameToExpression.get(childColumn.substring(childColumn.indexOf("(") + 1, childColumn.lastIndexOf(")")));
                childrenExpressionSet.add(childExpression);
            }
            for (CrossSeriesAggregationDescriptor originalDescriptor : ((GroupByLevelNode)handle).getGroupByLevelDescriptors()) {
                HashSet<Expression> descriptorExpressions = new HashSet<Expression>();
                if (childrenExpressionSet.contains(originalDescriptor.getOutputExpression())) {
                    descriptorExpressions.add(originalDescriptor.getOutputExpression());
                }
                for (Expression exp : originalDescriptor.getInputExpressions()) {
                    if (!childrenExpressionSet.contains(exp)) continue;
                    descriptorExpressions.add(exp);
                }
                if (descriptorExpressions.isEmpty()) continue;
                CrossSeriesAggregationDescriptor descriptor = originalDescriptor.deepClone();
                descriptor.setStep(level == 0 ? AggregationStep.FINAL : AggregationStep.INTERMEDIATE);
                descriptor.setInputExpressions(new ArrayList<Expression>(descriptorExpressions));
                descriptorList.add(descriptor);
                LogicalPlanBuilder.updateTypeProviderByPartialAggregation(descriptor, context.queryContext.getTypeProvider());
            }
            ((GroupByLevelNode)handle).setGroupByLevelDescriptors(descriptorList);
        }
    }

    private GroupByTagNode groupSourcesForGroupByTagWithSlidingWindow(GroupByTagNode root, SlidingWindowAggregationNode slidingWindowNode, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByTagNode newRoot = (GroupByTagNode)root.clone();
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            SlidingWindowAggregationNode parentOfGroup = (SlidingWindowAggregationNode)slidingWindowNode.clone();
            parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            ArrayList<AggregationDescriptor> childDescriptors = new ArrayList<AggregationDescriptor>();
            sourceNodes.forEach(n -> n.getAggregationDescriptorList().forEach(v -> childDescriptors.add(new AggregationDescriptor(v.getAggregationFuncName(), AggregationStep.INTERMEDIATE, v.getInputExpressions(), v.getInputAttributes()))));
            parentOfGroup.setAggregationDescriptorList(childDescriptors);
            if (sourceNodes.size() == 1) {
                parentOfGroup.addChild((PlanNode)sourceNodes.get(0));
            } else {
                HorizontallyConcatNode verticallyConcatNode = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(verticallyConcatNode::addChild);
                parentOfGroup.addChild(verticallyConcatNode);
            }
            newRoot.addChild(parentOfGroup);
        });
        return newRoot;
    }

    private GroupByTagNode groupSourcesForGroupByTag(GroupByTagNode root, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByTagNode newRoot = (GroupByTagNode)root.clone();
        boolean[] addParent = new boolean[]{false};
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            if (sourceNodes.size() == 1) {
                newRoot.addChild((PlanNode)sourceNodes.get(0));
            } else if (!addParent[0]) {
                sourceNodes.forEach(newRoot::addChild);
                addParent[0] = true;
            } else {
                HorizontallyConcatNode horizontallyConcatNode = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(horizontallyConcatNode::addChild);
                newRoot.addChild(horizontallyConcatNode);
            }
        });
        return newRoot;
    }

    private boolean isAggColumnMatchExpression(String columnName, Expression expression) {
        if (columnName == null) {
            return false;
        }
        return columnName.contains(expression.getExpressionString());
    }

    private Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> splitAggregationSourceByPartition(PlanNode root, DistributionPlanContext context) {
        List<SeriesAggregationSourceNode> rawSources = AggregationNode.findAggregationSourceNode(root);
        ArrayList<SeriesAggregationSourceNode> sources = new ArrayList<SeriesAggregationSourceNode>();
        for (SeriesAggregationSourceNode child : rawSources) {
            this.constructAggregationSourceNodeForPerRegion(context, sources, child);
        }
        for (SeriesAggregationSourceNode source : sources) {
            source.getAggregationDescriptorList().forEach(d -> {
                d.setStep(AggregationStep.PARTIAL);
                LogicalPlanBuilder.updateTypeProviderByPartialAggregation(d, context.queryContext.getTypeProvider());
            });
        }
        return sources.stream().collect(Collectors.groupingBy(IPartitionRelatedNode::getRegionReplicaSet));
    }

    private Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> splitAggregationSourceByPartition(PlanNode root, DistributionPlanContext context, List<SeriesAggregationSourceNode> sources, boolean[] eachSeriesOneRegion, Map<PartialPath, Integer> regionCountPerSeries) {
        List<SeriesAggregationSourceNode> rawSources = AggregationNode.findAggregationSourceNode(root);
        for (SeriesAggregationSourceNode child : rawSources) {
            regionCountPerSeries.put(child.getPartitionPath(), this.constructAggregationSourceNodeForPerRegion(context, sources, child));
        }
        for (SeriesAggregationSourceNode source : sources) {
            boolean isSingle = regionCountPerSeries.get(source.getPartitionPath()) == 1;
            source.getAggregationDescriptorList().forEach(d -> {
                if (isSingle) {
                    d.setStep(AggregationStep.SINGLE);
                } else {
                    eachSeriesOneRegion[0] = false;
                    d.setStep(AggregationStep.PARTIAL);
                    LogicalPlanBuilder.updateTypeProviderByPartialAggregation(d, context.queryContext.getTypeProvider());
                }
            });
        }
        return sources.stream().collect(Collectors.groupingBy(IPartitionRelatedNode::getRegionReplicaSet));
    }

    private int constructAggregationSourceNodeForPerRegion(DistributionPlanContext context, List<SeriesAggregationSourceNode> sources, SeriesAggregationSourceNode child) {
        List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(child.getPartitionPath(), child.getPartitionTimeFilter());
        for (TRegionReplicaSet dataRegion : dataDistribution) {
            SeriesAggregationSourceNode split = (SeriesAggregationSourceNode)child.clone();
            split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            split.setRegionReplicaSet(dataRegion);
            split.setAggregationDescriptorList(child.getAggregationDescriptorList().stream().map(AggregationDescriptor::deepClone).collect(Collectors.toList()));
            sources.add(split);
        }
        return dataDistribution.size();
    }

    public List<PlanNode> visit(PlanNode node, DistributionPlanContext context) {
        return node.accept(this, context);
    }

    private static class DeviceViewSplit {
        protected String device;
        protected PlanNode root;
        protected Set<TRegionReplicaSet> dataPartitions;

        protected DeviceViewSplit(String device, PlanNode root, List<TRegionReplicaSet> dataPartitions) {
            this.device = device;
            this.root = root;
            this.dataPartitions = new HashSet<TRegionReplicaSet>();
            this.dataPartitions.addAll(dataPartitions);
        }

        protected PlanNode buildPlanNodeInRegion(TRegionReplicaSet regionReplicaSet, MPPQueryContext context) {
            return this.buildPlanNodeInRegion(this.root, regionReplicaSet, context);
        }

        protected boolean needDistributeTo(TRegionReplicaSet regionReplicaSet) {
            return this.dataPartitions.contains(regionReplicaSet);
        }

        private PlanNode buildPlanNodeInRegion(PlanNode root, TRegionReplicaSet regionReplicaSet, MPPQueryContext context) {
            List<PlanNode> children = root.getChildren().stream().map(child -> this.buildPlanNodeInRegion((PlanNode)child, regionReplicaSet, context)).collect(Collectors.toList());
            PlanNode newRoot = root.cloneWithChildren(children);
            newRoot.setPlanNodeId(context.getQueryId().genPlanNodeId());
            if (newRoot instanceof SourceNode) {
                ((SourceNode)newRoot).setRegionReplicaSet(regionReplicaSet);
            }
            return newRoot;
        }
    }
}

