/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class ShowNodesInSchemaTemplateTask
implements IConfigTask {
    private final ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement;

    public ShowNodesInSchemaTemplateTask(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement) {
        this.showNodesInSchemaTemplateStatement = showNodesInSchemaTemplateStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showNodesInSchemaTemplate(this.showNodesInSchemaTemplateStatement);
    }

    public static void buildTSBlock(Template template, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showNodesInSchemaTemplateHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        try {
            if (template != null) {
                for (Map.Entry<String, IMeasurementSchema> entry : template.getSchemaMap().entrySet()) {
                    String keyName = entry.getKey();
                    IMeasurementSchema measurementSchema = entry.getValue();
                    builder.getTimeColumnBuilder().writeLong(0L);
                    builder.getColumnBuilder(0).writeBinary(new Binary(keyName, TSFileConfig.STRING_CHARSET));
                    builder.getColumnBuilder(1).writeBinary(new Binary(measurementSchema.getType().name(), TSFileConfig.STRING_CHARSET));
                    builder.getColumnBuilder(2).writeBinary(new Binary(measurementSchema.getEncodingType().name(), TSFileConfig.STRING_CHARSET));
                    builder.getColumnBuilder(3).writeBinary(new Binary(measurementSchema.getCompressor().name(), TSFileConfig.STRING_CHARSET));
                    builder.declarePosition();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowNodesInSchemaTemplateHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

