/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TypeProvider {
    private final Map<String, TSDataType> typeMap;

    public TypeProvider() {
        this.typeMap = new HashMap<String, TSDataType>();
    }

    public TypeProvider(Map<String, TSDataType> typeMap) {
        this.typeMap = typeMap;
    }

    public TSDataType getType(String symbol) {
        return this.typeMap.get(symbol);
    }

    public void setType(String symbol, TSDataType dataType) {
        if (dataType != null) {
            this.typeMap.put(symbol, dataType);
        }
    }

    public boolean containsTypeInfoOf(String path) {
        return this.typeMap.containsKey(path);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.typeMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, TSDataType> entry : this.typeMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)entry.getValue().ordinal(), (ByteBuffer)byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.typeMap.size(), (OutputStream)stream);
        for (Map.Entry<String, TSDataType> entry : this.typeMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((int)entry.getValue().ordinal(), (OutputStream)stream);
        }
    }

    public static TypeProvider deserialize(ByteBuffer byteBuffer) {
        HashMap<String, TSDataType> typeMap = new HashMap<String, TSDataType>();
        for (int mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); mapSize > 0; --mapSize) {
            typeMap.put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), TSDataType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)]);
        }
        return new TypeProvider(typeMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeProvider that = (TypeProvider)o;
        return Objects.equals(this.typeMap, that.typeMap);
    }

    public int hashCode() {
        return Objects.hash(this.typeMap);
    }
}

