/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class AggregationOperator
extends AbstractConsumeAllOperator {
    private final ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private final List<Aggregator> aggregators;
    private final TsBlockBuilder resultTsBlockBuilder;
    private final long maxRetainedSize;
    private final long childrenRetainedSize;

    public AggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, List<Operator> children, long maxReturnSize) {
        super(operatorContext, children);
        this.aggregators = aggregators;
        this.timeRangeIterator = timeRangeIterator;
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.resultTsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.childrenRetainedSize = children.stream().mapToLong(Operator::calculateRetainedSizeAfterCallingNext).sum();
        this.maxRetainedSize = this.childrenRetainedSize == 0L ? 0L : children.stream().mapToLong(Operator::calculateMaxReturnSize).sum();
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        while (System.nanoTime() - start < maxRuntime && (this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange()) && !this.resultTsBlockBuilder.isFull() && this.prepareInput()) {
            if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
                this.curTimeRange = this.timeRangeIterator.nextTimeRange();
                for (Aggregator aggregator : this.aggregators) {
                    aggregator.reset();
                }
            }
            this.calculateNextAggregationResult();
        }
        if (this.resultTsBlockBuilder.getPositionCount() > 0) {
            TsBlock resultTsBlock = this.resultTsBlockBuilder.build();
            this.resultTsBlockBuilder.reset();
            return resultTsBlock;
        }
        return null;
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    private void calculateNextAggregationResult() {
        for (Aggregator aggregator : this.aggregators) {
            aggregator.processTsBlocks(this.inputTsBlocks);
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.inputTsBlocks[i] = this.inputTsBlocks[i].skipFirst();
            if (!this.inputTsBlocks[i].isEmpty()) continue;
            this.inputTsBlocks[i] = null;
        }
        this.updateResultTsBlock();
    }

    private void updateResultTsBlock() {
        this.curTimeRange = null;
        AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime());
    }
}

