/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperator
implements Operator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperator.class);
    protected OperatorContext operatorContext;
    protected long maxReturnSize = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    protected int maxTupleSizeOfTsBlock = -1;
    protected TsBlock resultTsBlock;
    protected TsBlock retainedTsBlock;
    protected int startOffset = 0;

    public void initializeMaxTsBlockLength(TsBlock tsBlock) {
        if (this.maxTupleSizeOfTsBlock != -1) {
            return;
        }
        long oneTupleSize = (tsBlock.getRetainedSizeInBytes() - (long)tsBlock.getTotalInstanceSize()) / (long)tsBlock.getPositionCount();
        if (oneTupleSize > this.maxReturnSize) {
            this.maxTupleSizeOfTsBlock = 1;
            LOGGER.warn("Only one tuple can be sent each time caused by limited memory");
        } else {
            this.maxTupleSizeOfTsBlock = (int)(this.maxReturnSize / oneTupleSize);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("maxTupleSizeOfTsBlock is\uff1a{}", (Object)this.maxTupleSizeOfTsBlock);
        }
    }

    public TsBlock checkTsBlockSizeAndGetResult() {
        if (this.resultTsBlock == null) {
            throw new IllegalArgumentException("Result tsBlock cannot be null");
        }
        if (this.maxTupleSizeOfTsBlock == -1) {
            this.initializeMaxTsBlockLength(this.resultTsBlock);
        }
        if (this.resultTsBlock.getPositionCount() <= this.maxTupleSizeOfTsBlock) {
            TsBlock res = this.resultTsBlock;
            this.resultTsBlock = null;
            return res;
        }
        this.retainedTsBlock = this.resultTsBlock;
        this.resultTsBlock = null;
        return this.getResultFromRetainedTsBlock();
    }

    public TsBlock getResultFromRetainedTsBlock() {
        TsBlock res;
        if (this.maxTupleSizeOfTsBlock == -1) {
            this.initializeMaxTsBlockLength(this.retainedTsBlock);
        }
        if (this.retainedTsBlock.getPositionCount() - this.startOffset <= this.maxTupleSizeOfTsBlock) {
            res = this.retainedTsBlock.subTsBlock(this.startOffset);
            this.retainedTsBlock = null;
            this.startOffset = 0;
        } else {
            res = this.retainedTsBlock.getRegion(this.startOffset, this.maxTupleSizeOfTsBlock);
            this.startOffset += this.maxTupleSizeOfTsBlock;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current tsBlock size is : {}", (Object)res.getRetainedSizeInBytes());
        }
        return res;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }
}

