/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.load;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.queryengine.execution.load.AlignedChunkData;
import org.apache.iotdb.db.queryengine.execution.load.ChunkData;
import org.apache.iotdb.db.queryengine.execution.load.DeletionData;
import org.apache.iotdb.db.queryengine.execution.load.TsFileData;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSplitter {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSplitter.class);
    private final File tsFile;
    private final Function<TsFileData, Boolean> consumer;

    public TsFileSplitter(File tsFile, Function<TsFileData, Boolean> consumer) {
        this.tsFile = tsFile;
        this.consumer = consumer;
    }

    public void splitTsFileByDataPartition() throws IOException, IllegalStateException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFile.getAbsolutePath());){
            byte marker;
            TreeMap<Long, List<Deletion>> offset2Deletions = new TreeMap<Long, List<Deletion>>();
            this.getAllModification(offset2Deletions);
            if (!this.checkMagic(reader)) {
                throw new TsFileRuntimeException(String.format("Magic String check error when parsing TsFile %s.", this.tsFile.getPath()));
            }
            reader.position((long)"TsFile".getBytes().length + 1L);
            String curDevice = null;
            boolean isTimeChunkNeedDecode = true;
            HashMap<Integer, List<AlignedChunkData>> pageIndex2ChunkData = new HashMap<Integer, List<AlignedChunkData>>();
            HashMap<Integer, long[]> pageIndex2Times = null;
            HashMap<Long, IChunkMetadata> offset2ChunkMetadata = new HashMap<Long, IChunkMetadata>();
            this.getChunkMetadata(reader, offset2ChunkMetadata);
            block11: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: {
                        long chunkOffset = reader.position();
                        this.consumeAllAlignedChunkData(chunkOffset, pageIndex2ChunkData);
                        this.handleModification(offset2Deletions, chunkOffset);
                        ChunkHeader header = reader.readChunkHeader(marker);
                        String measurementId = header.getMeasurementID();
                        if (header.getDataSize() == 0) {
                            throw new TsFileRuntimeException(String.format("Empty Nonaligned Chunk or Time Chunk with offset %d in TsFile %s.", chunkOffset, this.tsFile.getPath()));
                        }
                        boolean isAligned = (header.getChunkType() & 0xFFFFFF80) == -128;
                        IChunkMetadata chunkMetadata = (IChunkMetadata)offset2ChunkMetadata.get(chunkOffset - 1L);
                        if (chunkMetadata == null) {
                            reader.readChunk(-1L, header.getDataSize());
                            continue block11;
                        }
                        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getStartTime());
                        ChunkData chunkData = ChunkData.createChunkData(isAligned, curDevice, header, timePartitionSlot);
                        if (!this.needDecodeChunk(chunkMetadata)) {
                            chunkData.setNotDecode();
                            chunkData.writeEntireChunk(reader.readChunk(-1L, header.getDataSize()), chunkMetadata);
                            if (isAligned) {
                                isTimeChunkNeedDecode = false;
                                pageIndex2ChunkData.computeIfAbsent(1, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                                continue block11;
                            }
                            this.consumeChunkData(measurementId, chunkOffset, chunkData);
                            continue block11;
                        }
                        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                        int dataSize = header.getDataSize();
                        int pageIndex = 0;
                        if (isAligned) {
                            isTimeChunkNeedDecode = true;
                            pageIndex2Times = new HashMap<Integer, long[]>();
                        }
                        while (dataSize > 0) {
                            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
                            long pageDataSize = pageHeader.getSerializedPageSize();
                            if (!this.needDecodePage(pageHeader, chunkMetadata)) {
                                long startTime = pageHeader.getStatistics() == null ? chunkMetadata.getStartTime() : pageHeader.getStartTime();
                                TTimePartitionSlot pageTimePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)startTime);
                                if (!timePartitionSlot.equals(pageTimePartitionSlot)) {
                                    if (!isAligned) {
                                        this.consumeChunkData(measurementId, chunkOffset, chunkData);
                                    }
                                    timePartitionSlot = pageTimePartitionSlot;
                                    chunkData = ChunkData.createChunkData(isAligned, curDevice, header, timePartitionSlot);
                                }
                                if (isAligned) {
                                    pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                                }
                                chunkData.writeEntirePage(pageHeader, reader.readCompressedPage(pageHeader));
                            } else {
                                ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                                Pair<long[], Object[]> tvArray = this.decodePage(isAligned, pageData, pageHeader, defaultTimeDecoder, valueDecoder, header);
                                long[] times = (long[])tvArray.left;
                                Object[] values = (Object[])tvArray.right;
                                if (isAligned) {
                                    pageIndex2Times.put(pageIndex, times);
                                }
                                int satisfiedLength = 0;
                                long endTime = timePartitionSlot.getStartTime() + TimePartitionUtils.getTimePartitionInterval();
                                for (int i = 0; i < times.length; ++i) {
                                    if (times[i] >= endTime) {
                                        chunkData.writeDecodePage(times, values, satisfiedLength);
                                        if (isAligned) {
                                            pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                                        } else {
                                            this.consumeChunkData(measurementId, chunkOffset, chunkData);
                                        }
                                        timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)times[i]);
                                        satisfiedLength = 0;
                                        endTime = timePartitionSlot.getStartTime() + TimePartitionUtils.getTimePartitionInterval();
                                        chunkData = ChunkData.createChunkData(isAligned, curDevice, header, timePartitionSlot);
                                    }
                                    ++satisfiedLength;
                                }
                                chunkData.writeDecodePage(times, values, satisfiedLength);
                                if (isAligned) {
                                    pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                                }
                            }
                            ++pageIndex;
                            dataSize = (int)((long)dataSize - pageDataSize);
                        }
                        if (isAligned) continue block11;
                        this.consumeChunkData(measurementId, chunkOffset, chunkData);
                        continue block11;
                    }
                    case 65: 
                    case 69: {
                        long chunkOffset = reader.position();
                        IChunkMetadata chunkMetadata = (IChunkMetadata)offset2ChunkMetadata.get(chunkOffset - 1L);
                        ChunkHeader header = reader.readChunkHeader(marker);
                        if (chunkMetadata == null) {
                            reader.readChunk(-1L, header.getDataSize());
                            continue block11;
                        }
                        if (header.getDataSize() == 0) {
                            this.handleEmptyValueChunk(header, pageIndex2ChunkData, chunkMetadata, isTimeChunkNeedDecode);
                            continue block11;
                        }
                        if (!isTimeChunkNeedDecode) {
                            AlignedChunkData alignedChunkData = (AlignedChunkData)((List)pageIndex2ChunkData.get(1)).get(0);
                            alignedChunkData.addValueChunk(header);
                            alignedChunkData.writeEntireChunk(reader.readChunk(-1L, header.getDataSize()), chunkMetadata);
                            continue block11;
                        }
                        HashSet<AlignedChunkData> allChunkData = new HashSet<AlignedChunkData>();
                        int dataSize = header.getDataSize();
                        int pageIndex = 0;
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                        while (dataSize > 0) {
                            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
                            List alignedChunkDataList = (List)pageIndex2ChunkData.get(pageIndex);
                            for (AlignedChunkData alignedChunkData : alignedChunkDataList) {
                                if (allChunkData.contains(alignedChunkData)) continue;
                                alignedChunkData.addValueChunk(header);
                                allChunkData.add(alignedChunkData);
                            }
                            if (alignedChunkDataList.size() == 1) {
                                ((AlignedChunkData)alignedChunkDataList.get(0)).writeEntirePage(pageHeader, reader.readCompressedPage(pageHeader));
                            } else {
                                long[] times = (long[])pageIndex2Times.get(pageIndex);
                                TsPrimitiveType[] values = this.decodeValuePage(reader, header, pageHeader, times, valueDecoder);
                                for (AlignedChunkData alignedChunkData : alignedChunkDataList) {
                                    alignedChunkData.writeDecodeValuePage(times, values, header.getDataType());
                                }
                            }
                            long pageDataSize = pageHeader.getSerializedPageSize();
                            ++pageIndex;
                            dataSize = (int)((long)dataSize - pageDataSize);
                        }
                        continue block11;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        curDevice = chunkGroupHeader.getDeviceID();
                        continue block11;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block11;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            this.consumeAllAlignedChunkData(reader.position(), pageIndex2ChunkData);
            this.handleModification(offset2Deletions, Long.MAX_VALUE);
        }
    }

    private void getAllModification(Map<Long, List<Deletion>> offset2Deletions) throws IOException {
        try (ModificationFile modificationFile = new ModificationFile(this.tsFile.getAbsolutePath() + ".mods");){
            for (Modification modification : modificationFile.getModifications()) {
                offset2Deletions.computeIfAbsent(modification.getFileOffset(), o -> new ArrayList()).add((Deletion)modification);
            }
        }
    }

    private boolean checkMagic(TsFileSequenceReader reader) throws IOException {
        String magic = reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)reader.getFileName());
            return false;
        }
        byte versionNumber = reader.readVersionNumber();
        if (versionNumber != 3) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)reader.getFileName());
            return false;
        }
        if (!reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)reader.getFileName());
            return false;
        }
        return true;
    }

    private void getChunkMetadata(TsFileSequenceReader reader, Map<Long, IChunkMetadata> offset2ChunkMetadata) throws IOException {
        Map device2Metadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : device2Metadata.entrySet()) {
            for (TimeseriesMetadata timeseriesMetadata : (List)entry.getValue()) {
                for (IChunkMetadata chunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
                    offset2ChunkMetadata.put(chunkMetadata.getOffsetOfChunkHeader(), chunkMetadata);
                }
            }
        }
    }

    private void handleModification(TreeMap<Long, List<Deletion>> offset2Deletions, long chunkOffset) {
        while (!offset2Deletions.isEmpty() && offset2Deletions.firstEntry().getKey() <= chunkOffset) {
            offset2Deletions.pollFirstEntry().getValue().forEach(o -> this.consumer.apply(new DeletionData((Deletion)o)));
        }
    }

    private void consumeAllAlignedChunkData(long offset, Map<Integer, List<AlignedChunkData>> pageIndex2ChunkData) {
        if (pageIndex2ChunkData.isEmpty()) {
            return;
        }
        HashSet allChunkData = new HashSet();
        for (Map.Entry<Integer, List<AlignedChunkData>> entry : pageIndex2ChunkData.entrySet()) {
            allChunkData.addAll(entry.getValue());
        }
        for (ChunkData chunkData : allChunkData) {
            if (!Boolean.FALSE.equals(this.consumer.apply(chunkData))) continue;
            throw new IllegalStateException(String.format("Consume aligned chunk data error, next chunk offset: %d, chunkData: %s", offset, chunkData));
        }
        pageIndex2ChunkData.clear();
    }

    private void consumeChunkData(String measurement, long offset, ChunkData chunkData) {
        if (Boolean.FALSE.equals(this.consumer.apply(chunkData))) {
            throw new IllegalStateException(String.format("Consume chunkData error, chunk offset: %d, measurement: %s, chunkData: %s", offset, measurement, chunkData));
        }
    }

    private boolean needDecodeChunk(IChunkMetadata chunkMetadata) {
        return !TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getStartTime()).equals(TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getEndTime()));
    }

    private boolean needDecodePage(PageHeader pageHeader, IChunkMetadata chunkMetadata) {
        if (pageHeader.getStatistics() == null) {
            return !TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getStartTime()).equals(TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getEndTime()));
        }
        return !TimePartitionUtils.getTimePartitionSlot((long)pageHeader.getStartTime()).equals(TimePartitionUtils.getTimePartitionSlot((long)pageHeader.getEndTime()));
    }

    private Pair<long[], Object[]> decodePage(boolean isAligned, ByteBuffer pageData, PageHeader pageHeader, Decoder timeDecoder, Decoder valueDecoder, ChunkHeader chunkHeader) throws IOException {
        if (isAligned) {
            TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, timeDecoder);
            long[] times = timePageReader.getNextTimeBatch();
            return new Pair((Object)times, (Object)new Object[times.length]);
        }
        valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, chunkHeader.getDataType(), valueDecoder, timeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        long[] times = new long[batchData.length()];
        Object[] values = new Object[batchData.length()];
        int index = 0;
        while (batchData.hasCurrent()) {
            times[index] = batchData.currentTime();
            values[index++] = batchData.currentValue();
            batchData.next();
        }
        return new Pair((Object)times, (Object)values);
    }

    private void handleEmptyValueChunk(ChunkHeader header, Map<Integer, List<AlignedChunkData>> pageIndex2ChunkData, IChunkMetadata chunkMetadata, boolean isTimeChunkNeedDecode) throws IOException {
        HashSet<AlignedChunkData> allChunkData = new HashSet<AlignedChunkData>();
        for (Map.Entry<Integer, List<AlignedChunkData>> entry : pageIndex2ChunkData.entrySet()) {
            for (AlignedChunkData alignedChunkData : entry.getValue()) {
                if (allChunkData.contains(alignedChunkData)) continue;
                alignedChunkData.addValueChunk(header);
                if (!isTimeChunkNeedDecode) {
                    alignedChunkData.writeEntireChunk(ByteBuffer.allocate(0), chunkMetadata);
                }
                allChunkData.add(alignedChunkData);
            }
        }
    }

    private boolean isEmptyPage(PageHeader pageHeader) {
        return pageHeader.getUncompressedSize() == 0 && pageHeader.getCompressedSize() == 0 && pageHeader.getStatistics() == null;
    }

    private TsPrimitiveType[] decodeValuePage(TsFileSequenceReader reader, ChunkHeader chunkHeader, PageHeader pageHeader, long[] times, Decoder valueDecoder) throws IOException {
        if (pageHeader.getSerializedPageSize() == 0) {
            return new TsPrimitiveType[times.length];
        }
        valueDecoder.reset();
        ByteBuffer pageData = reader.readPage(pageHeader, chunkHeader.getCompressionType());
        ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, chunkHeader.getDataType(), valueDecoder);
        return valuePageReader.nextValueBatch(times);
    }
}

