/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.load;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.db.queryengine.execution.load.AlignedChunkData;
import org.apache.iotdb.db.queryengine.execution.load.NonAlignedChunkData;
import org.apache.iotdb.db.queryengine.execution.load.TsFileData;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public interface ChunkData
extends TsFileData {
    public String getDevice();

    public TTimePartitionSlot getTimePartitionSlot();

    public void setNotDecode();

    public boolean isAligned();

    public void writeEntireChunk(ByteBuffer var1, IChunkMetadata var2) throws IOException;

    public void writeEntirePage(PageHeader var1, ByteBuffer var2) throws IOException;

    public void writeDecodePage(long[] var1, Object[] var2, int var3) throws IOException;

    @Override
    default public boolean isModification() {
        return false;
    }

    public static ChunkData deserialize(InputStream stream) throws PageException, IOException {
        boolean isAligned = ReadWriteIOUtils.readBool((InputStream)stream);
        return isAligned ? AlignedChunkData.deserialize(stream) : NonAlignedChunkData.deserialize(stream);
    }

    public static ChunkData createChunkData(boolean isAligned, String device, ChunkHeader chunkHeader, TTimePartitionSlot timePartitionSlot) {
        return isAligned ? new AlignedChunkData(device, chunkHeader, timePartitionSlot) : new NonAlignedChunkData(device, chunkHeader, timePartitionSlot);
    }
}

