/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import io.airlift.stats.CounterStat;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.exception.CpuNotEnoughException;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.driver.IDriver;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.schedule.IDriverScheduler;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceExecution.class);
    private final FragmentInstanceId instanceId;
    private final FragmentInstanceContext context;
    private List<IDriver> drivers;
    private ISink sink;
    private final FragmentInstanceStateMachine stateMachine;
    private final long timeoutInMs;
    private final MPPDataExchangeManager exchangeManager;

    public static FragmentInstanceExecution createFragmentInstanceExecution(IDriverScheduler scheduler, FragmentInstanceId instanceId, FragmentInstanceContext context, List<IDriver> drivers, ISink sinkHandle, FragmentInstanceStateMachine stateMachine, CounterStat failedInstances, long timeOut, MPPDataExchangeManager exchangeManager) throws CpuNotEnoughException, MemoryNotEnoughException {
        FragmentInstanceExecution execution = new FragmentInstanceExecution(instanceId, context, drivers, sinkHandle, stateMachine, timeOut, exchangeManager);
        execution.initialize(failedInstances, scheduler);
        scheduler.submitDrivers(instanceId.getQueryId(), drivers, timeOut, context.getSessionInfo());
        return execution;
    }

    private FragmentInstanceExecution(FragmentInstanceId instanceId, FragmentInstanceContext context, List<IDriver> drivers, ISink sink, FragmentInstanceStateMachine stateMachine, long timeoutInMs, MPPDataExchangeManager exchangeManager) {
        this.instanceId = instanceId;
        this.context = context;
        this.drivers = drivers;
        this.sink = sink;
        this.stateMachine = stateMachine;
        this.timeoutInMs = timeoutInMs;
        this.exchangeManager = exchangeManager;
    }

    public FragmentInstanceState getInstanceState() {
        return this.stateMachine.getState();
    }

    public FragmentInstanceInfo getInstanceInfo() {
        return new FragmentInstanceInfo(this.stateMachine.getState(), this.context.getEndTime(), this.context.getFailedCause(), this.context.getFailureInfoList());
    }

    public long getStartTime() {
        return this.context.getStartTime();
    }

    public long getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public FragmentInstanceStateMachine getStateMachine() {
        return this.stateMachine;
    }

    private void initialize(CounterStat failedInstances, IDriverScheduler scheduler) {
        Objects.requireNonNull(failedInstances, "failedInstances is null");
        this.stateMachine.addStateChangeListener(newState -> {
            try (SetThreadName threadName = new SetThreadName(this.instanceId.getFullId());){
                if (!newState.isDone()) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Enter the stateChangeListener");
                }
                if (newState == FragmentInstanceState.FAILED) {
                    failedInstances.update(1L);
                }
                this.clearShuffleSinkHandle((FragmentInstanceState)((Object)newState));
                this.deleteTmpFile();
                for (IDriver driver : this.drivers) {
                    driver.close();
                }
                this.drivers = null;
                this.context.releaseResourceWhenAllDriversAreClosed();
                this.exchangeManager.deRegisterFragmentInstanceFromMemoryPool(this.instanceId.getQueryId().getId(), this.instanceId.getFragmentInstanceId());
                if (newState.isFailed()) {
                    scheduler.abortFragmentInstance(this.instanceId);
                }
            }
            catch (Throwable t) {
                try (SetThreadName threadName2 = new SetThreadName(this.instanceId.getFullId());){
                    LOGGER.error("Errors happened while trying to finish FI, resource may already leak!", t);
                }
            }
        });
    }

    private void clearShuffleSinkHandle(FragmentInstanceState newState) {
        if (newState.isFailed()) {
            this.sink.abort();
        } else {
            this.sink.close();
        }
        this.sink = null;
    }

    private void deleteTmpFile() {
        String tmpFilePath;
        File tmpFile;
        if (this.context.mayHaveTmpFile() && (tmpFile = new File(tmpFilePath = IoTDBDescriptor.getInstance().getConfig().getSortTmpDir() + File.separator + this.context.getId().getFullId() + File.separator)).exists()) {
            FileUtils.deleteDirectory((File)tmpFile);
        }
    }
}

