/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FragmentInstanceId {
    private final String fullId;
    private final QueryId queryId;
    private final PlanFragmentId fragmentId;
    private final String instanceId;

    public FragmentInstanceId(PlanFragmentId fragmentId, String instanceId) {
        this.queryId = fragmentId.getQueryId();
        this.fragmentId = fragmentId;
        this.instanceId = instanceId;
        this.fullId = FragmentInstanceId.createFullId(fragmentId.getQueryId().getId(), fragmentId.getId(), instanceId);
    }

    public String getFullId() {
        return this.fullId;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public PlanFragmentId getFragmentId() {
        return this.fragmentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getFragmentInstanceId() {
        return this.fragmentId.getId() + "." + this.instanceId;
    }

    public String toString() {
        return this.fullId;
    }

    public static FragmentInstanceId deserialize(ByteBuffer byteBuffer) {
        return new FragmentInstanceId(PlanFragmentId.deserialize(byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.fragmentId.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.instanceId, (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.fragmentId.serialize(stream);
        ReadWriteIOUtils.write((String)this.instanceId, (OutputStream)stream);
    }

    public TFragmentInstanceId toThrift() {
        return new TFragmentInstanceId(this.queryId.getId(), this.fragmentId.getId(), this.instanceId);
    }

    public static FragmentInstanceId fromThrift(TFragmentInstanceId tFragmentInstanceId) {
        return new FragmentInstanceId(new PlanFragmentId(tFragmentInstanceId.queryId, tFragmentInstanceId.fragmentId), tFragmentInstanceId.instanceId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentInstanceId that = (FragmentInstanceId)o;
        return Objects.equals(this.fullId, that.fullId) && Objects.equals(this.queryId, that.queryId) && Objects.equals(this.fragmentId, that.fragmentId) && Objects.equals(this.instanceId, that.instanceId);
    }

    public int hashCode() {
        return Objects.hash(this.fullId, this.queryId, this.fragmentId, this.instanceId);
    }

    public static String createFullId(String queryId, int fragmentId, String instanceId) {
        return queryId + "." + fragmentId + "." + instanceId;
    }

    public static String createFragmentInstanceIdFromTFragmentInstanceId(TFragmentInstanceId tFragmentInstanceId) {
        return tFragmentInstanceId.getFragmentId() + "." + tFragmentInstanceId.getInstanceId();
    }
}

