/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.task.PipeTask;
import org.apache.iotdb.db.pipe.task.PipeTaskBuilder;

public class PipeBuilder {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final PipeMeta pipeMeta;

    public PipeBuilder(PipeMeta pipeMeta) {
        this.pipeMeta = pipeMeta;
    }

    public Map<TConsensusGroupId, PipeTask> build() {
        PipeStaticMeta pipeStaticMeta = this.pipeMeta.getStaticMeta();
        HashMap<TConsensusGroupId, PipeTask> consensusGroupIdToPipeTaskMap = new HashMap<TConsensusGroupId, PipeTask>();
        PipeRuntimeMeta pipeRuntimeMeta = this.pipeMeta.getRuntimeMeta();
        for (Map.Entry consensusGroupIdToPipeTaskMeta : pipeRuntimeMeta.getConsensusGroupId2TaskMetaMap().entrySet()) {
            if (((PipeTaskMeta)consensusGroupIdToPipeTaskMeta.getValue()).getLeaderDataNodeId() != CONFIG.getDataNodeId()) continue;
            consensusGroupIdToPipeTaskMap.put((TConsensusGroupId)consensusGroupIdToPipeTaskMeta.getKey(), new PipeTaskBuilder(pipeStaticMeta, (TConsensusGroupId)consensusGroupIdToPipeTaskMeta.getKey(), (PipeTaskMeta)consensusGroupIdToPipeTaskMeta.getValue()).build());
        }
        return consensusGroupIdToPipeTaskMap;
    }
}

