/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.legacy.loader;

import java.io.File;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.pipe.receiver.legacy.loader.ILoader;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileLoader
implements ILoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileLoader.class);
    private final File tsFile;
    private final String database;

    public TsFileLoader(File tsFile, String database) {
        this.tsFile = tsFile;
        this.database = database;
    }

    @Override
    public void load() {
        try {
            LoadTsFileStatement statement = new LoadTsFileStatement(this.tsFile.getAbsolutePath());
            statement.setDeleteAfterLoad(true);
            statement.setDatabaseLevel(this.parseSgLevel());
            statement.setVerifySchema(true);
            statement.setAutoCreateDatabase(false);
            long queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().execute(statement, queryId, null, "", PARTITION_FETCHER, SCHEMA_FETCHER, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.error("Load TsFile {} error, statement: {}.", (Object)this.tsFile.getPath(), (Object)statement);
                LOGGER.error("Load TsFile result status : {}.", (Object)result.status);
                throw new LoadFileException(String.format("Can not execute load TsFile statement: %s", statement));
            }
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage());
        }
    }

    private int parseSgLevel() throws IllegalPathException {
        return new PartialPath(this.database).getNodeLength() - 1;
    }
}

