/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.extractor.realtime.assigner.PipeDataRegionAssigner;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeAssignerMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeAssignerMetrics.class);
    private AbstractMetricService metricService;
    private final Map<String, PipeDataRegionAssigner> assignerMap = new HashMap<String, PipeDataRegionAssigner>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        PipeAssignerMetrics pipeAssignerMetrics = this;
        synchronized (pipeAssignerMetrics) {
            for (String dataRegionId : this.assignerMap.keySet()) {
                this.createMetrics(dataRegionId);
            }
        }
    }

    private void createMetrics(String dataRegionId) {
        this.createAutoGauge(dataRegionId);
    }

    private void createAutoGauge(String dataRegionId) {
        this.metricService.createAutoGauge(Metric.UNASSIGNED_HEARTBEAT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.assignerMap.get(dataRegionId), PipeDataRegionAssigner::getPipeHeartbeatEventCount, new String[]{Tag.REGION.toString(), dataRegionId});
        this.metricService.createAutoGauge(Metric.UNASSIGNED_TABLET_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.assignerMap.get(dataRegionId), PipeDataRegionAssigner::getTabletInsertionEventCount, new String[]{Tag.REGION.toString(), dataRegionId});
        this.metricService.createAutoGauge(Metric.UNASSIGNED_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.assignerMap.get(dataRegionId), PipeDataRegionAssigner::getTsFileInsertionEventCount, new String[]{Tag.REGION.toString(), dataRegionId});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet dataRegionIds = ImmutableSet.copyOf(this.assignerMap.keySet());
        for (String dataRegionId : dataRegionIds) {
            this.deregister(dataRegionId);
        }
        if (!this.assignerMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe assigner metrics, assigner map not empty");
        }
    }

    private void removeMetrics(String dataRegionId) {
        this.removeAutoGauge(dataRegionId);
    }

    private void removeAutoGauge(String dataRegionId) {
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNASSIGNED_HEARTBEAT_COUNT.toString(), new String[]{Tag.REGION.toString(), dataRegionId});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNASSIGNED_TABLET_COUNT.toString(), new String[]{Tag.REGION.toString(), dataRegionId});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNASSIGNED_TSFILE_COUNT.toString(), new String[]{Tag.REGION.toString(), dataRegionId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull PipeDataRegionAssigner pipeDataRegionAssigner) {
        String dataRegionId = pipeDataRegionAssigner.getDataRegionId();
        PipeAssignerMetrics pipeAssignerMetrics = this;
        synchronized (pipeAssignerMetrics) {
            this.assignerMap.putIfAbsent(dataRegionId, pipeDataRegionAssigner);
            if (Objects.nonNull(this.metricService)) {
                this.createMetrics(dataRegionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String dataRegionId) {
        PipeAssignerMetrics pipeAssignerMetrics = this;
        synchronized (pipeAssignerMetrics) {
            if (!this.assignerMap.containsKey(dataRegionId)) {
                LOGGER.warn("Failed to deregister pipe assigner metrics, PipeDataRegionAssigner({}) does not exist", (Object)dataRegionId);
                return;
            }
            if (Objects.nonNull(this.metricService)) {
                this.removeMetrics(dataRegionId);
            }
            this.assignerMap.remove(dataRegionId);
        }
    }

    public static PipeAssignerMetrics getInstance() {
        return PipeAssignerMetricsHolder.INSTANCE;
    }

    private PipeAssignerMetrics() {
    }

    private static class PipeAssignerMetricsHolder {
        private static final PipeAssignerMetrics INSTANCE = new PipeAssignerMetrics();

        private PipeAssignerMetricsHolder() {
        }
    }
}

