/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;

public abstract class PipeRealtimeDataRegionExtractor
implements PipeExtractor {
    protected String pipeName;
    protected String dataRegionId;
    protected PipeTaskMeta pipeTaskMeta;
    protected String pattern;
    private boolean isDbNameCoveredByPattern = false;
    protected boolean isForwardingPipeRequests;
    protected final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue();
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private String taskID;

    protected PipeRealtimeDataRegionExtractor() {
    }

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        String databaseName;
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeName = environment.getPipeName();
        this.dataRegionId = String.valueOf(environment.getRegionId());
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.pattern = parameters.getStringOrDefault(Arrays.asList("extractor.pattern", "source.pattern"), "root");
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(environment.getRegionId()));
        if (dataRegion != null && (databaseName = dataRegion.getDatabaseName()) != null && this.pattern.length() <= databaseName.length() && databaseName.startsWith(this.pattern)) {
            this.isDbNameCoveredByPattern = true;
        }
        this.isForwardingPipeRequests = true;
        long creationTime = configuration.getRuntimeEnvironment().getCreationTime();
        this.taskID = this.pipeName + "_" + this.dataRegionId + "_" + creationTime;
    }

    public void start() throws Exception {
        PipeInsertionDataNodeListener.getInstance().startListenAndAssign(this.dataRegionId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        PipeInsertionDataNodeListener.getInstance().stopListenAndAssign(this.dataRegionId, this);
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            this.clearPendingQueue();
            this.isClosed.set(true);
        }
    }

    private void clearPendingQueue() {
        ArrayList eventsToDrop = new ArrayList(this.pendingQueue.size());
        this.pendingQueue.forEach(eventsToDrop::add);
        this.pendingQueue.clear();
        eventsToDrop.forEach(event -> {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeRealtimeDataRegionExtractor.class.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(PipeRealtimeEvent event) {
        if (this.isDbNameCoveredByPattern) {
            event.skipParsingPattern();
        }
        this.doExtract(event);
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            if (this.isClosed.get()) {
                this.clearPendingQueue();
            }
        }
    }

    protected abstract void doExtract(PipeRealtimeEvent var1);

    public abstract boolean isNeedListenToTsFile();

    public abstract boolean isNeedListenToInsertNode();

    public final String getPattern() {
        return this.pattern;
    }

    public final boolean isForwardingPipeRequests() {
        return this.isForwardingPipeRequests;
    }

    public final String getPipeName() {
        return this.pipeName;
    }

    public final PipeTaskMeta getPipeTaskMeta() {
        return this.pipeTaskMeta;
    }

    public String toString() {
        return "PipeRealtimeDataRegionExtractor{pattern='" + this.pattern + '\'' + ", dataRegionId='" + this.dataRegionId + '\'' + '}';
    }

    public int getTabletInsertionEventCount() {
        return this.pendingQueue.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.pendingQueue.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.pendingQueue.getPipeHeartbeatEventCount();
    }

    public String getTaskID() {
        return this.taskID;
    }
}

