/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrichedEvent
implements Event {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedEvent.class);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    protected final PipeTaskMeta pipeTaskMeta;
    private final String pattern;
    protected boolean isPatternParsed;
    protected boolean isTimeParsed = true;

    protected EnrichedEvent(PipeTaskMeta pipeTaskMeta, String pattern) {
        this.pipeTaskMeta = pipeTaskMeta;
        this.pattern = pattern;
        this.isPatternParsed = this.getPattern().equals("root");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean increaseReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() == 0) {
                isSuccessful = this.internallyIncreaseResourceReferenceCount(holderMessage);
            }
            this.referenceCount.incrementAndGet();
        }
        return isSuccessful;
    }

    public abstract boolean internallyIncreaseResourceReferenceCount(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decreaseReferenceCount(String holderMessage, boolean shouldReport) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            int newReferenceCount;
            if (this.referenceCount.get() == 1) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
                if (shouldReport) {
                    this.reportProgress();
                }
            }
            if ((newReferenceCount = this.referenceCount.decrementAndGet()) < 0) {
                LOGGER.warn("reference count is decreased to {}.", (Object)newReferenceCount);
            }
        }
        return isSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() >= 1) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
            }
            this.referenceCount.set(0);
        }
        return isSuccessful;
    }

    public abstract boolean internallyDecreaseResourceReferenceCount(String var1);

    protected void reportProgress() {
        if (this.pipeTaskMeta != null) {
            ProgressIndex progressIndex = this.getProgressIndex();
            this.pipeTaskMeta.updateProgressIndex((ProgressIndex)(progressIndex == null ? MinimumProgressIndex.INSTANCE : progressIndex));
        }
    }

    public abstract ProgressIndex getProgressIndex();

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public final String getPattern() {
        return this.pattern == null ? "root" : this.pattern;
    }

    public void skipParsingPattern() {
        this.isPatternParsed = true;
    }

    public boolean shouldParsePatternOrTime() {
        return !this.isPatternParsed || !this.isTimeParsed;
    }

    public abstract EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta var1, String var2);

    public void reportException(PipeRuntimeException pipeRuntimeException) {
        if (this.pipeTaskMeta != null) {
            PipeAgent.runtime().report(this.pipeTaskMeta, pipeRuntimeException);
        } else {
            LOGGER.warn("Attempt to report pipe exception to a null PipeTaskMeta.", (Throwable)pipeRuntimeException);
        }
    }

    public abstract boolean isGeneratedByPipe();
}

