/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.websocket;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.iotdb.db.pipe.connector.protocol.websocket.WebSocketConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnectorServer
extends WebSocketServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketConnectorServer.class);
    private final PriorityBlockingQueue<Pair<Long, Event>> events = new PriorityBlockingQueue<Pair>(11, Comparator.comparing(o -> (Long)o.left));
    private final WebSocketConnector websocketConnector;
    private final ConcurrentMap<Long, Event> eventMap = new ConcurrentHashMap<Long, Event>();

    public WebSocketConnectorServer(InetSocketAddress address, WebSocketConnector websocketConnector) {
        super(address);
        this.websocketConnector = websocketConnector;
    }

    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        String log = String.format("The connection from client %s:%d has been opened!", webSocket.getRemoteSocketAddress().getHostName(), webSocket.getRemoteSocketAddress().getPort());
        LOGGER.info(log);
    }

    public void onClose(WebSocket webSocket, int i, String s, boolean b) {
        String log = String.format("The client from %s:%d has been closed!", webSocket.getRemoteSocketAddress().getAddress(), webSocket.getRemoteSocketAddress().getPort());
        LOGGER.info(log);
    }

    public void onMessage(WebSocket webSocket, String s) {
        if (s.startsWith("START")) {
            LOGGER.info("Received a start message from {}:{}", (Object)webSocket.getRemoteSocketAddress().getHostName(), (Object)webSocket.getRemoteSocketAddress().getPort());
            this.handleStart(webSocket);
        } else if (s.startsWith("ACK")) {
            this.handleAck(webSocket, s);
        } else if (s.startsWith("ERROR")) {
            LOGGER.error("Received an error message {} from {}:{}", new Object[]{s, webSocket.getRemoteSocketAddress().getHostName(), webSocket.getRemoteSocketAddress().getPort()});
            this.handleError(webSocket, s);
        }
    }

    public void onError(WebSocket webSocket, Exception e) {
        String log = webSocket.getRemoteSocketAddress() != null ? String.format("Got an error `%s` from %s:%d", e.getMessage(), webSocket.getLocalSocketAddress().getHostName(), webSocket.getLocalSocketAddress().getPort()) : String.format("Got an error `%s` from client", e.getMessage());
        LOGGER.error(log);
    }

    public void onStart() {
        String log = String.format("The webSocket server %s:%d has been started!", this.getAddress().getHostName(), this.getPort());
        LOGGER.info(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Pair<Long, Event> event) {
        if (this.events.size() >= 5) {
            PriorityBlockingQueue<Pair<Long, Event>> priorityBlockingQueue = this.events;
            synchronized (priorityBlockingQueue) {
                while (this.events.size() >= 5) {
                    try {
                        this.events.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new PipeException(e.getMessage());
                    }
                }
            }
        }
        this.events.put(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStart(WebSocket webSocket) {
        try {
            while (true) {
                Pair<Long, Event> eventPair = this.events.take();
                PriorityBlockingQueue<Pair<Long, Event>> priorityBlockingQueue = this.events;
                synchronized (priorityBlockingQueue) {
                    this.events.notifyAll();
                }
                boolean transferred = this.transfer(eventPair, webSocket);
                if (!transferred) {
                    this.websocketConnector.commit((Long)eventPair.getLeft(), eventPair.getRight() instanceof EnrichedEvent ? (EnrichedEvent)eventPair.getRight() : null);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            String log = String.format("The event can't be taken, because: %s", e.getMessage());
            LOGGER.warn(log);
            Thread.currentThread().interrupt();
            throw new PipeException(e.getMessage());
        }
    }

    private void handleAck(WebSocket webSocket, String s) {
        long commitId = Long.parseLong(s.replace("ACK:", ""));
        Event event = (Event)this.eventMap.remove(commitId);
        if (event != null) {
            this.websocketConnector.commit(commitId, event instanceof EnrichedEvent ? (EnrichedEvent)event : null);
        }
        this.handleStart(webSocket);
    }

    private void handleError(WebSocket webSocket, String s) {
        long commitId = Long.parseLong(s.replace("ERROR:", ""));
        String log = String.format("The tablet of commitId: %d can't be parsed by client, it will be retried later.", commitId);
        LOGGER.warn(log);
        Event event = (Event)this.eventMap.remove(commitId);
        if (event != null) {
            this.events.put((Pair<Long, Event>)new Pair((Object)commitId, (Object)event));
        }
        this.handleStart(webSocket);
    }

    private boolean transfer(Pair<Long, Event> eventPair, WebSocket webSocket) {
        Long commitId = (Long)eventPair.getLeft();
        Event event = (Event)eventPair.getRight();
        try {
            ByteBuffer tabletBuffer = null;
            if (event instanceof PipeInsertNodeTabletInsertionEvent) {
                tabletBuffer = ((PipeInsertNodeTabletInsertionEvent)event).convertToTablet().serialize();
            } else if (event instanceof PipeRawTabletInsertionEvent) {
                tabletBuffer = ((PipeRawTabletInsertionEvent)event).convertToTablet().serialize();
            } else {
                throw new NotImplementedException("IoTDBCDCConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent.");
            }
            if (tabletBuffer == null) {
                return false;
            }
            ByteBuffer payload = ByteBuffer.allocate(8 + tabletBuffer.limit());
            payload.putLong(commitId);
            payload.put(tabletBuffer);
            payload.flip();
            this.broadcast(payload, Collections.singletonList(webSocket));
            this.eventMap.put((Long)eventPair.getLeft(), (Event)eventPair.getRight());
        }
        catch (Exception e) {
            this.events.put(eventPair);
            throw new PipeException(e.getMessage());
        }
        return true;
    }
}

