/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.protocol.IoTDBConnectorRequestVersion;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferTabletInsertNodeReq
extends TPipeTransferReq {
    private transient InsertNode insertNode;

    private PipeTransferTabletInsertNodeReq() {
    }

    public InsertNode getInsertNode() {
        return this.insertNode;
    }

    public Statement constructStatement() {
        if (this.insertNode instanceof InsertRowNode) {
            InsertRowNode node = (InsertRowNode)this.insertNode;
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(node.getDevicePath());
            statement.setTime(node.getTime());
            statement.setMeasurements(node.getMeasurements());
            statement.setDataTypes(node.getDataTypes());
            statement.setValues(node.getValues());
            statement.setNeedInferType(node.isNeedInferType());
            statement.setAligned(node.isAligned());
            statement.setMeasurementSchemas(node.getMeasurementSchemas());
            return statement;
        }
        if (this.insertNode instanceof InsertTabletNode) {
            InsertTabletNode node = (InsertTabletNode)this.insertNode;
            InsertTabletStatement statement = new InsertTabletStatement();
            statement.setDevicePath(node.getDevicePath());
            statement.setMeasurements(node.getMeasurements());
            statement.setTimes(node.getTimes());
            statement.setColumns(node.getColumns());
            statement.setBitMaps(node.getBitMaps());
            statement.setRowCount(node.getRowCount());
            statement.setDataTypes(node.getDataTypes());
            statement.setAligned(node.isAligned());
            statement.setMeasurementSchemas(node.getMeasurementSchemas());
            return statement;
        }
        throw new UnsupportedOperationException(String.format("unknown InsertNode type %s when constructing statement from insert node.", this.insertNode));
    }

    public static PipeTransferTabletInsertNodeReq toTPipeTransferReq(InsertNode insertNode) {
        PipeTransferTabletInsertNodeReq req = new PipeTransferTabletInsertNodeReq();
        req.insertNode = insertNode;
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_INSERT_NODE.getType();
        req.body = insertNode.serializeToByteBuffer();
        return req;
    }

    public static PipeTransferTabletInsertNodeReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletInsertNodeReq insertNodeReq = new PipeTransferTabletInsertNodeReq();
        insertNodeReq.insertNode = (InsertNode)PlanNodeType.deserialize(transferReq.body);
        insertNodeReq.version = transferReq.version;
        insertNodeReq.type = transferReq.type;
        insertNodeReq.body = transferReq.body;
        return insertNodeReq;
    }

    public static byte[] toTransferInsertNodeBytes(InsertNode insertNode) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_INSERT_NODE.getType(), (OutputStream)outputStream);
                byArray = BytesUtils.concatByteArray((byte[])byteArrayOutputStream.toByteArray(), (byte[])insertNode.serializeToByteBuffer().array());
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletInsertNodeReq that = (PipeTransferTabletInsertNodeReq)((Object)obj);
        return this.insertNode.equals(that.insertNode) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.insertNode, this.version, this.type, this.body);
    }
}

