/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.pipe.plugin.meta.DataNodePipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoaderManager;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.db.pipe.agent.plugin.PipeConnectorConstructor;
import org.apache.iotdb.db.pipe.agent.plugin.PipeExtractorConstructor;
import org.apache.iotdb.db.pipe.agent.plugin.PipeProcessorConstructor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.CreatePipeStatement;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePluginAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginAgent.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final DataNodePipePluginMetaKeeper pipePluginMetaKeeper = new DataNodePipePluginMetaKeeper();
    private final PipeExtractorConstructor pipeExtractorConstructor = new PipeExtractorConstructor(this.pipePluginMetaKeeper);
    private final PipeProcessorConstructor pipeProcessorConstructor = new PipeProcessorConstructor(this.pipePluginMetaKeeper);
    private final PipeConnectorConstructor pipeConnectorConstructor = new PipeConnectorConstructor(this.pipePluginMetaKeeper);

    public void acquireLock() {
        this.lock.lock();
    }

    public void releaseLock() {
        this.lock.unlock();
    }

    public void register(PipePluginMeta pipePluginMeta, ByteBuffer jarFile) throws IOException, PipeException {
        this.acquireLock();
        try {
            this.deregister(pipePluginMeta.getPluginName(), false);
            this.checkIfRegistered(pipePluginMeta);
            this.saveJarFileIfNeeded(pipePluginMeta.getJarName(), jarFile);
            this.doRegister(pipePluginMeta);
        }
        finally {
            this.releaseLock();
        }
    }

    private void checkIfRegistered(PipePluginMeta pipePluginMeta) throws PipeException {
        String pluginName = pipePluginMeta.getPluginName();
        PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
        if (information == null) {
            return;
        }
        if (information.isBuiltin()) {
            String errorMessage = String.format("Failed to register PipePlugin %s, because the given PipePlugin name is the same as a built-in PipePlugin name.", pluginName);
            LOGGER.warn(errorMessage);
            throw new PipeException(errorMessage);
        }
        if (PipePluginExecutableManager.getInstance().hasFileUnderInstallDir(pipePluginMeta.getJarName()) && !PipePluginExecutableManager.getInstance().isLocalJarMatched(pipePluginMeta)) {
            String errMsg = String.format("Failed to register PipePlugin %s, because existed md5 of jar file for pipe plugin %s is different from the new jar file.", pluginName, pluginName);
            LOGGER.warn(errMsg);
            throw new PipeException(errMsg);
        }
    }

    private void saveJarFileIfNeeded(String jarName, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            PipePluginExecutableManager.getInstance().saveToInstallDir(byteBuffer, jarName);
        }
    }

    public void doRegister(PipePluginMeta pipePluginMeta) throws PipeException {
        String pluginName = pipePluginMeta.getPluginName();
        String className = pipePluginMeta.getClassName();
        try {
            PipePluginClassLoader currentActiveClassLoader = PipePluginClassLoaderManager.getInstance().updateAndGetActiveClassLoader();
            this.updateAllRegisteredClasses(currentActiveClassLoader);
            Class<?> pluginClass = Class.forName(className, true, (ClassLoader)currentActiveClassLoader);
            PipePlugin ignored = (PipePlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.pipePluginMetaKeeper.addPipePluginMeta(pluginName, pipePluginMeta);
            this.pipePluginMetaKeeper.addPluginAndClass(pluginName, pluginClass);
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to register PipePlugin %s(%s), because its instance can not be constructed successfully. Exception: %s", pluginName.toUpperCase(), className, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new PipeException(errorMessage);
        }
    }

    private void updateAllRegisteredClasses(PipePluginClassLoader activeClassLoader) throws ClassNotFoundException {
        for (PipePluginMeta information : this.pipePluginMetaKeeper.getAllPipePluginMeta()) {
            this.pipePluginMetaKeeper.updatePluginClass(information, activeClassLoader);
        }
    }

    public void deregister(String pluginName, boolean needToDeleteJar) throws PipeException {
        this.acquireLock();
        try {
            PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
            if (information != null && information.isBuiltin()) {
                String errorMessage = String.format("Failed to deregister builtin PipePlugin %s.", pluginName);
                LOGGER.warn(errorMessage);
                throw new PipeException(errorMessage);
            }
            this.pipePluginMetaKeeper.removePipePluginMeta(pluginName);
            this.pipePluginMetaKeeper.removePluginClass(pluginName);
            if (information != null && needToDeleteJar) {
                PipePluginExecutableManager.getInstance().removeFileUnderLibRoot(information.getJarName());
                PipePluginExecutableManager.getInstance().removeFileUnderTemporaryRoot(pluginName.toUpperCase() + ".txt");
            }
        }
        catch (IOException e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(CreatePipeStatement createPipeStatement) throws Exception {
        PipeParameters extractorParameters = new PipeParameters(createPipeStatement.getExtractorAttributes());
        PipeExtractor temporaryExtractor = this.reflectExtractor(extractorParameters);
        try {
            temporaryExtractor.validate(new PipeParameterValidator(extractorParameters));
        }
        finally {
            try {
                temporaryExtractor.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary extractor: {}", (Object)e.getMessage());
            }
        }
        PipeParameters processorParameters = new PipeParameters(createPipeStatement.getProcessorAttributes());
        PipeProcessor temporaryProcessor = this.reflectProcessor(processorParameters);
        try {
            temporaryProcessor.validate(new PipeParameterValidator(processorParameters));
        }
        finally {
            try {
                temporaryProcessor.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary processor: {}", (Object)e.getMessage());
            }
        }
        PipeParameters connectorParameters = new PipeParameters(createPipeStatement.getConnectorAttributes());
        PipeConnector temporaryConnector = this.reflectConnector(connectorParameters);
        try {
            temporaryConnector.validate(new PipeParameterValidator(connectorParameters));
        }
        finally {
            try {
                temporaryConnector.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary connector: {}", (Object)e.getMessage());
            }
        }
    }

    public PipeExtractor reflectExtractor(PipeParameters extractorParameters) {
        return this.pipeExtractorConstructor.reflectPlugin(extractorParameters);
    }

    public PipeProcessor reflectProcessor(PipeParameters processorParameters) {
        return this.pipeProcessorConstructor.reflectPlugin(processorParameters);
    }

    public PipeConnector reflectConnector(PipeParameters connectorParameters) {
        return this.pipeConnectorConstructor.reflectPlugin(connectorParameters);
    }
}

