/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.rest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBRestServiceDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBRestServiceDescriptor.class);
    private final IoTDBRestServiceConfig conf = new IoTDBRestServiceConfig();

    protected IoTDBRestServiceDescriptor() {
        Properties properties = this.loadProps("iotdb-datanode.properties");
        if (properties != null) {
            if (!properties.containsKey("enable_rest_service")) {
                properties = this.loadProps("iotdb-common.properties");
            }
            if (properties != null) {
                this.loadProps(properties);
            }
        }
    }

    public static IoTDBRestServiceDescriptor getInstance() {
        return IoTDBRestServiceDescriptorHolder.INSTANCE;
    }

    private Properties loadProps(String configName) {
        block12: {
            Properties properties;
            block11: {
                URL url = this.getPropsUrl(configName);
                if (url == null) {
                    logger.warn("Couldn't load the REST Service configuration from any of the known sources.");
                    return null;
                }
                InputStream inputStream = url.openStream();
                try {
                    logger.info("Start to read config file {}", (Object)url);
                    Properties properties2 = new Properties();
                    properties2.load(inputStream);
                    properties = properties2;
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        logger.warn("REST service fail to find config file {}", (Object)url, (Object)e);
                        break block12;
                    }
                    catch (IOException e) {
                        logger.warn("REST service cannot load config file, use default configuration", (Throwable)e);
                        break block12;
                    }
                    catch (Exception e) {
                        logger.warn("REST service Incorrect format in config file, use default configuration", (Throwable)e);
                    }
                }
                inputStream.close();
            }
            return properties;
        }
        return null;
    }

    private void loadProps(Properties properties) {
        this.conf.setEnableRestService(Boolean.parseBoolean(properties.getProperty("enable_rest_service", Boolean.toString(this.conf.isEnableRestService()))));
        this.conf.setRestServicePort(Integer.parseInt(properties.getProperty("rest_service_port", Integer.toString(this.conf.getRestServicePort()))));
        this.conf.setRestQueryDefaultRowSizeLimit(Integer.parseInt(properties.getProperty("rest_query_default_row_size_limit", Integer.toString(this.conf.getRestQueryDefaultRowSizeLimit()))));
        this.conf.setEnableSwagger(Boolean.parseBoolean(properties.getProperty("enable_swagger", Boolean.toString(this.conf.isEnableSwagger()))));
        this.conf.setEnableHttps(Boolean.parseBoolean(properties.getProperty("enable_https", Boolean.toString(this.conf.isEnableHttps()))));
        this.conf.setClientAuth(Boolean.parseBoolean(properties.getProperty("client_auth", Boolean.toString(this.conf.isClientAuth()))));
        this.conf.setKeyStorePath(properties.getProperty("key_store_path", this.conf.getKeyStorePath()));
        this.conf.setKeyStorePwd(properties.getProperty("key_store_pwd", this.conf.getKeyStorePwd()));
        this.conf.setTrustStorePath(properties.getProperty("trust_store_path", this.conf.getTrustStorePath()));
        this.conf.setTrustStorePwd(properties.getProperty("trust_store_pwd", this.conf.getTrustStorePwd()));
        this.conf.setIdleTimeoutInSeconds(Integer.parseInt(properties.getProperty("idle_timeout_in_seconds", Integer.toString(this.conf.getIdleTimeoutInSeconds()))));
        this.conf.setCacheExpireInSeconds(Integer.parseInt(properties.getProperty("cache_expire_in_seconds", Integer.toString(this.conf.getCacheExpireInSeconds()))));
        this.conf.setCacheInitNum(Integer.parseInt(properties.getProperty("cache_init_num", Integer.toString(this.conf.getCacheInitNum()))));
        this.conf.setCacheMaxNum(Integer.parseInt(properties.getProperty("cache_max_num", Integer.toString(this.conf.getCacheMaxNum()))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getPropsUrl(String configName) {
        String urlString;
        block8: {
            urlString = System.getProperty("IOTDB_CONF", null);
            if (urlString == null) {
                urlString = System.getProperty("IOTDB_HOME", null);
                if (urlString != null) {
                    urlString = urlString + File.separatorChar + "conf" + File.separatorChar + configName;
                    break block8;
                } else {
                    URL uri = IoTDBConfig.class.getResource("/" + configName);
                    if (uri != null) {
                        return uri;
                    }
                    logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)configName);
                    return null;
                }
            }
            if (!urlString.endsWith(".properties")) {
                urlString = urlString + File.separatorChar + configName;
            }
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public IoTDBRestServiceConfig getConfig() {
        return this.conf;
    }

    private static class IoTDBRestServiceDescriptorHolder {
        private static final IoTDBRestServiceDescriptor INSTANCE = new IoTDBRestServiceDescriptor();

        private IoTDBRestServiceDescriptorHolder() {
        }
    }
}

