/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.tsfile.utils.Pair;

public class IOUtils {
    private IOUtils() {
    }

    public static void writeString(OutputStream outputStream, String str, String encoding, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        if (str != null) {
            byte[] strBuffer = str.getBytes(encoding);
            IOUtils.writeInt(outputStream, strBuffer.length, encodingBufferLocal);
            outputStream.write(strBuffer);
        } else {
            IOUtils.writeInt(outputStream, 0, encodingBufferLocal);
        }
    }

    public static void writeInt(OutputStream outputStream, int i, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        ByteBuffer encodingBuffer;
        if (encodingBufferLocal != null) {
            encodingBuffer = encodingBufferLocal.get();
            if (encodingBuffer == null) {
                encodingBuffer = ByteBuffer.allocate(8);
                encodingBufferLocal.set(encodingBuffer);
            }
        } else {
            encodingBuffer = ByteBuffer.allocate(4);
        }
        encodingBuffer.clear();
        encodingBuffer.putInt(i);
        outputStream.write(encodingBuffer.array(), 0, 4);
    }

    public static String readString(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException {
        int length = inputStream.readInt();
        if (length > 0) {
            byte[] strBuffer;
            if (strBufferLocal != null) {
                strBuffer = strBufferLocal.get();
                if (strBuffer == null || length > strBuffer.length) {
                    strBuffer = new byte[length];
                    strBufferLocal.set(strBuffer);
                }
            } else {
                strBuffer = new byte[length];
            }
            inputStream.read(strBuffer, 0, length);
            return new String(strBuffer, 0, length, encoding);
        }
        return null;
    }

    public static Pair<String, Boolean> readAuthString(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException {
        int length = inputStream.readInt();
        int absLength = Math.abs(length);
        if (absLength != 0) {
            byte[] strBuffer;
            if (strBufferLocal != null) {
                strBuffer = strBufferLocal.get();
                if (strBuffer == null || absLength > strBuffer.length) {
                    strBuffer = new byte[absLength];
                    strBufferLocal.set(strBuffer);
                }
            } else {
                strBuffer = new byte[absLength];
            }
            inputStream.read(strBuffer, 0, absLength);
            Pair result = new Pair((Object)new String(strBuffer, 0, absLength, encoding), (Object)(length > 0 ? 1 : 0));
            return result;
        }
        return null;
    }

    public static PathPrivilege readPathPrivilege(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal, boolean compatible) throws IOException, IllegalPathException {
        String path = IOUtils.readString(inputStream, encoding, strBufferLocal);
        if (compatible) {
            int privilegeNum = inputStream.readInt();
            PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath(path));
            for (int i = 0; i < privilegeNum; ++i) {
                pathPrivilege.getPrivileges().add(inputStream.readInt());
            }
            return pathPrivilege;
        }
        PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath(path));
        int privileges = inputStream.readInt();
        pathPrivilege.setAllPrivileges(privileges);
        return pathPrivilege;
    }

    public static void loadRolePrivilege(Role role, DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException, IllegalPathException {
        role.setSysPrivilegeSet(0);
        int pathPriNum = inputStream.readInt();
        ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
        for (int i = 0; i < pathPriNum; ++i) {
            String path = IOUtils.readString(inputStream, encoding, strBufferLocal);
            PartialPath ppath = new PartialPath(path);
            PathPrivilege pathPriv = new PathPrivilege(ppath);
            int priNum = inputStream.readInt();
            for (int j = 0; j < priNum; ++j) {
                PriPrivilegeType priType = PriPrivilegeType.values()[inputStream.readInt()];
                if (!priType.isAccept()) continue;
                pathPriv.grantPrivilege(priType.ordinal(), false);
            }
            pathPrivilegeList.add(pathPriv);
        }
        role.setPrivilegeList(pathPrivilegeList);
        role.setServiceReady(false);
    }

    public static void writePathPrivilege(OutputStream outputStream, PathPrivilege pathPrivilege, String encoding, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        IOUtils.writeString(outputStream, pathPrivilege.getPath().getFullPath(), encoding, encodingBufferLocal);
        IOUtils.writeInt(outputStream, pathPrivilege.getAllPrivileges(), encodingBufferLocal);
    }

    public static void replaceFile(File newFile, File oldFile) throws IOException {
        if (!newFile.renameTo(oldFile)) {
            if (!oldFile.delete()) {
                throw new IOException(String.format("Cannot delete old user file : %s", oldFile.getPath()));
            }
            if (!newFile.renameTo(oldFile)) {
                throw new IOException(String.format("Cannot replace old user file with new one : %s", newFile.getPath()));
            }
        }
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }
}

