/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.cpu;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuUsageMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(CpuUsageMetrics.class);
    private final List<String> modules;
    private final List<String> pools;
    private static final long UPDATE_INTERVAL = 10000L;
    protected AbstractMetricService metricService;
    protected final UnaryOperator<String> threadNameToModule;
    protected final UnaryOperator<String> threadNameToPool;
    protected final Map<Long, String> threadIdToModuleCache = new HashMap<Long, String>();
    protected final Map<Long, String> threadIdToPoolCache = new HashMap<Long, String>();
    private final Map<String, Double> moduleCpuTimePercentageMap = new HashMap<String, Double>();
    private final Map<String, Double> moduleUserTimePercentageMap = new HashMap<String, Double>();
    private final Map<String, Double> poolCpuUsageMap = new HashMap<String, Double>();
    private final Map<String, Double> poolUserTimePercentageMap = new HashMap<String, Double>();
    private final Map<Long, Long> lastThreadCpuTime = new HashMap<Long, Long>();
    private final Map<Long, Long> lastThreadUserTime = new HashMap<Long, Long>();
    AutoGauge processCpuLoadGauge = null;
    private final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    private AtomicLong lastUpdateTime = new AtomicLong(0L);
    private AtomicLong updateCount = new AtomicLong(0L);

    public CpuUsageMetrics(List<String> modules, List<String> pools, UnaryOperator<String> threadNameToModule, UnaryOperator<String> threadNameToPool) {
        this.modules = modules;
        this.pools = pools;
        this.threadNameToModule = threadNameToModule;
        this.threadNameToPool = threadNameToPool;
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        for (String moduleName : this.modules) {
            metricService.createAutoGauge(SystemMetric.MODULE_CPU_USAGE.toString(), MetricLevel.IMPORTANT, this, x -> x.getModuleCpuUsage().getOrDefault(moduleName, 0.0), SystemTag.MODULE.toString(), moduleName);
            metricService.createAutoGauge(SystemMetric.MODULE_USER_TIME_PERCENTAGE.toString(), MetricLevel.IMPORTANT, this, x -> x.getModuleUserTimePercentage().getOrDefault(moduleName, 0.0), SystemTag.MODULE.toString(), moduleName);
        }
        for (String poolName : this.pools) {
            metricService.createAutoGauge(SystemMetric.POOL_CPU_USAGE.toString(), MetricLevel.IMPORTANT, this, x -> x.getPoolCpuUsage().getOrDefault(poolName, 0.0), SystemTag.POOL.toString(), poolName);
            metricService.createAutoGauge(SystemMetric.POOL_USER_TIME_PERCENTAGE.toString(), MetricLevel.IMPORTANT, this, x -> x.getPoolUserCpuPercentage().getOrDefault(poolName, 0.0), SystemTag.POOL.toString(), poolName);
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        for (String moduleName : this.modules) {
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.MODULE_CPU_USAGE.toString(), SystemTag.MODULE.toString(), moduleName);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.MODULE_USER_TIME_PERCENTAGE.toString(), SystemTag.MODULE.toString(), moduleName);
        }
        for (String poolName : this.pools) {
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.POOL_CPU_USAGE.toString(), SystemTag.POOL.toString(), poolName);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.POOL_USER_TIME_PERCENTAGE.toString(), SystemTag.POOL.toString(), poolName);
        }
    }

    public Map<String, Double> getModuleCpuUsage() {
        this.checkAndMayUpdate();
        return this.moduleCpuTimePercentageMap;
    }

    public Map<String, Double> getPoolCpuUsage() {
        this.checkAndMayUpdate();
        return this.poolCpuUsageMap;
    }

    public Map<String, Double> getPoolUserCpuPercentage() {
        this.checkAndMayUpdate();
        return this.poolUserTimePercentageMap;
    }

    public Map<String, Double> getModuleUserTimePercentage() {
        this.checkAndMayUpdate();
        return this.moduleUserTimePercentageMap;
    }

    private synchronized void checkAndMayUpdate() {
        if (!MetricLevel.higherOrEqual(MetricLevel.IMPORTANT, MetricConfigDescriptor.getInstance().getMetricConfig().getMetricLevel())) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime.get() > 10000L) {
            this.lastUpdateTime.set(currentTime);
            this.updateCpuUsage();
        }
    }

    private String getThreadModuleById(long id, ThreadInfo threadInfo) {
        return this.threadIdToModuleCache.computeIfAbsent(id, k -> (String)this.threadNameToModule.apply(threadInfo.getThreadName()));
    }

    private String getThreadPoolById(long id, ThreadInfo threadInfo) {
        return this.threadIdToPoolCache.computeIfAbsent(id, k -> (String)this.threadNameToPool.apply(threadInfo.getThreadName()));
    }

    private void updateCpuUsage() {
        if (!this.checkCpuMonitorEnable()) {
            return;
        }
        long startTime = System.nanoTime();
        long[] taskIds = this.threadMxBean.getAllThreadIds();
        ThreadInfo[] threadInfos = this.threadMxBean.getThreadInfo(taskIds);
        List<ThreadInfo> threadInfoList = Arrays.stream(threadInfos).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<Long, Long> currentThreadCpuTime = new HashMap<Long, Long>(taskIds.length + 1, 1.0f);
        HashMap<Long, Long> currentThreadUserTime = new HashMap<Long, Long>(taskIds.length + 1, 1.0f);
        this.collectThreadCpuInfo(currentThreadCpuTime, currentThreadUserTime, threadInfoList);
        HashMap<String, Long> moduleIncrementCpuTimeMap = new HashMap<String, Long>(this.modules.size() + 1, 1.0f);
        HashMap<String, Long> moduleIncrementUserTimeMap = new HashMap<String, Long>(this.modules.size() + 1, 1.0f);
        HashMap<String, Long> poolIncrementCpuTimeMap = new HashMap<String, Long>(this.pools.size() + 1, 1.0f);
        HashMap<String, Long> poolIncrementUserTimeMap = new HashMap<String, Long>(this.pools.size() + 1, 1.0f);
        long totalIncrementTime = this.computeUsageInfoForModuleAndPool(moduleIncrementCpuTimeMap, moduleIncrementUserTimeMap, poolIncrementCpuTimeMap, poolIncrementUserTimeMap, this.lastThreadCpuTime, this.lastThreadUserTime, currentThreadCpuTime, currentThreadUserTime, threadInfoList);
        if (totalIncrementTime == 0L) {
            return;
        }
        this.updateUsageMap(moduleIncrementCpuTimeMap, moduleIncrementUserTimeMap, poolIncrementCpuTimeMap, poolIncrementUserTimeMap, totalIncrementTime);
        this.lastThreadCpuTime.clear();
        this.lastThreadCpuTime.putAll(currentThreadCpuTime);
        this.lastThreadUserTime.clear();
        this.lastThreadUserTime.putAll(currentThreadUserTime);
        long timeCost = System.nanoTime() - startTime;
        this.updateCount.incrementAndGet();
        logger.debug("Time for update cpu usage is {} ns", (Object)timeCost);
    }

    private boolean checkCpuMonitorEnable() {
        if (!this.threadMxBean.isThreadCpuTimeSupported()) {
            return false;
        }
        if (!this.threadMxBean.isThreadCpuTimeEnabled()) {
            this.threadMxBean.setThreadCpuTimeEnabled(true);
        }
        return true;
    }

    private void collectThreadCpuInfo(Map<Long, Long> cpuTimeMap, Map<Long, Long> userTimeMap, List<ThreadInfo> threadInfos) {
        threadInfos.forEach(info -> {
            long cpuTime = this.threadMxBean.getThreadCpuTime(info.getThreadId());
            long userTime = this.threadMxBean.getThreadUserTime(info.getThreadId());
            if (cpuTime != -1L && userTime != -1L) {
                cpuTimeMap.put(info.getThreadId(), cpuTime);
                userTimeMap.put(info.getThreadId(), userTime);
            }
        });
    }

    private long computeUsageInfoForModuleAndPool(Map<String, Long> moduleIncrementCpuTimeMap, Map<String, Long> moduleIncrementUserTimeMap, Map<String, Long> poolIncrementCpuTimeMap, Map<String, Long> poolIncrementUserTimeMap, Map<Long, Long> beforeThreadCpuTime, Map<Long, Long> beforeThreadUserTime, Map<Long, Long> afterThreadCpuTime, Map<Long, Long> afterThreadUserTime, List<ThreadInfo> threadInfos) {
        long totalIncrementTime = 0L;
        for (ThreadInfo threadInfo : threadInfos) {
            long id = threadInfo.getThreadId();
            long beforeCpuTime = beforeThreadCpuTime.getOrDefault(id, 0L);
            long afterCpuTime = afterThreadCpuTime.getOrDefault(id, 0L);
            if (afterCpuTime < beforeCpuTime || afterCpuTime == 0L) continue;
            long beforeUserTime = beforeThreadUserTime.getOrDefault(id, 0L);
            long afterUserTime = afterThreadUserTime.getOrDefault(id, 0L);
            totalIncrementTime += afterCpuTime - beforeCpuTime;
            String module = this.getThreadModuleById(id, threadInfo);
            String pool = this.getThreadPoolById(id, threadInfo);
            moduleIncrementCpuTimeMap.compute(module, (k, v) -> v == null ? afterCpuTime - beforeCpuTime : v + afterCpuTime - beforeCpuTime);
            moduleIncrementUserTimeMap.compute(module, (k, v) -> v == null ? afterUserTime - beforeUserTime : v + afterUserTime - beforeUserTime);
            poolIncrementCpuTimeMap.compute(pool, (k, v) -> v == null ? afterCpuTime - beforeCpuTime : v + afterCpuTime - beforeCpuTime);
            poolIncrementUserTimeMap.compute(pool, (k, v) -> v == null ? afterUserTime - beforeUserTime : v + afterUserTime - beforeUserTime);
        }
        return totalIncrementTime;
    }

    private void updateUsageMap(Map<String, Long> moduleIncrementCpuTimeMap, Map<String, Long> moduleIncrementUserTimeMap, Map<String, Long> poolIncrementCpuTimeMap, Map<String, Long> poolIncrementUserTimeMap, long totalIncrementTime) {
        if (this.processCpuLoadGauge == null) {
            this.processCpuLoadGauge = this.metricService.getAutoGauge("process_cpu_load", MetricLevel.CORE, "name", "process");
        }
        double processCpuLoad = this.processCpuLoadGauge.getValue();
        for (Map.Entry<String, Long> entry : moduleIncrementCpuTimeMap.entrySet()) {
            this.moduleCpuTimePercentageMap.put(entry.getKey(), (double)entry.getValue().longValue() * 1.0 / (double)totalIncrementTime * processCpuLoad);
            if ((double)entry.getValue().longValue() > 0.0) {
                this.moduleUserTimePercentageMap.put(entry.getKey(), Math.min((double)moduleIncrementUserTimeMap.get(entry.getKey()).longValue() * 1.0 / (double)entry.getValue().longValue(), 1.0));
                continue;
            }
            this.moduleUserTimePercentageMap.put(entry.getKey(), 0.0);
        }
        for (Map.Entry<String, Long> entry : poolIncrementCpuTimeMap.entrySet()) {
            this.poolCpuUsageMap.put(entry.getKey(), (double)entry.getValue().longValue() * 1.0 / (double)totalIncrementTime * processCpuLoad);
            if ((double)entry.getValue().longValue() > 0.0) {
                this.poolUserTimePercentageMap.put(entry.getKey(), Math.min((double)poolIncrementUserTimeMap.get(entry.getKey()).longValue() * 1.0 / (double)entry.getValue().longValue(), 1.0));
                continue;
            }
            this.poolUserTimePercentageMap.put(entry.getKey(), 0.0);
        }
    }
}

