/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.DeleteTimeSeriesState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteDataForDeleteSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTimeSeriesProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, DeleteTimeSeriesState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteTimeSeriesProcedure.class);
    private String queryId;
    private PathPatternTree patternTree;
    private transient ByteBuffer patternTreeBytes;
    private transient String requestMessage;

    public DeleteTimeSeriesProcedure() {
    }

    public DeleteTimeSeriesProcedure(String queryId, PathPatternTree patternTree) {
        this.queryId = queryId;
        this.setPatternTree(patternTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeleteTimeSeriesState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case CONSTRUCT_BLACK_LIST: {
                    LOGGER.info("Construct schemaEngine black list of timeSeries {}", (Object)this.requestMessage);
                    if (this.constructBlackList(env) > 0L) {
                        this.setNextState(DeleteTimeSeriesState.CLEAN_DATANODE_SCHEMA_CACHE);
                        break;
                    }
                    this.setFailure(new ProcedureException((Throwable)new PathNotExistException(this.patternTree.getAllPathPatterns().stream().map(PartialPath::getFullPath).collect(Collectors.toList()), false)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                case CLEAN_DATANODE_SCHEMA_CACHE: {
                    LOGGER.info("Invalidate cache of timeSeries {}", (Object)this.requestMessage);
                    this.invalidateCache(env);
                    break;
                }
                case DELETE_DATA: {
                    LOGGER.info("Delete data of timeSeries {}", (Object)this.requestMessage);
                    this.deleteData(env);
                    break;
                }
                case DELETE_TIMESERIES_SCHEMA: {
                    LOGGER.info("Delete timeSeries schemaEngine of {}", (Object)this.requestMessage);
                    this.deleteTimeSeriesSchema(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                default: {
                    this.setFailure(new ProcedureException("Unrecognized state " + (Object)((Object)state)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("DeleteTimeSeries-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private long constructBlackList(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree);
        if (targetSchemaRegionGroup.isEmpty()) {
            return 0L;
        }
        final ArrayList successResult = new ArrayList();
        DeleteTimeSeriesRegionTaskExecutor<TConstructSchemaBlackListReq> constructBlackListTask = new DeleteTimeSeriesRegionTaskExecutor<TConstructSchemaBlackListReq>("construct schemaengine black list", env, targetSchemaRegionGroup, DataNodeRequestType.CONSTRUCT_SCHEMA_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TConstructSchemaBlackListReq(consensusGroupIdList, this.patternTreeBytes)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    successResult.add(response);
                } else if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatusList = response.getSubStatus();
                    for (int i = 0; i < subStatusList.size(); ++i) {
                        if (((TSStatus)subStatusList.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            successResult.add((TSStatus)subStatusList.get(i));
                            continue;
                        }
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }
        };
        constructBlackListTask.execute();
        if (this.isFailed()) {
            return 0L;
        }
        long preDeletedNum = 0L;
        for (TSStatus resp : successResult) {
            preDeletedNum += Long.parseLong(resp.getMessage());
        }
        return preDeletedNum;
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.INVALIDATE_MATCHED_SCHEMA_CACHE, new TInvalidateMatchedSchemaCacheReq(this.patternTreeBytes), dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate schemaEngine cache of timeSeries {}", (Object)this.requestMessage);
            this.setFailure(new ProcedureException(new MetadataException("Invalidate schemaEngine cache failed")));
            return;
        }
        this.setNextState(DeleteTimeSeriesState.DELETE_DATA);
    }

    private void deleteData(ConfigNodeProcedureEnv env) {
        this.deleteDataWithRawPathPattern(env);
    }

    private void deleteDataWithRawPathPattern(ConfigNodeProcedureEnv env) {
        this.executeDeleteData(env, this.patternTree);
        if (this.isFailed()) {
            return;
        }
        this.setNextState(DeleteTimeSeriesState.DELETE_TIMESERIES_SCHEMA);
    }

    private void executeDeleteData(ConfigNodeProcedureEnv env, PathPatternTree patternTree) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedDataRegionGroup = env.getConfigManager().getRelatedDataRegionGroup(patternTree);
        if (relatedDataRegionGroup.isEmpty()) {
            return;
        }
        DeleteTimeSeriesRegionTaskExecutor<TDeleteDataForDeleteSchemaReq> deleteDataTask = new DeleteTimeSeriesRegionTaskExecutor<TDeleteDataForDeleteSchemaReq>("delete data", env, relatedDataRegionGroup, true, DataNodeRequestType.DELETE_DATA_FOR_DELETE_SCHEMA, (dataNodeLocation, consensusGroupIdList) -> new TDeleteDataForDeleteSchemaReq(new ArrayList(consensusGroupIdList), this.preparePatternTreeBytesData(patternTree)));
        deleteDataTask.execute();
    }

    private void deleteTimeSeriesSchema(ConfigNodeProcedureEnv env) {
        DeleteTimeSeriesRegionTaskExecutor<TDeleteTimeSeriesReq> deleteTimeSeriesTask = new DeleteTimeSeriesRegionTaskExecutor<TDeleteTimeSeriesReq>("delete timeseries schemaengine", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree), DataNodeRequestType.DELETE_TIMESERIES, (dataNodeLocation, consensusGroupIdList) -> new TDeleteTimeSeriesReq(consensusGroupIdList, this.patternTreeBytes));
        deleteTimeSeriesTask.execute();
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeleteTimeSeriesState deleteTimeSeriesState) throws IOException, InterruptedException, ProcedureException {
        if (deleteTimeSeriesState == DeleteTimeSeriesState.CONSTRUCT_BLACK_LIST) {
            DeleteTimeSeriesRegionTaskExecutor<TRollbackSchemaBlackListReq> rollbackStateTask = new DeleteTimeSeriesRegionTaskExecutor<TRollbackSchemaBlackListReq>("roll back schemaengine black list", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree), DataNodeRequestType.ROLLBACK_SCHEMA_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TRollbackSchemaBlackListReq(consensusGroupIdList, this.patternTreeBytes));
            rollbackStateTask.execute();
        }
    }

    @Override
    protected boolean isRollbackSupported(DeleteTimeSeriesState deleteTimeSeriesState) {
        return true;
    }

    @Override
    protected DeleteTimeSeriesState getState(int stateId) {
        return DeleteTimeSeriesState.values()[stateId];
    }

    @Override
    protected int getStateId(DeleteTimeSeriesState deleteTimeSeriesState) {
        return deleteTimeSeriesState.ordinal();
    }

    @Override
    protected DeleteTimeSeriesState getInitialState() {
        return DeleteTimeSeriesState.CONSTRUCT_BLACK_LIST;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public void setPatternTree(PathPatternTree patternTree) {
        this.patternTree = patternTree;
        this.requestMessage = patternTree.getAllPathPatterns().toString();
        this.patternTreeBytes = this.preparePatternTreeBytesData(patternTree);
    }

    private ByteBuffer preparePatternTreeBytesData(PathPatternTree patternTree) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DELETE_TIMESERIES_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        this.patternTree.serialize(stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.setPatternTree(PathPatternTree.deserialize((ByteBuffer)byteBuffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteTimeSeriesProcedure that = (DeleteTimeSeriesProcedure)o;
        return this.getProcId() == that.getProcId() && this.getState() == that.getState() && this.patternTree.equals((Object)that.patternTree);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.patternTree});
    }

    private class DeleteTimeSeriesRegionTaskExecutor<Q>
    extends DataNodeRegionTaskExecutor<Q, TSStatus> {
        private final String taskName;

        DeleteTimeSeriesRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, DataNodeRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetSchemaRegionGroup, false, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        DeleteTimeSeriesRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, boolean executeOnAllReplicaset, DataNodeRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetSchemaRegionGroup, executeOnAllReplicaset, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        @Override
        protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
            ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
            if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return failedRegionList;
            }
            if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                List subStatus = response.getSubStatus();
                for (int i = 0; i < subStatus.size(); ++i) {
                    if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    failedRegionList.add(consensusGroupIdList.get(i));
                }
            } else {
                failedRegionList.addAll(consensusGroupIdList);
            }
            return failedRegionList;
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
            DeleteTimeSeriesProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Delete timeseries %s failed when [%s] because all replicaset of schemaRegion %s failed. %s", DeleteTimeSeriesProcedure.this.requestMessage, this.taskName, consensusGroupId.id, dataNodeLocationSet))));
            this.interruptTask();
        }
    }
}

