/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropPipeProcedureV2
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropPipeProcedureV2.class);
    private String pipeName;

    public DropPipeProcedureV2() {
    }

    public DropPipeProcedureV2(String pipeName) throws PipeException {
        this.pipeName = pipeName;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.DROP_PIPE;
    }

    @Override
    protected void executeFromValidateTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("DropPipeProcedureV2: executeFromValidateTask({})", (Object)this.pipeName);
        ((PipeTaskInfo)this.pipeTaskInfo.get()).checkBeforeDropPipe(this.pipeName);
    }

    @Override
    protected void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("DropPipeProcedureV2: executeFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) throws PipeException {
        TSStatus response;
        LOGGER.info("DropPipeProcedureV2: executeFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        try {
            response = env.getConfigManager().getConsensusManager().write(new DropPipePlanV2(this.pipeName));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("DropPipeProcedureV2: executeFromOperateOnDataNodes({})", (Object)this.pipeName);
        String exceptionMessage = this.parsePushPipeMetaExceptionForPipe(this.pipeName, this.dropSinglePipeOnDataNodes(this.pipeName, env));
        if (!exceptionMessage.isEmpty()) {
            throw new PipeException(String.format("Failed to drop pipe %s, details: %s", this.pipeName, exceptionMessage));
        }
    }

    @Override
    protected void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromValidateTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromOperateOnDataNodes({})", (Object)this.pipeName);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_PIPE_PROCEDURE_V2.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropPipeProcedureV2 that = (DropPipeProcedureV2)o;
        return this.pipeName.equals(that.pipeName);
    }

    public int hashCode() {
        return this.pipeName.hashCode();
    }
}

