/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.region;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionCache;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;

public class RegionGroupCache {
    private final TConsensusGroupId consensusGroupId;
    private final Map<Integer, RegionCache> regionCacheMap;
    protected AtomicReference<RegionGroupStatistics> previousStatistics;
    private final AtomicReference<RegionGroupStatistics> currentStatistics;

    public RegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.consensusGroupId = consensusGroupId;
        this.regionCacheMap = new ConcurrentHashMap<Integer, RegionCache>();
        this.previousStatistics = new AtomicReference<RegionGroupStatistics>(RegionGroupStatistics.generateDefaultRegionGroupStatistics());
        this.currentStatistics = new AtomicReference<RegionGroupStatistics>(RegionGroupStatistics.generateDefaultRegionGroupStatistics());
    }

    public void cacheHeartbeatSample(int dataNodeId, RegionHeartbeatSample newHeartbeatSample) {
        this.regionCacheMap.computeIfAbsent(dataNodeId, empty -> new RegionCache()).cacheHeartbeatSample(newHeartbeatSample);
    }

    public boolean periodicUpdate() {
        this.updateCurrentStatistics();
        if (!this.currentStatistics.get().equals(this.previousStatistics.get())) {
            this.previousStatistics.set(this.currentStatistics.get());
            return true;
        }
        return false;
    }

    public void forceUpdate(Map<Integer, RegionHeartbeatSample> newHeartbeatSamples) {
        newHeartbeatSamples.forEach(this::cacheHeartbeatSample);
        this.updateCurrentStatistics();
    }

    protected void updateCurrentStatistics() {
        HashMap<Integer, RegionStatistics> regionStatisticsMap = new HashMap<Integer, RegionStatistics>();
        for (Map.Entry<Integer, RegionCache> cacheEntry : this.regionCacheMap.entrySet()) {
            RegionStatistics regionStatistics = cacheEntry.getValue().getRegionStatistics();
            regionStatisticsMap.put(cacheEntry.getKey(), regionStatistics);
        }
        RegionGroupStatus status = this.updateRegionGroupStatus(regionStatisticsMap);
        RegionGroupStatistics newRegionGroupStatistics = new RegionGroupStatistics(status, regionStatisticsMap);
        if (!this.currentStatistics.get().equals(newRegionGroupStatistics)) {
            this.currentStatistics.set(newRegionGroupStatistics);
        }
    }

    private RegionGroupStatus updateRegionGroupStatus(Map<Integer, RegionStatistics> regionStatisticsMap) {
        int unknownCount = 0;
        int readonlyCount = 0;
        for (RegionStatistics regionStatistics : regionStatisticsMap.values()) {
            if (RegionStatus.Removing.equals((Object)regionStatistics.getRegionStatus())) {
                return RegionGroupStatus.Disabled;
            }
            unknownCount += RegionStatus.Unknown.equals((Object)regionStatistics.getRegionStatus()) ? 1 : 0;
            readonlyCount += RegionStatus.ReadOnly.equals((Object)regionStatistics.getRegionStatus()) ? 1 : 0;
        }
        if (unknownCount + readonlyCount == 0) {
            return RegionGroupStatus.Running;
        }
        if (readonlyCount == 0) {
            return unknownCount <= (this.regionCacheMap.size() - 1) / 2 ? RegionGroupStatus.Available : RegionGroupStatus.Disabled;
        }
        return unknownCount + readonlyCount <= (this.regionCacheMap.size() - 1) / 2 ? RegionGroupStatus.Discouraged : RegionGroupStatus.Disabled;
    }

    public RegionGroupStatistics getStatistics() {
        return this.currentStatistics.get();
    }

    public RegionGroupStatistics getPreviousStatistics() {
        return this.previousStatistics.get();
    }
}

