/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.utils;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.iotdb.consensus.ratis.utils.RetryPolicy;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;

public class Retriable {
    public static <RETURN, THROWABLE extends Throwable> RETURN attempt(CheckedSupplier<RETURN, THROWABLE> supplier, Predicate<RETURN> shouldRetry, int maxAttempts, TimeDuration sleepTime, Supplier<?> name, Logger log) throws THROWABLE, InterruptedException {
        Objects.requireNonNull(supplier, "supplier == null");
        Objects.requireNonNull(shouldRetry, "shouldRetry == null");
        Preconditions.assertTrue((maxAttempts == -1 || maxAttempts > 0 ? 1 : 0) != 0);
        Preconditions.assertTrue((!sleepTime.isNegative() ? 1 : 0) != 0, () -> "sleepTime = " + sleepTime + " < 0");
        int i = 1;
        while (true) {
            try {
                Object ret = supplier.get();
                if (shouldRetry.test(ret) && (maxAttempts == -1 || i <= maxAttempts)) {
                    if (log != null && log.isDebugEnabled()) {
                        log.debug("Failed {}, attempt #{}, sleep {} and then retry", new Object[]{name.get(), i, sleepTime});
                    }
                } else {
                    return (RETURN)ret;
                }
                sleepTime.sleep();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (log != null && log.isWarnEnabled()) {
                    log.warn("{}: interrupted when waiting for retry", name.get());
                }
                throw e;
            }
            ++i;
        }
    }

    public static void attemptUntilTrue(BooleanSupplier condition, TimeDuration sleepTime, String name, Logger log) throws InterruptedException {
        Objects.requireNonNull(condition, "condition == null");
        Retriable.attempt(() -> null, ret -> !condition.getAsBoolean(), -1, sleepTime, () -> name, log);
    }

    public static <RETURN, THROWABLE extends Throwable> RETURN attempt(CheckedSupplier<RETURN, THROWABLE> supplier, RetryPolicy<RETURN> policy, Supplier<?> name, Logger logger) throws THROWABLE, InterruptedException {
        return (RETURN)Retriable.attempt(supplier, policy::shouldRetry, policy.getMaxAttempts(), policy.getWaitTime(), name, logger);
    }
}

