/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;

public class SeriesScanOptions {
    private Filter globalTimeFilter;
    private Filter queryFilter;
    private final long limit;
    private final long offset;
    private final Set<String> allSensors;

    public SeriesScanOptions(Filter globalTimeFilter, Filter queryFilter, long limit, long offset, Set<String> allSensors) {
        this.globalTimeFilter = globalTimeFilter;
        this.queryFilter = queryFilter;
        this.limit = limit;
        this.offset = offset;
        this.allSensors = allSensors;
    }

    public static SeriesScanOptions getDefaultSeriesScanOptions(PartialPath seriesPath) {
        Builder builder = new Builder();
        if (seriesPath instanceof AlignedPath) {
            builder.withAllSensors(new HashSet<String>(((AlignedPath)seriesPath).getMeasurementList()));
        } else {
            builder.withAllSensors(new HashSet<String>(Collections.singletonList(seriesPath.getMeasurement())));
        }
        return builder.build();
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter;
    }

    public Filter getQueryFilter() {
        return this.queryFilter;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public Set<String> getAllSensors() {
        return this.allSensors;
    }

    public PaginationController getPaginationController() {
        return new PaginationController(this.limit, this.offset);
    }

    public void setTTL(long dataTTL) {
        this.globalTimeFilter = SeriesScanOptions.updateFilterUsingTTL(this.globalTimeFilter, dataTTL);
        if (this.queryFilter != null) {
            this.queryFilter = SeriesScanOptions.updateFilterUsingTTL(this.queryFilter, dataTTL);
        }
    }

    public static Filter updateFilterUsingTTL(Filter filter, long dataTTL) {
        if (dataTTL != Long.MAX_VALUE) {
            filter = filter != null ? new AndFilter(filter, (Filter)TimeFilter.gtEq((long)(CommonDateTimeUtils.currentTime() - dataTTL))) : TimeFilter.gtEq((long)(CommonDateTimeUtils.currentTime() - dataTTL));
        }
        return filter;
    }

    public static class Builder {
        private Filter globalTimeFilter = null;
        private Filter queryFilter = null;
        private long limit = 0L;
        private long offset = 0L;
        private Set<String> allSensors;

        public Builder withGlobalTimeFilter(Filter globalTimeFilter) {
            this.globalTimeFilter = globalTimeFilter;
            return this;
        }

        public Builder withQueryFilter(Filter queryFilter) {
            this.queryFilter = queryFilter;
            return this;
        }

        public Builder withLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder withOffset(long offset) {
            this.offset = offset;
            return this;
        }

        public void withAllSensors(Set<String> allSensors) {
            this.allSensors = allSensors;
        }

        public SeriesScanOptions build() {
            return new SeriesScanOptions(this.globalTimeFilter, this.queryFilter, this.limit, this.offset, this.allSensors);
        }
    }
}

