/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.template.TemplateIncompatibleException;
import org.apache.iotdb.db.exception.metadata.view.UnsupportedViewException;
import org.apache.iotdb.db.exception.sql.MeasurementNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.ColumnPaginationController;
import org.apache.iotdb.db.queryengine.plan.analyze.ConcatPathRewriter;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.GroupByLevelController;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.LoadTsfileAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.SelectIntoUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.SchemaValidator;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.optimization.LimitOffsetPushDown;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.DeviceViewIntoPathDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByConditionParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByCountParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupBySessionParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByVariationParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.IntoPathDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByConditionComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByCountComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupBySessionComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByVariationComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.IntoComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.PipeEnrichedInsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.PipeEnrichedLoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalBatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.ShowLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowQueriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowVersionStatement;
import org.apache.iotdb.db.schemaengine.schemaregion.view.visitor.GetSourcePathsVisitor;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.GroupByMonthFilter;
import org.apache.iotdb.tsfile.read.filter.PredicateRemoveNotRewriter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeVisitor
extends StatementVisitor<Analysis, MPPQueryContext> {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeVisitor.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final Expression DEVICE_EXPRESSION = TimeSeriesOperand.constructColumnHeaderExpression("Device", TSDataType.TEXT);
    private static final Expression END_TIME_EXPRESSION = TimeSeriesOperand.constructColumnHeaderExpression("__endTime", TSDataType.INT64);
    private final List<String> lastQueryColumnNames = new ArrayList<String>(Arrays.asList("TIME", "TIMESERIES", "VALUE", "DATATYPE"));
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private static final String WHERE_WRONG_TYPE_ERROR_MSG = "The output type of the expression in WHERE clause should be BOOLEAN, actual data type: %s.";

    public AnalyzeVisitor(IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
    }

    @Override
    public Analysis visitNode(StatementNode node, MPPQueryContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
    }

    @Override
    public Analysis visitExplain(ExplainStatement explainStatement, MPPQueryContext context) {
        Analysis analysis = this.visitQuery(explainStatement.getQueryStatement(), context);
        analysis.setStatement(explainStatement);
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    @Override
    public Analysis visitQuery(QueryStatement queryStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setLastLevelUseWildcard(queryStatement.isLastLevelUseWildcard());
        try {
            List<Pair<Expression, String>> outputExpressions;
            queryStatement.semanticCheck();
            ISchemaTree schemaTree = this.analyzeSchema(queryStatement, analysis, context);
            if (schemaTree.isEmpty()) {
                return this.finishQuery(queryStatement, analysis);
            }
            this.analyzeGlobalTimeFilter(analysis, queryStatement);
            if (queryStatement.isLastQuery()) {
                return this.analyzeLastQuery(queryStatement, analysis, schemaTree);
            }
            if (queryStatement.isAlignByDevice()) {
                List<PartialPath> deviceList = this.analyzeFrom(queryStatement, schemaTree);
                if (LimitOffsetPushDown.canPushDownLimitOffsetInGroupByTimeForDevice(queryStatement)) {
                    deviceList = LimitOffsetPushDown.pushDownLimitOffsetInGroupByTimeForDevice(deviceList, queryStatement);
                }
                this.analyzeDeviceToWhere(analysis, queryStatement, schemaTree, deviceList);
                outputExpressions = this.analyzeSelect(analysis, queryStatement, schemaTree, deviceList);
                if (deviceList.isEmpty()) {
                    return this.finishQuery(queryStatement, analysis);
                }
                analysis.setDeviceList(deviceList);
                this.analyzeDeviceToGroupBy(analysis, queryStatement, schemaTree, deviceList);
                this.analyzeDeviceToOrderBy(analysis, queryStatement, schemaTree, deviceList);
                this.analyzeHaving(analysis, queryStatement, schemaTree, deviceList);
                this.analyzeDeviceToAggregation(analysis, queryStatement);
                this.analyzeDeviceToSourceTransform(analysis, queryStatement);
                this.analyzeDeviceToSource(analysis, queryStatement);
                this.analyzeDeviceViewOutput(analysis, queryStatement);
                this.analyzeDeviceViewInput(analysis, queryStatement);
                this.analyzeInto(analysis, queryStatement, deviceList, outputExpressions);
            } else {
                Map<Integer, List<Pair<Expression, String>>> outputExpressionMap = this.analyzeSelect(analysis, queryStatement, schemaTree);
                outputExpressions = new ArrayList<Pair<Expression, String>>();
                outputExpressionMap.values().forEach(outputExpressions::addAll);
                analysis.setOutputExpressions(outputExpressions);
                if (outputExpressions.isEmpty()) {
                    return this.finishQuery(queryStatement, analysis);
                }
                this.analyzeGroupBy(analysis, queryStatement, schemaTree);
                this.analyzeHaving(analysis, queryStatement, schemaTree);
                this.analyzeOrderBy(analysis, queryStatement, schemaTree);
                this.analyzeGroupByLevel(analysis, queryStatement, outputExpressionMap, outputExpressions);
                this.analyzeGroupByTag(analysis, queryStatement, outputExpressions);
                LinkedHashSet<Expression> selectExpressions = new LinkedHashSet<Expression>();
                if (queryStatement.isOutputEndTime()) {
                    selectExpressions.add(END_TIME_EXPRESSION);
                }
                for (Pair<Expression, String> outputExpressionAndAlias : outputExpressions) {
                    Expression outputExpression = (Expression)outputExpressionAndAlias.left;
                    selectExpressions.add(outputExpression);
                }
                analysis.setSelectExpressions(selectExpressions);
                this.analyzeAggregation(analysis, queryStatement);
                this.analyzeWhere(analysis, queryStatement, schemaTree);
                this.analyzeSourceTransform(analysis, outputExpressions, queryStatement);
                this.analyzeSource(analysis, queryStatement);
                this.analyzeInto(analysis, queryStatement, outputExpressions);
            }
            this.analyzeGroupByTime(analysis, queryStatement);
            this.analyzeFill(analysis, queryStatement);
            this.analyzeOutput(analysis, queryStatement, outputExpressions);
            this.analyzeDataPartition(analysis, queryStatement, schemaTree);
        }
        catch (StatementAnalyzeException e) {
            throw new StatementAnalyzeException("Meet error when analyzing the query statement: " + e.getMessage());
        }
        return analysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchemaTree analyzeSchema(QueryStatement queryStatement, Analysis analysis, MPPQueryContext context) {
        ISchemaTree schemaTree;
        ConcatPathRewriter concatPathRewriter = new ConcatPathRewriter();
        queryStatement = (QueryStatement)concatPathRewriter.rewrite(queryStatement, new PathPatternTree(queryStatement.useWildcard()));
        analysis.setStatement(queryStatement);
        long startTime = System.nanoTime();
        try {
            logger.debug("[StartFetchSchema]");
            schemaTree = queryStatement.isGroupByTag() ? this.schemaFetcher.fetchSchemaWithTags(concatPathRewriter.getPatternTree(), context) : this.schemaFetcher.fetchSchema(concatPathRewriter.getPatternTree(), context);
            this.updateSchemaTreeByViews(analysis, schemaTree);
        }
        finally {
            logger.debug("[EndFetchSchema]");
            QueryPlanCostMetricSet.getInstance().recordPlanCost("schema_fetcher", System.nanoTime() - startTime);
        }
        analysis.setSchemaTree(schemaTree);
        return schemaTree;
    }

    private Analysis finishQuery(QueryStatement queryStatement, Analysis analysis) {
        if (queryStatement.isSelectInto()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getSelectIntoHeader(queryStatement.isAlignByDevice()));
        }
        if (queryStatement.isLastQuery()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
        }
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private void analyzeGlobalTimeFilter(Analysis analysis, QueryStatement queryStatement) {
        Filter globalTimeFilter = null;
        boolean hasValueFilter = false;
        if (queryStatement.getWhereCondition() != null) {
            WhereCondition whereCondition = queryStatement.getWhereCondition();
            Expression predicate = whereCondition.getPredicate();
            Pair<Filter, Boolean> resultPair = ExpressionAnalyzer.extractGlobalTimeFilter(predicate, true, true);
            globalTimeFilter = (Filter)resultPair.left;
            if (globalTimeFilter != null) {
                globalTimeFilter = PredicateRemoveNotRewriter.rewrite((Filter)globalTimeFilter);
            }
            hasValueFilter = (Boolean)resultPair.right;
            predicate = ExpressionAnalyzer.evaluatePredicate(predicate);
            if (!hasValueFilter || predicate.getExpressionType().equals((Object)ExpressionType.CONSTANT) && Boolean.parseBoolean(predicate.getExpressionString())) {
                queryStatement.setWhereCondition(null);
            } else {
                whereCondition.setPredicate(predicate);
            }
        }
        analysis.setGlobalTimeFilter(globalTimeFilter);
        analysis.setHasValueFilter(hasValueFilter);
    }

    private Analysis analyzeLastQuery(QueryStatement queryStatement, Analysis analysis, ISchemaTree schemaTree) {
        if (analysis.hasValueFilter()) {
            throw new SemanticException("Only time filters are supported in LAST query");
        }
        this.analyzeLastOrderBy(analysis, queryStatement);
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            selectExpressions.add(resultColumn.getExpression());
        }
        this.analyzeLastSource(analysis, selectExpressions, schemaTree);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
        this.analyzeDataPartition(analysis, queryStatement, schemaTree);
        return analysis;
    }

    private void analyzeLastSource(Analysis analysis, List<Expression> selectExpressions, ISchemaTree schemaTree) {
        LinkedHashSet<Expression> sourceExpressions = new LinkedHashSet<Expression>();
        LinkedHashSet<Expression> lastQueryBaseExpressions = new LinkedHashSet<Expression>();
        HashMap<Expression, List<Expression>> lastQueryNonWritableViewSourceExpressionMap = null;
        for (Expression selectExpression : selectExpressions) {
            for (Expression lastQuerySourceExpression : ExpressionAnalyzer.bindSchemaForExpression(selectExpression, schemaTree)) {
                if (lastQuerySourceExpression instanceof TimeSeriesOperand) {
                    lastQueryBaseExpressions.add(lastQuerySourceExpression);
                    sourceExpressions.add(lastQuerySourceExpression);
                    continue;
                }
                if (lastQueryNonWritableViewSourceExpressionMap == null) {
                    lastQueryNonWritableViewSourceExpressionMap = new HashMap<Expression, List<Expression>>();
                }
                List<Expression> sourceExpressionsOfNonWritableView = ExpressionAnalyzer.searchSourceExpressions(lastQuerySourceExpression);
                lastQueryNonWritableViewSourceExpressionMap.put(lastQuerySourceExpression, sourceExpressionsOfNonWritableView);
                sourceExpressions.addAll(sourceExpressionsOfNonWritableView);
            }
        }
        analysis.setSourceExpressions(sourceExpressions);
        analysis.setLastQueryBaseExpressions(lastQueryBaseExpressions);
        analysis.setLastQueryNonWritableViewSourceExpressionMap(lastQueryNonWritableViewSourceExpressionMap);
    }

    private void updateSchemaTreeByViews(Analysis analysis, ISchemaTree originSchemaTree) {
        if (!originSchemaTree.hasLogicalViewMeasurement()) {
            return;
        }
        PathPatternTree patternTree = new PathPatternTree();
        boolean needToReFetch = false;
        boolean useLogicalView = false;
        try {
            Pair<List<MeasurementPath>, Integer> tempPair = originSchemaTree.searchMeasurementPaths(new PartialPath("root.**"));
            for (MeasurementPath measurementPath : (List)tempPair.left) {
                if (!measurementPath.getMeasurementSchema().isLogicalView()) continue;
                useLogicalView = true;
                LogicalViewSchema logicalViewSchema = (LogicalViewSchema)measurementPath.getMeasurementSchema();
                ViewExpression viewExpression = logicalViewSchema.getExpression();
                List<PartialPath> pathsNeedToReFetch = GetSourcePathsVisitor.getSourcePaths(viewExpression);
                for (PartialPath path : pathsNeedToReFetch) {
                    patternTree.appendFullPath(path);
                    needToReFetch = true;
                }
            }
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        analysis.setUseLogicalView(useLogicalView);
        if (useLogicalView && analysis.getStatement() instanceof QueryStatement && ((QueryStatement)analysis.getStatement()).isGroupByTag()) {
            throw new SemanticException("Views cannot be used in GROUP BY TAGS query yet.");
        }
        if (needToReFetch) {
            ISchemaTree viewSchemaTree = this.schemaFetcher.fetchSchema(patternTree, null);
            originSchemaTree.mergeSchemaTree(viewSchemaTree);
            Set<String> allDatabases = viewSchemaTree.getDatabases();
            allDatabases.addAll(originSchemaTree.getDatabases());
            originSchemaTree.setDatabases(allDatabases);
        }
    }

    private Map<Integer, List<Pair<Expression, String>>> analyzeSelect(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        HashMap<Integer, List<Pair<Expression, String>>> outputExpressionMap = new HashMap<Integer, List<Pair<Expression, String>>>();
        boolean isGroupByLevel = queryStatement.isGroupByLevel();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), queryStatement.isLastQuery() || isGroupByLevel);
        HashSet<String> aliasSet = new HashSet<String>();
        int columnIndex = 0;
        for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            ArrayList<Pair> outputExpressions = new ArrayList<Pair>();
            List<Expression> resultExpressions = ExpressionAnalyzer.bindSchemaForExpression(resultColumn.getExpression(), schemaTree);
            for (Expression resultExpression : resultExpressions) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) break;
                if (isGroupByLevel) {
                    this.analyzeExpressionType(analysis, resultExpression);
                    outputExpressions.add(new Pair((Object)resultExpression, (Object)resultColumn.getAlias()));
                    queryStatement.getGroupByLevelComponent().updateIsCountStar(resultColumn.getExpression());
                } else {
                    Expression normalizedExpression = ExpressionAnalyzer.normalizeExpression(resultExpression);
                    this.analyzeExpressionType(analysis, normalizedExpression);
                    this.checkAliasUniqueness(resultColumn.getAlias(), aliasSet);
                    outputExpressions.add(new Pair((Object)normalizedExpression, (Object)this.analyzeAlias(resultColumn.getAlias(), resultExpression, normalizedExpression, queryStatement)));
                }
                paginationController.consumeLimit();
            }
            outputExpressionMap.put(columnIndex++, outputExpressions);
        }
        return outputExpressionMap;
    }

    private List<PartialPath> analyzeFrom(QueryStatement queryStatement, ISchemaTree schemaTree) {
        List<PartialPath> devicePatternList = queryStatement.getFromComponent().getPrefixPaths();
        HashSet deviceSet = new HashSet();
        for (PartialPath devicePattern : devicePatternList) {
            deviceSet.addAll(schemaTree.getMatchedDevices(devicePattern).stream().map(DeviceSchemaInfo::getDevicePath).collect(Collectors.toList()));
        }
        return queryStatement.getResultDeviceOrder() == Ordering.ASC ? deviceSet.stream().sorted().collect(Collectors.toList()) : deviceSet.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    private List<Pair<Expression, String>> analyzeSelect(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet) {
        ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
        HashMap<String, Set<Expression>> deviceToSelectExpressions = new HashMap<String, Set<Expression>>();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
        block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            Expression selectExpression = resultColumn.getExpression();
            LinkedHashMap<Expression, Map<String, Expression>> measurementToDeviceSelectExpressions = new LinkedHashMap<Expression, Map<String, Expression>>();
            for (PartialPath partialPath : deviceSet) {
                List<Expression> selectExpressionsOfOneDevice = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(selectExpression, partialPath, schemaTree);
                if (selectExpressionsOfOneDevice.isEmpty()) continue;
                this.updateMeasurementToDeviceSelectExpressions(analysis, measurementToDeviceSelectExpressions, partialPath, selectExpressionsOfOneDevice);
            }
            this.checkAliasUniqueness(resultColumn.getAlias(), measurementToDeviceSelectExpressions);
            for (Map.Entry entry : measurementToDeviceSelectExpressions.entrySet()) {
                Expression measurementExpression = (Expression)entry.getKey();
                Map deviceToSelectExpressionsOfOneMeasurement = (Map)entry.getValue();
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) continue block0;
                deviceToSelectExpressionsOfOneMeasurement.values().forEach(expression -> this.analyzeExpressionType(analysis, (Expression)expression));
                this.checkDataTypeConsistencyInAlignByDevice(analysis, new ArrayList<Expression>(deviceToSelectExpressionsOfOneMeasurement.values()));
                Expression lowerCaseMeasurementExpression = ExpressionAnalyzer.toLowerCaseExpression(measurementExpression);
                this.analyzeExpressionType(analysis, lowerCaseMeasurementExpression);
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)lowerCaseMeasurementExpression, (Object)this.analyzeAlias(resultColumn.getAlias(), measurementExpression, lowerCaseMeasurementExpression, queryStatement)));
                this.updateDeviceToSelectExpressions(analysis, deviceToSelectExpressions, deviceToSelectExpressionsOfOneMeasurement);
                paginationController.consumeLimit();
            }
        }
        HashSet<PartialPath> noMeasurementDevices = new HashSet<PartialPath>();
        for (PartialPath device : deviceSet) {
            if (deviceToSelectExpressions.containsKey(device.getFullPath())) continue;
            noMeasurementDevices.add(device);
        }
        deviceSet.removeAll(noMeasurementDevices);
        if (analysis.getDeviceToWhereExpression() != null) {
            noMeasurementDevices.forEach(devicePath -> analysis.getDeviceToWhereExpression().remove(devicePath.getFullPath()));
        }
        LinkedHashSet<Expression> linkedHashSet = new LinkedHashSet<Expression>();
        linkedHashSet.add(DEVICE_EXPRESSION);
        if (queryStatement.isOutputEndTime()) {
            linkedHashSet.add(END_TIME_EXPRESSION);
        }
        outputExpressions.forEach(pair -> selectExpressions.add((Expression)pair.getLeft()));
        analysis.setSelectExpressions(linkedHashSet);
        analysis.setDeviceToSelectExpressions(deviceToSelectExpressions);
        return outputExpressions;
    }

    private void updateMeasurementToDeviceSelectExpressions(Analysis analysis, Map<Expression, Map<String, Expression>> measurementToDeviceSelectExpressions, PartialPath device, List<Expression> selectExpressionsOfOneDevice) {
        for (Expression expression : selectExpressionsOfOneDevice) {
            Expression measurementExpression = ExpressionAnalyzer.getMeasurementExpression(expression, analysis);
            measurementToDeviceSelectExpressions.computeIfAbsent(measurementExpression, key -> new LinkedHashMap()).put(device.getFullPath(), ExpressionAnalyzer.toLowerCaseExpression(expression));
        }
    }

    private void updateDeviceToSelectExpressions(Analysis analysis, Map<String, Set<Expression>> deviceToSelectExpressions, Map<String, Expression> deviceToSelectExpressionsOfOneMeasurement) {
        for (Map.Entry<String, Expression> entry : deviceToSelectExpressionsOfOneMeasurement.entrySet()) {
            String deviceName = entry.getKey();
            Expression expression = entry.getValue();
            Expression lowerCaseExpression = ExpressionAnalyzer.toLowerCaseExpression(expression);
            this.analyzeExpressionType(analysis, lowerCaseExpression);
            deviceToSelectExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(lowerCaseExpression);
        }
    }

    private String analyzeAlias(String resultColumnAlias, Expression rawExpression, Expression normalizedExpression, QueryStatement queryStatement) {
        if (resultColumnAlias != null) {
            return resultColumnAlias;
        }
        if (queryStatement.isCountTimeAggregation()) {
            return "count_time(*)";
        }
        if (!Objects.equals(normalizedExpression, rawExpression)) {
            return rawExpression.getOutputSymbol();
        }
        return null;
    }

    private void analyzeHaving(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        if (!queryStatement.hasHaving()) {
            return;
        }
        List<Expression> conJunctions = ExpressionAnalyzer.bindSchemaForPredicate(queryStatement.getHavingCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, true);
        Expression havingExpression = ExpressionUtils.constructQueryFilter(conJunctions.stream().distinct().collect(Collectors.toList()));
        TSDataType outputType = this.analyzeExpressionType(analysis, havingExpression = ExpressionAnalyzer.normalizeExpression(havingExpression));
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in HAVING clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setHavingExpression(havingExpression);
    }

    private void analyzeHaving(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet) {
        if (!queryStatement.hasHaving()) {
            return;
        }
        Map<String, Set<Expression>> deviceToAggregationExpressions = analysis.getDeviceToAggregationExpressions();
        Map<String, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        Expression havingExpression = queryStatement.getHavingCondition().getPredicate();
        HashSet conJunctions = new HashSet();
        for (PartialPath device : deviceSet) {
            List<Expression> expressionsInHaving = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(havingExpression, device, schemaTree);
            conJunctions.addAll(expressionsInHaving.stream().map(expression -> ExpressionAnalyzer.getMeasurementExpression(expression, analysis)).collect(Collectors.toList()));
            for (Expression expression2 : expressionsInHaving) {
                LinkedHashSet<Expression> aggregationExpressions = new LinkedHashSet<Expression>();
                LinkedHashSet<Expression> normalizedAggregationExpressions = new LinkedHashSet<Expression>();
                for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression2)) {
                    Expression normalizedAggregationExpression = ExpressionAnalyzer.normalizeExpression(aggregationExpression);
                    this.analyzeExpressionType(analysis, aggregationExpression);
                    this.analyzeExpressionType(analysis, normalizedAggregationExpression);
                    aggregationExpressions.add(aggregationExpression);
                    normalizedAggregationExpressions.add(normalizedAggregationExpression);
                }
                deviceToOutputExpressions.computeIfAbsent(device.getFullPath(), key -> new LinkedHashSet()).addAll(aggregationExpressions);
                deviceToAggregationExpressions.computeIfAbsent(device.getFullPath(), key -> new LinkedHashSet()).addAll(normalizedAggregationExpressions);
            }
        }
        havingExpression = ExpressionUtils.constructQueryFilter(new ArrayList<Expression>(conJunctions));
        TSDataType outputType = this.analyzeExpressionType(analysis, havingExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in HAVING clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setDeviceToAggregationExpressions(deviceToAggregationExpressions);
        analysis.setHavingExpression(havingExpression);
    }

    private void analyzeGroupByLevel(Analysis analysis, QueryStatement queryStatement, Map<Integer, List<Pair<Expression, String>>> outputExpressionMap, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isGroupByLevel()) {
            return;
        }
        GroupByLevelController groupByLevelController = new GroupByLevelController(queryStatement.getGroupByLevelComponent().getLevels());
        LinkedList groupedSelectExpressions = new LinkedList();
        for (List<Pair<Expression, String>> outputExpressionList : outputExpressionMap.values()) {
            LinkedHashSet<Expression> groupedSelectExpressionSet = new LinkedHashSet<Expression>();
            for (int i = 0; i < outputExpressionList.size(); ++i) {
                Pair<Expression, String> expressionAliasPair = outputExpressionList.get(i);
                boolean isCountStar = queryStatement.getGroupByLevelComponent().isCountStar(i);
                Expression groupedExpression = groupByLevelController.control(isCountStar, (Expression)expressionAliasPair.left, (String)expressionAliasPair.right);
                groupedSelectExpressionSet.add(groupedExpression);
            }
            groupedSelectExpressions.addAll(groupedSelectExpressionSet);
        }
        LinkedHashMap<Expression, Set<Expression>> groupByLevelExpressions = new LinkedHashMap<Expression, Set<Expression>>();
        if (queryStatement.hasHaving()) {
            Expression havingExpression = groupByLevelController.control(analysis.getHavingExpression());
            this.analyzeExpressionType(analysis, havingExpression);
            analysis.setHavingExpression(havingExpression);
            this.updateGroupByLevelExpressions(analysis, havingExpression, groupByLevelExpressions, groupByLevelController.getGroupedExpressionToRawExpressionsMap());
        }
        outputExpressions.clear();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
        for (Expression groupedExpression : groupedSelectExpressions) {
            if (paginationController.hasCurOffset()) {
                paginationController.consumeOffset();
                continue;
            }
            if (!paginationController.hasCurLimit()) break;
            Expression normalizedGroupedExpression = ExpressionAnalyzer.normalizeExpression(groupedExpression);
            this.analyzeExpressionType(analysis, normalizedGroupedExpression);
            outputExpressions.add((Pair<Expression, String>)new Pair((Object)normalizedGroupedExpression, (Object)this.analyzeAlias(groupByLevelController.getAlias(groupedExpression.getExpressionString()), groupedExpression, normalizedGroupedExpression, queryStatement)));
            this.updateGroupByLevelExpressions(analysis, groupedExpression, groupByLevelExpressions, groupByLevelController.getGroupedExpressionToRawExpressionsMap());
            paginationController.consumeLimit();
        }
        this.checkDataTypeConsistencyInGroupByLevel(analysis, groupByLevelExpressions);
        analysis.setCrossGroupByExpressions(groupByLevelExpressions);
    }

    private void checkDataTypeConsistencyInGroupByLevel(Analysis analysis, Map<Expression, Set<Expression>> groupByLevelExpressions) {
        for (Map.Entry<Expression, Set<Expression>> groupedExpressionRawExpressionsEntry : groupByLevelExpressions.entrySet()) {
            Expression groupedAggregationExpression = groupedExpressionRawExpressionsEntry.getKey();
            Set<Expression> rawAggregationExpressions = groupedExpressionRawExpressionsEntry.getValue();
            TSDataType checkedDataType = analysis.getType(groupedAggregationExpression);
            for (Expression rawAggregationExpression : rawAggregationExpressions) {
                if (analysis.getType(rawAggregationExpression) == checkedDataType) continue;
                throw new SemanticException(String.format("GROUP BY LEVEL: the data types of the same output column[%s] should be the same.", groupedAggregationExpression));
            }
        }
    }

    private void updateGroupByLevelExpressions(Analysis analysis, Expression expression, Map<Expression, Set<Expression>> groupByLevelExpressions, Map<Expression, Set<Expression>> groupedExpressionToRawExpressionsMap) {
        for (Expression groupedAggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
            Set<Expression> groupedExpressionSet = groupedExpressionToRawExpressionsMap.get(groupedAggregationExpression).stream().map(ExpressionAnalyzer::normalizeExpression).collect(Collectors.toSet());
            Expression groupedAggregationExpressionWithoutAlias = ExpressionAnalyzer.normalizeExpression(groupedAggregationExpression);
            this.analyzeExpressionType(analysis, groupedAggregationExpressionWithoutAlias);
            groupedExpressionSet.forEach(groupedExpression -> this.analyzeExpressionType(analysis, (Expression)groupedExpression));
            groupByLevelExpressions.computeIfAbsent(groupedAggregationExpressionWithoutAlias, key -> new HashSet()).addAll(groupedExpressionSet);
        }
    }

    private void analyzeGroupByTag(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isGroupByTag()) {
            return;
        }
        if (analysis.hasValueFilter()) {
            throw new SemanticException("Only time filters are supported in GROUP BY TAGS query");
        }
        List<String> tagKeys = queryStatement.getGroupByTagComponent().getTagKeys();
        HashMap<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands = new HashMap<List<String>, LinkedHashMap<Expression, List<Expression>>>();
        LinkedHashMap<Expression, Set<Expression>> outputExpressionToRawExpressionsMap = new LinkedHashMap<Expression, Set<Expression>>();
        for (Pair<Expression, String> outputExpressionAndAlias : outputExpressions) {
            FunctionExpression rawExpression = (FunctionExpression)outputExpressionAndAlias.getLeft();
            FunctionExpression measurementExpression = (FunctionExpression)ExpressionAnalyzer.getMeasurementExpression(rawExpression, analysis);
            outputExpressionToRawExpressionsMap.computeIfAbsent(measurementExpression, v -> new HashSet()).add(rawExpression);
            Map tagMap = ((MeasurementPath)((TimeSeriesOperand)measurementExpression.getExpressions().get(0)).getPath()).getTagMap();
            ArrayList<String> tagValues = new ArrayList<String>();
            for (String tagKey : tagKeys) {
                tagValues.add((String)tagMap.get(tagKey));
            }
            tagValuesToGroupedTimeseriesOperands.computeIfAbsent(tagValues, key -> new LinkedHashMap()).computeIfAbsent(measurementExpression, key -> new ArrayList()).add(rawExpression.getExpressions().get(0));
        }
        outputExpressions.clear();
        for (String tagKey : tagKeys) {
            TimeSeriesOperand tagKeyExpression = TimeSeriesOperand.constructColumnHeaderExpression(tagKey, TSDataType.TEXT);
            this.analyzeExpressionType(analysis, tagKeyExpression);
            outputExpressions.add((Pair<Expression, String>)new Pair((Object)tagKeyExpression, null));
        }
        for (Expression outputExpression : outputExpressionToRawExpressionsMap.keySet()) {
            this.analyzeExpressionType(analysis, outputExpression);
            outputExpressions.add((Pair<Expression, String>)new Pair((Object)outputExpression, null));
        }
        analysis.setTagKeys(queryStatement.getGroupByTagComponent().getTagKeys());
        analysis.setTagValuesToGroupedTimeseriesOperands(tagValuesToGroupedTimeseriesOperands);
        analysis.setCrossGroupByExpressions(outputExpressionToRawExpressionsMap);
    }

    private void analyzeDeviceToAggregation(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.isAggregationQuery()) {
            return;
        }
        this.updateDeviceToAggregationAndOutputExpressions(analysis, analysis.getDeviceToSelectExpressions());
        if (queryStatement.hasOrderByExpression()) {
            this.updateDeviceToAggregationAndOutputExpressions(analysis, analysis.getDeviceToOrderByExpressions());
        }
    }

    private void updateDeviceToAggregationAndOutputExpressions(Analysis analysis, Map<String, Set<Expression>> deviceToExpressions) {
        Map<String, Set<Expression>> deviceToAggregationExpressions = analysis.getDeviceToAggregationExpressions();
        Map<String, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        for (Map.Entry<String, Set<Expression>> deviceExpressionsEntry : deviceToExpressions.entrySet()) {
            String deviceName = deviceExpressionsEntry.getKey();
            Set<Expression> expressionSet = deviceExpressionsEntry.getValue();
            for (Expression expression : expressionSet) {
                for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
                    Expression normalizedAggregationExpression = ExpressionAnalyzer.normalizeExpression(aggregationExpression);
                    this.analyzeExpressionType(analysis, normalizedAggregationExpression);
                    deviceToOutputExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(aggregationExpression);
                    deviceToAggregationExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(normalizedAggregationExpression);
                }
            }
        }
    }

    private void analyzeAggregation(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.isAggregationQuery()) {
            return;
        }
        if (queryStatement.isGroupByLevel() || queryStatement.isGroupByTag()) {
            Set<Expression> aggregationExpressions = analysis.getCrossGroupByExpressions().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            analysis.setAggregationExpressions(aggregationExpressions);
            return;
        }
        HashSet<Expression> aggregationExpressions = new HashSet<Expression>();
        for (Expression expression : analysis.getSelectExpressions()) {
            aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(expression));
        }
        if (queryStatement.hasHaving()) {
            aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(analysis.getHavingExpression()));
        }
        if (queryStatement.hasOrderByExpression()) {
            for (Expression expression : analysis.getOrderByExpressions()) {
                aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(expression));
            }
        }
        analysis.setAggregationExpressions(aggregationExpressions);
    }

    private void analyzeDeviceToSourceTransform(Analysis analysis, QueryStatement queryStatement) {
        if (queryStatement.isAggregationQuery()) {
            Map<String, Set<Expression>> deviceToSourceTransformExpressions = analysis.getDeviceToSourceTransformExpressions();
            Map<String, Set<Expression>> deviceToAggregationExpressions = analysis.getDeviceToAggregationExpressions();
            for (Map.Entry<String, Set<Expression>> entry : deviceToAggregationExpressions.entrySet()) {
                String deviceName = entry.getKey();
                Set<Expression> aggregationExpressions = entry.getValue();
                Set sourceTransformExpressions = deviceToSourceTransformExpressions.computeIfAbsent(deviceName, k -> new LinkedHashSet());
                for (Expression expression : aggregationExpressions) {
                    if (queryStatement.isCountTimeAggregation()) {
                        for (Expression countTimeSourceExpression : ((FunctionExpression)expression).getCountTimeExpressions()) {
                            this.analyzeExpressionType(analysis, countTimeSourceExpression);
                            sourceTransformExpressions.add(countTimeSourceExpression);
                        }
                        continue;
                    }
                    sourceTransformExpressions.add(expression.getExpressions().get(0));
                }
                if (!queryStatement.hasGroupByExpression()) continue;
                sourceTransformExpressions.add(analysis.getDeviceToGroupByExpression().get(deviceName));
            }
        } else {
            this.updateDeviceToSourceTransformAndOutputExpressions(analysis, analysis.getDeviceToSelectExpressions());
            if (queryStatement.hasOrderByExpression()) {
                this.updateDeviceToSourceTransformAndOutputExpressions(analysis, analysis.getDeviceToOrderByExpressions());
            }
        }
    }

    private void updateDeviceToSourceTransformAndOutputExpressions(Analysis analysis, Map<String, Set<Expression>> deviceToExpressions) {
        Map<String, Set<Expression>> deviceToSourceTransformExpressions = analysis.getDeviceToSourceTransformExpressions();
        Map<String, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        for (Map.Entry<String, Set<Expression>> deviceExpressionsEntry : deviceToExpressions.entrySet()) {
            String deviceName = deviceExpressionsEntry.getKey();
            Set<Expression> expressions = deviceExpressionsEntry.getValue();
            LinkedHashSet<Expression> normalizedExpressions = new LinkedHashSet<Expression>();
            for (Expression expression : expressions) {
                Expression normalizedExpression = ExpressionAnalyzer.normalizeExpression(expression);
                this.analyzeExpressionType(analysis, normalizedExpression);
                normalizedExpressions.add(normalizedExpression);
            }
            deviceToOutputExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).addAll(expressions);
            deviceToSourceTransformExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).addAll(normalizedExpressions);
        }
    }

    private void analyzeSourceTransform(Analysis analysis, List<Pair<Expression, String>> outputExpressions, QueryStatement queryStatement) {
        Set<Expression> sourceTransformExpressions = analysis.getSourceTransformExpressions();
        if (queryStatement.isAggregationQuery()) {
            if (queryStatement.isCountTimeAggregation()) {
                for (Pair<Expression, String> pair : outputExpressions) {
                    FunctionExpression countTimeExpression = (FunctionExpression)pair.left;
                    for (Expression countTimeSourceExpression : countTimeExpression.getCountTimeExpressions()) {
                        this.analyzeExpressionType(analysis, countTimeSourceExpression);
                        sourceTransformExpressions.add(countTimeSourceExpression);
                    }
                }
                Pair<Expression, String> firstCountTimeExpression = outputExpressions.get(0);
                outputExpressions.clear();
                outputExpressions.add(firstCountTimeExpression);
            } else {
                for (Expression aggExpression : analysis.getAggregationExpressions()) {
                    sourceTransformExpressions.add(aggExpression.getExpressions().get(0));
                }
            }
            if (queryStatement.hasGroupByExpression()) {
                sourceTransformExpressions.add(analysis.getGroupByExpression());
            }
        } else {
            sourceTransformExpressions.addAll(analysis.getSelectExpressions());
            if (queryStatement.hasOrderByExpression()) {
                sourceTransformExpressions.addAll(analysis.getOrderByExpressions());
            }
        }
    }

    private void analyzeDeviceToSource(Analysis analysis, QueryStatement queryStatement) {
        String deviceName;
        HashMap<String, Set<Expression>> deviceToSourceExpressions = new HashMap<String, Set<Expression>>();
        Map<String, Set<Expression>> deviceToSourceTransformExpressions = analysis.getDeviceToSourceTransformExpressions();
        for (Map.Entry<String, Set<Expression>> entry : deviceToSourceTransformExpressions.entrySet()) {
            String string = entry.getKey();
            Set<Expression> sourceTransformExpressions = entry.getValue();
            LinkedHashSet sourceExpressions = new LinkedHashSet();
            sourceTransformExpressions.forEach(expression -> sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(expression)));
            deviceToSourceExpressions.put(string, sourceExpressions);
        }
        if (queryStatement.hasWhere()) {
            Map<String, Expression> deviceToWhereExpression = analysis.getDeviceToWhereExpression();
            for (Map.Entry<String, Expression> entry : deviceToWhereExpression.entrySet()) {
                deviceName = entry.getKey();
                Expression whereExpression = entry.getValue();
                deviceToSourceExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).addAll(ExpressionAnalyzer.searchSourceExpressions(whereExpression));
            }
        }
        LinkedHashMap<String, List<String>> outputDeviceToQueriedDevicesMap = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, Expression> entry : deviceToSourceExpressions.entrySet()) {
            deviceName = entry.getKey();
            Set sourceExpressionsUnderDevice = (Set)((Object)entry.getValue());
            HashSet<String> queriedDevices = new HashSet<String>();
            for (Expression expression2 : sourceExpressionsUnderDevice) {
                queriedDevices.add(ExpressionAnalyzer.getDeviceNameInSourceExpression(expression2));
            }
            if (queriedDevices.size() > 1) {
                throw new SemanticException("Cross-device queries are not supported in ALIGN BY DEVICE queries.");
            }
            outputDeviceToQueriedDevicesMap.put(deviceName, new ArrayList(queriedDevices));
        }
        analysis.setDeviceToSourceExpressions(deviceToSourceExpressions);
        analysis.setOutputDeviceToQueriedDevicesMap(outputDeviceToQueriedDevicesMap);
    }

    private void analyzeSource(Analysis analysis, QueryStatement queryStatement) {
        Set<Expression> sourceExpressions = analysis.getSourceExpressions();
        if (sourceExpressions == null) {
            sourceExpressions = new HashSet<Expression>();
            analysis.setSourceExpressions(sourceExpressions);
        }
        for (Expression expression : analysis.getSourceTransformExpressions()) {
            sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(expression));
        }
        if (queryStatement.hasWhere()) {
            sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(analysis.getWhereExpression()));
        }
    }

    private void analyzeDeviceToWhere(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet) {
        if (!queryStatement.hasWhere()) {
            return;
        }
        HashMap<String, Expression> deviceToWhereExpression = new HashMap<String, Expression>();
        Iterator<PartialPath> deviceIterator = deviceSet.iterator();
        while (deviceIterator.hasNext()) {
            Expression whereExpression;
            PartialPath devicePath = deviceIterator.next();
            try {
                whereExpression = ExpressionAnalyzer.normalizeExpression(this.analyzeWhereSplitByDevice(queryStatement, devicePath, schemaTree));
            }
            catch (MeasurementNotExistException e) {
                logger.warn("Meets MeasurementNotExistException in analyzeDeviceToWhere when executing align by device, error msg: {}", (Object)e.getMessage());
                deviceIterator.remove();
                continue;
            }
            TSDataType outputType = this.analyzeExpressionType(analysis, whereExpression);
            if (outputType != TSDataType.BOOLEAN) {
                throw new SemanticException(String.format(WHERE_WRONG_TYPE_ERROR_MSG, outputType));
            }
            deviceToWhereExpression.put(devicePath.getFullPath(), whereExpression);
        }
        analysis.setDeviceToWhereExpression(deviceToWhereExpression);
    }

    private void analyzeWhere(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        if (!queryStatement.hasWhere()) {
            return;
        }
        List<Expression> conJunctions = ExpressionAnalyzer.bindSchemaForPredicate(queryStatement.getWhereCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, true);
        Expression whereExpression = ExpressionUtils.constructQueryFilter(conJunctions.stream().distinct().collect(Collectors.toList()));
        TSDataType outputType = this.analyzeExpressionType(analysis, whereExpression = ExpressionAnalyzer.normalizeExpression(whereExpression));
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format(WHERE_WRONG_TYPE_ERROR_MSG, outputType));
        }
        analysis.setWhereExpression(whereExpression);
    }

    private Expression analyzeWhereSplitByDevice(QueryStatement queryStatement, PartialPath devicePath, ISchemaTree schemaTree) {
        List<Expression> conJunctions = ExpressionAnalyzer.concatDeviceAndBindSchemaForPredicate(queryStatement.getWhereCondition().getPredicate(), devicePath, schemaTree, true);
        return ExpressionUtils.constructQueryFilter(conJunctions.stream().distinct().collect(Collectors.toList()));
    }

    private void analyzeDeviceViewOutput(Analysis analysis, QueryStatement queryStatement) {
        Set<Expression> selectExpressions = analysis.getSelectExpressions();
        LinkedHashSet<Expression> deviceViewOutputExpressions = new LinkedHashSet<Expression>();
        if (queryStatement.isAggregationQuery()) {
            deviceViewOutputExpressions.add(DEVICE_EXPRESSION);
            if (queryStatement.isOutputEndTime()) {
                deviceViewOutputExpressions.add(END_TIME_EXPRESSION);
            }
            for (Expression selectExpression : selectExpressions) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(selectExpression));
            }
            if (queryStatement.hasHaving()) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(analysis.getHavingExpression()));
            }
            if (queryStatement.hasOrderByExpression()) {
                for (Expression orderByExpression : analysis.getOrderByExpressions()) {
                    deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(orderByExpression));
                }
            }
        } else {
            deviceViewOutputExpressions.addAll(selectExpressions);
            if (queryStatement.hasOrderByExpression()) {
                deviceViewOutputExpressions.addAll(analysis.getOrderByExpressions());
            }
        }
        analysis.setDeviceViewOutputExpressions(deviceViewOutputExpressions);
        analysis.setDeviceViewSpecialProcess(this.analyzeDeviceViewSpecialProcess(deviceViewOutputExpressions, queryStatement, analysis));
    }

    private boolean analyzeDeviceViewSpecialProcess(Set<Expression> deviceViewOutputExpressions, QueryStatement queryStatement, Analysis analysis) {
        if (queryStatement.isAggregationQuery() || queryStatement.hasWhere() && ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(queryStatement.getWhereCondition().getPredicate(), analysis)) {
            return true;
        }
        for (Expression expression : deviceViewOutputExpressions) {
            if (!ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(expression, analysis)) continue;
            return true;
        }
        return false;
    }

    private void analyzeDeviceViewInput(Analysis analysis, QueryStatement queryStatement) {
        List deviceViewOutputColumns = analysis.getDeviceViewOutputExpressions().stream().map(Expression::getOutputSymbol).collect(Collectors.toList());
        LinkedHashMap deviceToOutputColumnsMap = new LinkedHashMap();
        Map<String, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        for (Map.Entry<String, Set<Expression>> deviceOutputExpressionEntry : deviceToOutputExpressions.entrySet()) {
            Set<Expression> outputExpressionsUnderDevice = deviceOutputExpressionEntry.getValue();
            this.checkDeviceViewInputUniqueness(outputExpressionsUnderDevice);
            LinkedHashSet<String> outputColumns = new LinkedHashSet<String>();
            if (queryStatement.isOutputEndTime()) {
                outputColumns.add("__endTime");
            }
            for (Expression expression : outputExpressionsUnderDevice) {
                outputColumns.add(ExpressionAnalyzer.getMeasurementExpression(expression, analysis).getOutputSymbol());
            }
            deviceToOutputColumnsMap.put(deviceOutputExpressionEntry.getKey(), outputColumns);
        }
        HashMap<String, List<Integer>> deviceViewInputIndexesMap = new HashMap<String, List<Integer>>();
        for (Map.Entry deviceOutputColumnsEntry : deviceToOutputColumnsMap.entrySet()) {
            String deviceName = (String)deviceOutputColumnsEntry.getKey();
            ArrayList outputsUnderDevice = new ArrayList((Collection)deviceOutputColumnsEntry.getValue());
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (String output : outputsUnderDevice) {
                int index = deviceViewOutputColumns.indexOf(output);
                Preconditions.checkState((index >= 1 ? 1 : 0) != 0, (String)"output column '%s' is not stored in %s", (Object)output, deviceViewOutputColumns);
                indexes.add(index);
            }
            deviceViewInputIndexesMap.put(deviceName, indexes);
        }
        analysis.setDeviceViewInputIndexesMap(deviceViewInputIndexesMap);
    }

    private void checkDeviceViewInputUniqueness(Set<Expression> outputExpressionsUnderDevice) {
        Set normalizedOutputExpressionsUnderDevice = outputExpressionsUnderDevice.stream().map(ExpressionAnalyzer::normalizeExpression).collect(Collectors.toSet());
        if (normalizedOutputExpressionsUnderDevice.size() < outputExpressionsUnderDevice.size()) {
            throw new SemanticException("Views or measurement aliases representing the same data source cannot be queried concurrently in ALIGN BY DEVICE queries.");
        }
    }

    private void analyzeOutput(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (queryStatement.isSelectInto()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getSelectIntoHeader(queryStatement.isAlignByDevice()));
            return;
        }
        boolean isIgnoreTimestamp = queryStatement.isAggregationQuery() && !queryStatement.isGroupBy();
        ArrayList<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
        if (queryStatement.isAlignByDevice()) {
            columnHeaders.add(new ColumnHeader("Device", TSDataType.TEXT, null));
        }
        if (queryStatement.isOutputEndTime()) {
            columnHeaders.add(new ColumnHeader("__endTime", TSDataType.INT64, null));
        }
        for (Pair<Expression, String> expressionAliasPair : outputExpressions) {
            columnHeaders.add(new ColumnHeader(((Expression)expressionAliasPair.left).getExpressionString(), analysis.getType((Expression)expressionAliasPair.left), (String)expressionAliasPair.right));
        }
        analysis.setRespDatasetHeader(new DatasetHeader(columnHeaders, isIgnoreTimestamp));
    }

    private void analyzeLastOrderBy(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.hasOrderBy()) {
            return;
        }
        if (queryStatement.onlyOrderByTimeseries()) {
            analysis.setTimeseriesOrderingForLastQuery(queryStatement.getOrderByComponent().getTimeseriesOrder());
        }
        for (SortItem sortItem : queryStatement.getSortItemList()) {
            String sortKey = sortItem.getSortKey();
            if (this.lastQueryColumnNames.contains(sortKey.toUpperCase())) continue;
            throw new SemanticException(String.format("%s in order by clause doesn't exist in the result of last query.", sortKey));
        }
    }

    private void analyzeOrderBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        if (!queryStatement.hasOrderByExpression()) {
            return;
        }
        LinkedHashSet<Expression> orderByExpressions = new LinkedHashSet<Expression>();
        for (Expression expressionForItem : queryStatement.getExpressionSortItemList()) {
            List<Expression> expressions = ExpressionAnalyzer.bindSchemaForExpression(expressionForItem, schemaTree);
            if (expressions.isEmpty()) {
                throw new SemanticException(String.format("%s in order by clause doesn't exist.", expressionForItem.getExpressionString()));
            }
            if (expressions.size() > 1) {
                throw new SemanticException(String.format("%s in order by clause shouldn't refer to more than one timeseries.", expressionForItem.getExpressionString()));
            }
            expressionForItem = ExpressionAnalyzer.normalizeExpression(expressions.get(0));
            TSDataType dataType = this.analyzeExpressionType(analysis, expressionForItem);
            if (!dataType.isComparable()) {
                throw new SemanticException(String.format("The data type of %s is not comparable", dataType));
            }
            orderByExpressions.add(expressionForItem);
        }
        analysis.setOrderByExpressions(orderByExpressions);
        queryStatement.updateSortItems(orderByExpressions);
    }

    private TSDataType analyzeExpressionType(Analysis analysis, Expression expression) {
        return ExpressionTypeAnalyzer.analyzeExpression(analysis, expression);
    }

    private void analyzeDeviceToGroupBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet) {
        GroupByParameter groupByParameter;
        if (queryStatement.getGroupByComponent() == null) {
            return;
        }
        GroupByComponent groupByComponent = queryStatement.getGroupByComponent();
        WindowType windowType = groupByComponent.getWindowType();
        LinkedHashMap<String, Expression> deviceToGroupByExpression = new LinkedHashMap<String, Expression>();
        if (queryStatement.hasGroupByExpression()) {
            Expression expression = groupByComponent.getControlColumnExpression();
            for (PartialPath device : deviceSet) {
                List<Expression> groupByExpressionsOfOneDevice = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(expression, device, schemaTree);
                if (groupByExpressionsOfOneDevice.isEmpty()) {
                    throw new SemanticException(String.format("%s in group by clause doesn't exist.", expression));
                }
                if (groupByExpressionsOfOneDevice.size() > 1) {
                    throw new SemanticException(String.format("%s in group by clause shouldn't refer to more than one timeseries.", expression));
                }
                deviceToGroupByExpression.put(device.getFullPath(), ExpressionAnalyzer.normalizeExpression((Expression)groupByExpressionsOfOneDevice.get(0)));
            }
        }
        switch (windowType) {
            case VARIATION_WINDOW: {
                double delta = ((GroupByVariationComponent)groupByComponent).getDelta();
                for (Expression expression : deviceToGroupByExpression.values()) {
                    this.checkGroupByVariationExpressionType(analysis, expression, delta);
                }
                groupByParameter = new GroupByVariationParameter(groupByComponent.isIgnoringNull(), delta);
                analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
                break;
            }
            case CONDITION_WINDOW: {
                Expression keepExpression = ((GroupByConditionComponent)groupByComponent).getKeepExpression();
                for (Expression expression : deviceToGroupByExpression.values()) {
                    this.checkGroupByConditionExpressionType(analysis, expression, keepExpression);
                }
                groupByParameter = new GroupByConditionParameter(groupByComponent.isIgnoringNull(), keepExpression);
                analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
                break;
            }
            case SESSION_WINDOW: {
                groupByParameter = new GroupBySessionParameter(((GroupBySessionComponent)groupByComponent).getTimeInterval());
                break;
            }
            case COUNT_WINDOW: {
                groupByParameter = new GroupByCountParameter(((GroupByCountComponent)groupByComponent).getCountNumber(), groupByComponent.isIgnoringNull());
                analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported window type");
            }
        }
        analysis.setGroupByParameter(groupByParameter);
    }

    private void analyzeDeviceToOrderBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet) {
        if (!queryStatement.hasOrderByExpression()) {
            return;
        }
        LinkedHashMap<String, Set<Expression>> deviceToOrderByExpressions = new LinkedHashMap<String, Set<Expression>>();
        LinkedHashMap<String, List<SortItem>> deviceToSortItems = new LinkedHashMap<String, List<SortItem>>();
        LinkedHashSet<Expression> deviceViewOrderByExpression = new LinkedHashSet<Expression>();
        for (PartialPath device : deviceSet) {
            LinkedHashSet<Expression> orderByExpressionsForOneDevice = new LinkedHashSet<Expression>();
            for (Expression expressionForItem : queryStatement.getExpressionSortItemList()) {
                List<Expression> expressions = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(expressionForItem, device, schemaTree);
                if (expressions.isEmpty()) {
                    throw new SemanticException(String.format("%s in order by clause doesn't exist.", expressionForItem.getExpressionString()));
                }
                if (expressions.size() > 1) {
                    throw new SemanticException(String.format("%s in order by clause shouldn't refer to more than one timeseries.", expressionForItem.getExpressionString()));
                }
                expressionForItem = expressions.get(0);
                TSDataType dataType = this.analyzeExpressionType(analysis, expressionForItem);
                if (!dataType.isComparable()) {
                    throw new SemanticException(String.format("The data type of %s is not comparable", dataType));
                }
                Expression deviceViewExpression = ExpressionAnalyzer.getMeasurementExpression(expressionForItem, analysis);
                this.analyzeExpressionType(analysis, deviceViewExpression);
                deviceViewOrderByExpression.add(deviceViewExpression);
                orderByExpressionsForOneDevice.add(expressionForItem);
            }
            deviceToSortItems.put(device.getFullPath(), queryStatement.getUpdatedSortItems(orderByExpressionsForOneDevice));
            deviceToOrderByExpressions.put(device.getFullPath(), orderByExpressionsForOneDevice);
        }
        analysis.setOrderByExpressions(deviceViewOrderByExpression);
        queryStatement.updateSortItems(deviceViewOrderByExpression);
        analysis.setDeviceToSortItems(deviceToSortItems);
        analysis.setDeviceToOrderByExpressions(deviceToOrderByExpressions);
    }

    private void analyzeGroupBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        if (queryStatement.getGroupByComponent() == null) {
            return;
        }
        GroupByComponent groupByComponent = queryStatement.getGroupByComponent();
        WindowType windowType = groupByComponent.getWindowType();
        Expression groupByExpression = null;
        if (queryStatement.hasGroupByExpression()) {
            groupByExpression = groupByComponent.getControlColumnExpression();
            List<Expression> expressions = ExpressionAnalyzer.bindSchemaForExpression(groupByExpression, schemaTree);
            if (expressions.isEmpty()) {
                throw new SemanticException(String.format("%s in group by clause doesn't exist.", groupByExpression.getExpressionString()));
            }
            if (expressions.size() > 1) {
                throw new SemanticException(String.format("%s in group by clause shouldn't refer to more than one timeseries.", groupByExpression.getExpressionString()));
            }
            List<Expression> aggregationExpression = ExpressionAnalyzer.searchAggregationExpressions(expressions.get(0));
            if (aggregationExpression != null && !aggregationExpression.isEmpty()) {
                throw new SemanticException("Aggregation expression shouldn't exist in group by clause");
            }
            groupByExpression = ExpressionAnalyzer.normalizeExpression(expressions.get(0));
        }
        if (windowType == WindowType.VARIATION_WINDOW) {
            double delta = ((GroupByVariationComponent)groupByComponent).getDelta();
            this.checkGroupByVariationExpressionType(analysis, groupByExpression, delta);
            GroupByVariationParameter groupByParameter = new GroupByVariationParameter(groupByComponent.isIgnoringNull(), delta);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.CONDITION_WINDOW) {
            Expression keepExpression = ((GroupByConditionComponent)groupByComponent).getKeepExpression();
            this.checkGroupByConditionExpressionType(analysis, groupByExpression, keepExpression);
            GroupByConditionParameter groupByParameter = new GroupByConditionParameter(groupByComponent.isIgnoringNull(), keepExpression);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.SESSION_WINDOW) {
            long interval = ((GroupBySessionComponent)groupByComponent).getTimeInterval();
            GroupBySessionParameter groupByParameter = new GroupBySessionParameter(interval);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.COUNT_WINDOW) {
            GroupByCountParameter groupByParameter = new GroupByCountParameter(((GroupByCountComponent)groupByComponent).getCountNumber(), groupByComponent.isIgnoringNull());
            this.analyzeExpressionType(analysis, groupByExpression);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else {
            throw new SemanticException("Unsupported window type");
        }
    }

    private void checkGroupByVariationExpressionType(Analysis analysis, Expression groupByExpression, double delta) {
        TSDataType type = this.analyzeExpressionType(analysis, groupByExpression);
        if (delta != 0.0 && !type.isNumeric()) {
            throw new SemanticException("Only support numeric type when delta != 0");
        }
    }

    private void checkGroupByConditionExpressionType(Analysis analysis, Expression groupByExpression, Expression keepExpression) {
        TSDataType type = this.analyzeExpressionType(analysis, groupByExpression);
        if (type != TSDataType.BOOLEAN) {
            throw new SemanticException("Only support boolean type in predict of group by series");
        }
        if (keepExpression instanceof CompareBinaryExpression) {
            Expression leftExpression = ((CompareBinaryExpression)keepExpression).getLeftExpression();
            Expression rightExpression = ((CompareBinaryExpression)keepExpression).getRightExpression();
            if (!(leftExpression instanceof TimeSeriesOperand && leftExpression.getExpressionString().equalsIgnoreCase("keep") && rightExpression instanceof ConstantOperand)) {
                throw new SemanticException(String.format("Please check the keep condition ([%s]),it need to be a constant or a compare expression constructed by 'keep' and a long number.", keepExpression.getExpressionString()));
            }
            return;
        }
        if (!(keepExpression instanceof ConstantOperand)) {
            throw new SemanticException(String.format("Please check the keep condition ([%s]),it need to be a constant or a compare expression constructed by 'keep' and a long number.", keepExpression.getExpressionString()));
        }
    }

    private void analyzeGroupByTime(Analysis analysis, QueryStatement queryStatement) {
        GroupByTimeComponent groupByTimeComponent;
        if (!queryStatement.isGroupByTime()) {
            return;
        }
        if (queryStatement.isResultSetEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        if (((groupByTimeComponent = queryStatement.getGroupByTimeComponent()).getInterval().containsMonth() || groupByTimeComponent.getSlidingStep().containsMonth()) && queryStatement.getResultTimeOrder() == Ordering.DESC) {
            throw new SemanticException("Group by month doesn't support order by time desc now.");
        }
        if (!queryStatement.isCqQueryBody() && groupByTimeComponent.getStartTime() == 0L && groupByTimeComponent.getEndTime() == 0L) {
            throw new SemanticException("The query time range should be specified in the GROUP BY TIME clause.");
        }
        analysis.setGroupByTimeParameter(new GroupByTimeParameter(groupByTimeComponent));
        Object globalTimeFilter = analysis.getGlobalTimeFilter();
        GroupByFilter groupByFilter = this.initGroupByFilter(groupByTimeComponent);
        globalTimeFilter = globalTimeFilter == null ? groupByFilter : FilterFactory.and((Filter)globalTimeFilter, (Filter)groupByFilter);
        analysis.setGlobalTimeFilter((Filter)globalTimeFilter);
    }

    private void analyzeFill(Analysis analysis, QueryStatement queryStatement) {
        if (queryStatement.getFillComponent() == null) {
            return;
        }
        FillComponent fillComponent = queryStatement.getFillComponent();
        analysis.setFillDescriptor(new FillDescriptor(fillComponent.getFillPolicy(), fillComponent.getFillValue()));
    }

    private void analyzeDataPartition(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        Set<String> deviceSet = new HashSet<String>();
        if (queryStatement.isAlignByDevice()) {
            deviceSet = analysis.getOutputDeviceToQueriedDevicesMap().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        } else {
            for (Expression expression : analysis.getSourceExpressions()) {
                deviceSet.add(ExpressionAnalyzer.getDeviceNameInSourceExpression(expression));
            }
        }
        DataPartition dataPartition = this.fetchDataPartitionByDevices(deviceSet, schemaTree, analysis.getGlobalTimeFilter());
        analysis.setDataPartitionInfo(dataPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataPartition fetchDataPartitionByDevices(Set<String> deviceSet, ISchemaTree schemaTree, Filter globalTimeFilter) {
        long startTime = System.nanoTime();
        try {
            DataPartition dataPartition;
            Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> res = AnalyzeVisitor.getTimePartitionSlotList(globalTimeFilter);
            if (((List)res.left).isEmpty() && Boolean.FALSE.equals(((Pair)res.right).left)) {
                DataPartition dataPartition2 = new DataPartition(Collections.emptyMap(), CONFIG.getSeriesPartitionExecutorClass(), CONFIG.getSeriesPartitionSlotNum());
                return dataPartition2;
            }
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            for (String devicePath : deviceSet) {
                DataPartitionQueryParam queryParam = new DataPartitionQueryParam(devicePath, (List)res.left, ((Boolean)((Pair)res.right).left).booleanValue(), ((Boolean)((Pair)res.right).right).booleanValue());
                sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedDatabase(devicePath), key -> new ArrayList()).add(queryParam);
            }
            if (((Boolean)((Pair)res.right).left).booleanValue() || ((Boolean)((Pair)res.right).right).booleanValue()) {
                dataPartition = this.partitionFetcher.getDataPartitionWithUnclosedTimeRange(sgNameToQueryParamsMap);
                return dataPartition;
            }
            dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            return dataPartition;
        }
        finally {
            QueryPlanCostMetricSet.getInstance().recordPlanCost("partition_fetcher", System.nanoTime() - startTime);
        }
    }

    public static Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> getTimePartitionSlotList(Filter timeFilter) {
        boolean needRightAll;
        TTimePartitionSlot timePartitionSlot;
        long endTime;
        boolean needLeftAll;
        if (timeFilter == null) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)true, (Object)true));
        }
        List timeRangeList = timeFilter.getTimeRanges();
        if (timeRangeList.isEmpty()) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)false, (Object)false));
        }
        if (timeRangeList.size() == 1 && ((TimeRange)timeRangeList.get(0)).getMin() == Long.MIN_VALUE && ((TimeRange)timeRangeList.get(timeRangeList.size() - 1)).getMax() == Long.MAX_VALUE) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)true, (Object)true));
        }
        int index = 0;
        int size = timeRangeList.size();
        if (((TimeRange)timeRangeList.get(0)).getMin() == Long.MIN_VALUE) {
            needLeftAll = true;
            endTime = TimePartitionUtils.getTimePartitionUpperBound((long)((TimeRange)timeRangeList.get(0)).getMax());
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)((TimeRange)timeRangeList.get(0)).getMax());
        } else {
            endTime = TimePartitionUtils.getTimePartitionUpperBound((long)((TimeRange)timeRangeList.get(0)).getMin());
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)((TimeRange)timeRangeList.get(0)).getMin());
            needLeftAll = false;
        }
        if (((TimeRange)timeRangeList.get(size - 1)).getMax() == Long.MAX_VALUE) {
            needRightAll = true;
            --size;
        } else {
            needRightAll = false;
        }
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        while (index < size) {
            long curLeft = ((TimeRange)timeRangeList.get(index)).getMin();
            long curRight = ((TimeRange)timeRangeList.get(index)).getMax();
            if (curLeft >= endTime) {
                result.add(timePartitionSlot);
                endTime = TimePartitionUtils.getTimePartitionUpperBound((long)curLeft);
                timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)curLeft);
                continue;
            }
            if (curRight >= endTime) {
                result.add(timePartitionSlot);
                timePartitionSlot = new TTimePartitionSlot(endTime);
                endTime += TimePartitionUtils.getTimePartitionInterval();
                continue;
            }
            ++index;
        }
        result.add(timePartitionSlot);
        if (needRightAll) {
            TTimePartitionSlot lastTimePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)((TimeRange)timeRangeList.get(timeRangeList.size() - 1)).getMin());
            if (lastTimePartitionSlot.startTime != timePartitionSlot.startTime) {
                result.add(lastTimePartitionSlot);
            }
        }
        return new Pair(result, (Object)new Pair((Object)needLeftAll, (Object)needRightAll));
    }

    private void analyzeInto(Analysis analysis, QueryStatement queryStatement, List<PartialPath> deviceSet, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isSelectInto()) {
            return;
        }
        queryStatement.setOrderByComponent(null);
        ArrayList<PartialPath> sourceDevices = new ArrayList<PartialPath>(deviceSet);
        List sourceColumns = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(ArrayList::new));
        IntoComponent intoComponent = queryStatement.getIntoComponent();
        intoComponent.validate(sourceDevices, sourceColumns);
        DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor = new DeviceViewIntoPathDescriptor();
        PathPatternTree targetPathTree = new PathPatternTree();
        IntoComponent.IntoDeviceMeasurementIterator intoDeviceMeasurementIterator = intoComponent.getIntoDeviceMeasurementIterator();
        for (PartialPath sourceDevice : sourceDevices) {
            PartialPath deviceTemplate = intoDeviceMeasurementIterator.getDeviceTemplate();
            boolean isAlignedDevice = intoDeviceMeasurementIterator.isAlignedDevice();
            PartialPath targetDevice = SelectIntoUtils.constructTargetDevice(sourceDevice, deviceTemplate);
            deviceViewIntoPathDescriptor.specifyDeviceAlignment(targetDevice.toString(), isAlignedDevice);
            for (Expression sourceColumn : sourceColumns) {
                String measurementTemplate = intoDeviceMeasurementIterator.getMeasurementTemplate();
                String targetMeasurement = sourceColumn instanceof TimeSeriesOperand ? SelectIntoUtils.constructTargetMeasurement(sourceDevice.concatNode(sourceColumn.getExpressionString()), measurementTemplate) : measurementTemplate;
                deviceViewIntoPathDescriptor.specifyTargetDeviceMeasurement(sourceDevice, targetDevice, sourceColumn.getExpressionString(), targetMeasurement);
                targetPathTree.appendFullPath(targetDevice, targetMeasurement);
                deviceViewIntoPathDescriptor.recordSourceColumnDataType(sourceColumn.getExpressionString(), analysis.getType(sourceColumn));
                intoDeviceMeasurementIterator.nextMeasurement();
            }
            intoDeviceMeasurementIterator.nextDevice();
        }
        deviceViewIntoPathDescriptor.validate();
        long startTime = System.nanoTime();
        ISchemaTree targetSchemaTree = this.schemaFetcher.fetchSchema(targetPathTree, null);
        QueryPlanCostMetricSet.getInstance().recordPlanCost("schema_fetcher", System.nanoTime() - startTime);
        deviceViewIntoPathDescriptor.bindType(targetSchemaTree);
        analysis.setDeviceViewIntoPathDescriptor(deviceViewIntoPathDescriptor);
    }

    private void analyzeInto(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isSelectInto()) {
            return;
        }
        queryStatement.setOrderByComponent(null);
        List sourceColumns = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(ArrayList::new));
        IntoComponent intoComponent = queryStatement.getIntoComponent();
        intoComponent.validate(sourceColumns);
        IntoPathDescriptor intoPathDescriptor = new IntoPathDescriptor();
        PathPatternTree targetPathTree = new PathPatternTree();
        IntoComponent.IntoPathIterator intoPathIterator = intoComponent.getIntoPathIterator();
        for (Pair<Expression, String> pair : outputExpressions) {
            PartialPath targetPath;
            Expression sourceExpression = (Expression)pair.left;
            String viewPath = (String)pair.right;
            PartialPath deviceTemplate = intoPathIterator.getDeviceTemplate();
            String measurementTemplate = intoPathIterator.getMeasurementTemplate();
            boolean isAlignedDevice = intoPathIterator.isAlignedDevice();
            String sourceColumn = sourceExpression.getExpressionString();
            if (sourceExpression instanceof TimeSeriesOperand) {
                PartialPath sourcePath;
                if (viewPath != null) {
                    try {
                        sourcePath = new PartialPath(viewPath);
                    }
                    catch (IllegalPathException e) {
                        throw new SemanticException(String.format("View path %s of source column %s is illegal path", viewPath, sourceColumn));
                    }
                } else {
                    sourcePath = ((TimeSeriesOperand)sourceExpression).getPath();
                }
                targetPath = SelectIntoUtils.constructTargetPath(sourcePath, deviceTemplate, measurementTemplate);
            } else {
                targetPath = deviceTemplate.concatNode(measurementTemplate);
            }
            intoPathDescriptor.specifyTargetPath(sourceColumn, viewPath, targetPath);
            intoPathDescriptor.specifyDeviceAlignment(targetPath.getDevicePath().toString(), isAlignedDevice);
            targetPathTree.appendFullPath(targetPath);
            intoPathDescriptor.recordSourceColumnDataType(sourceColumn, analysis.getType(sourceExpression));
            intoPathIterator.next();
        }
        intoPathDescriptor.validate();
        long startTime = System.nanoTime();
        ISchemaTree targetSchemaTree = this.schemaFetcher.fetchSchema(targetPathTree, null);
        this.updateSchemaTreeByViews(analysis, targetSchemaTree);
        QueryPlanCostMetricSet.getInstance().recordPlanCost("schema_fetcher", System.nanoTime() - startTime);
        intoPathDescriptor.bindType(targetSchemaTree);
        analysis.setIntoPathDescriptor(intoPathDescriptor);
    }

    private void checkDataTypeConsistencyInAlignByDevice(Analysis analysis, List<Expression> expressions) {
        TSDataType checkedDataType = analysis.getType(expressions.get(0));
        for (Expression expression : expressions) {
            if (analysis.getType(expression) == checkedDataType) continue;
            throw new SemanticException("ALIGN BY DEVICE: the data types of the same measurement column should be the same across devices.");
        }
    }

    private void checkAliasUniqueness(String alias, Set<String> aliasSet) {
        if (alias != null) {
            if (aliasSet.contains(alias)) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one time series", alias));
            }
            aliasSet.add(alias);
        }
    }

    private void checkAliasUniqueness(String alias, Map<Expression, Map<String, Expression>> measurementToDeviceSelectExpressions) {
        if (alias != null && measurementToDeviceSelectExpressions.keySet().size() > 1) {
            throw new SemanticException(String.format("alias '%s' can only be matched with one time series", alias));
        }
    }

    @Override
    public Analysis visitInsert(InsertStatement insertStatement, MPPQueryContext context) {
        int i;
        context.setQueryType(QueryType.WRITE);
        insertStatement.semanticCheck();
        long[] timeArray = insertStatement.getTimes();
        PartialPath devicePath = insertStatement.getDevice();
        String[] measurementList = insertStatement.getMeasurementList();
        if (timeArray.length == 1) {
            InsertRowStatement insertRowStatement = new InsertRowStatement();
            insertRowStatement.setDevicePath(devicePath);
            insertRowStatement.setTime(timeArray[0]);
            insertRowStatement.setMeasurements(measurementList);
            insertRowStatement.setDataTypes(new TSDataType[measurementList.length]);
            Object[] values = new Object[measurementList.length];
            System.arraycopy(insertStatement.getValuesList().get(0), 0, values, 0, values.length);
            insertRowStatement.setValues(values);
            insertRowStatement.setNeedInferType(true);
            insertRowStatement.setAligned(insertStatement.isAligned());
            return insertRowStatement.accept(this, context);
        }
        InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement = new InsertRowsOfOneDeviceStatement();
        if (!this.checkSorted(timeArray)) {
            Integer[] index = new Integer[timeArray.length];
            for (i = 0; i < index.length; ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(o -> timeArray[o]));
            Arrays.sort(timeArray, 0, timeArray.length);
            insertStatement.setValuesList(Arrays.stream(index).map(insertStatement.getValuesList()::get).collect(Collectors.toList()));
        }
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (i = 0; i < timeArray.length; ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(devicePath);
            String[] measurements = new String[measurementList.length];
            System.arraycopy(measurementList, 0, measurements, 0, measurements.length);
            statement.setMeasurements(measurements);
            statement.setTime(timeArray[i]);
            TSDataType[] dataTypes = new TSDataType[measurementList.length];
            statement.setDataTypes(dataTypes);
            Object[] values = new Object[measurementList.length];
            System.arraycopy(insertStatement.getValuesList().get(i), 0, values, 0, values.length);
            statement.setValues(values);
            statement.setAligned(insertStatement.isAligned());
            statement.setNeedInferType(true);
            insertRowStatementList.add(statement);
        }
        insertRowsOfOneDeviceStatement.setInsertRowStatementList(insertRowStatementList);
        return insertRowsOfOneDeviceStatement.accept(this, context);
    }

    private boolean checkSorted(long[] times) {
        for (int i = 1; i < times.length; ++i) {
            if (times[i] >= times[i - 1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Analysis visitCreateTimeseries(CreateTimeSeriesStatement createTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (createTimeSeriesStatement.getPath().getNodeLength() < 3) {
            throw new SemanticException(new IllegalPathException(createTimeSeriesStatement.getPath().getFullPath()));
        }
        this.analyzeSchemaProps(createTimeSeriesStatement.getProps());
        if (createTimeSeriesStatement.getTags() != null && !createTimeSeriesStatement.getTags().isEmpty() && createTimeSeriesStatement.getAttributes() != null && !createTimeSeriesStatement.getAttributes().isEmpty()) {
            for (String tagKey : createTimeSeriesStatement.getTags().keySet()) {
                if (!createTimeSeriesStatement.getAttributes().containsKey(tagKey)) continue;
                throw new SemanticException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
            }
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createTimeSeriesStatement);
        this.checkIsTemplateCompatible(createTimeSeriesStatement.getPath(), createTimeSeriesStatement.getAlias());
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(createTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    private void checkIsTemplateCompatible(PartialPath timeseriesPath, String alias) {
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetAndPreSetInfo(timeseriesPath, alias);
        if (templateInfo != null) {
            throw new SemanticException((Throwable)((Object)new TemplateIncompatibleException(timeseriesPath.getFullPath(), ((Template)templateInfo.left).getName(), (PartialPath)templateInfo.right)));
        }
    }

    private void checkIsTemplateCompatible(PartialPath devicePath, List<String> measurements, List<String> aliasList) {
        for (int i = 0; i < measurements.size(); ++i) {
            Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetAndPreSetInfo(devicePath.concatNode(measurements.get(i)), aliasList == null ? null : aliasList.get(i));
            if (templateInfo == null) continue;
            throw new SemanticException((Throwable)((Object)new TemplateIncompatibleException(devicePath.getFullPath() + measurements, ((Template)templateInfo.left).getName(), (PartialPath)templateInfo.right)));
        }
    }

    private void analyzeSchemaProps(Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        HashMap<String, String> caseChangeMap = new HashMap<String, String>();
        for (String string : props.keySet()) {
            caseChangeMap.put(string.toLowerCase(Locale.ROOT), string);
        }
        for (Map.Entry entry : caseChangeMap.entrySet()) {
            String lowerCaseKey = (String)entry.getKey();
            if (!IoTDBConstant.ALLOWED_SCHEMA_PROPS.contains(lowerCaseKey)) {
                throw new SemanticException(new MetadataException(String.format("%s is not a legal prop.", entry.getValue())));
            }
            props.put(lowerCaseKey, props.remove(entry.getValue()));
        }
        if (props.containsKey("deadband")) {
            props.put("loss", props.remove("deadband"));
        }
    }

    private void analyzeSchemaProps(List<Map<String, String>> propsList) {
        if (propsList == null) {
            return;
        }
        for (Map<String, String> props : propsList) {
            this.analyzeSchemaProps(props);
        }
    }

    @Override
    public Analysis visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (createAlignedTimeSeriesStatement.getDevicePath().getNodeLength() < 2) {
            throw new SemanticException(new IllegalPathException(createAlignedTimeSeriesStatement.getDevicePath().getFullPath()));
        }
        List<String> measurements = createAlignedTimeSeriesStatement.getMeasurements();
        HashSet<String> measurementsSet = new HashSet<String>(measurements);
        if (measurementsSet.size() < measurements.size()) {
            throw new SemanticException("Measurement under an aligned device is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createAlignedTimeSeriesStatement);
        this.checkIsTemplateCompatible(createAlignedTimeSeriesStatement.getDevicePath(), createAlignedTimeSeriesStatement.getMeasurements(), createAlignedTimeSeriesStatement.getAliasList());
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : createAlignedTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(createAlignedTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement internalCreateTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(internalCreateTimeSeriesStatement);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : internalCreateTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(internalCreateTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(internalCreateMultiTimeSeriesStatement);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (PartialPath devicePath : internalCreateMultiTimeSeriesStatement.getDeviceMap().keySet()) {
            pathPatternTree.appendFullPath(devicePath.concatNode("*"));
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitCreateMultiTimeseries(CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(createMultiTimeSeriesStatement);
        this.analyzeSchemaProps(createMultiTimeSeriesStatement.getPropsList());
        List<PartialPath> timeseriesPathList = createMultiTimeSeriesStatement.getPaths();
        List<String> aliasList = createMultiTimeSeriesStatement.getAliasList();
        for (int i = 0; i < timeseriesPathList.size(); ++i) {
            this.checkIsTemplateCompatible(timeseriesPathList.get(i), aliasList == null ? null : aliasList.get(i));
        }
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath path : createMultiTimeSeriesStatement.getPaths()) {
            patternTree.appendFullPath(path);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitAlterTimeseries(AlterTimeSeriesStatement alterTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(alterTimeSeriesStatement);
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetAndPreSetInfo(alterTimeSeriesStatement.getPath(), alterTimeSeriesStatement.getAlias());
        if (templateInfo != null) {
            throw new RuntimeException((Throwable)((Object)new TemplateIncompatibleException(String.format("Cannot alter template timeseries [%s] since device template [%s] already set on path [%s].", alterTimeSeriesStatement.getPath().getFullPath(), ((Template)templateInfo.left).getName(), templateInfo.right))));
        }
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(alterTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInsertTablet(InsertTabletStatement insertTabletStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        this.validateSchema(analysis, insertTabletStatement, context);
        InsertBaseStatement realStatement = this.removeLogicalView(analysis, insertTabletStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setStatement(realStatement);
        if (realStatement instanceof InsertTabletStatement) {
            InsertTabletStatement realInsertTabletStatement = (InsertTabletStatement)realStatement;
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(realInsertTabletStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(realInsertTabletStatement.getTimePartitionSlots());
            return this.getAnalysisForWriting(analysis, Collections.singletonList(dataPartitionQueryParam), context.getSession().getUserName());
        }
        return this.computeAnalysisForMultiTablets(analysis, (InsertMultiTabletsStatement)realStatement, context.getSession().getUserName());
    }

    @Override
    public Analysis visitInsertRow(InsertRowStatement insertRowStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        this.validateSchema(analysis, insertRowStatement, context);
        InsertBaseStatement realInsertStatement = this.removeLogicalView(analysis, insertRowStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setStatement(realInsertStatement);
        if (realInsertStatement instanceof InsertRowStatement) {
            InsertRowStatement realInsertRowStatement = (InsertRowStatement)realInsertStatement;
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(realInsertRowStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(Collections.singletonList(realInsertRowStatement.getTimePartitionSlot()));
            return this.getAnalysisForWriting(analysis, Collections.singletonList(dataPartitionQueryParam), context.getSession().getUserName());
        }
        return this.computeAnalysisForInsertRows(analysis, (InsertRowsStatement)realInsertStatement, context.getSession().getUserName());
    }

    private Analysis computeAnalysisForInsertRows(Analysis analysis, InsertRowsStatement insertRowsStatement, String userName) {
        HashMap<String, Set> dataPartitionQueryParamMap = new HashMap<String, Set>();
        for (InsertRowStatement insertRowStatement : insertRowsStatement.getInsertRowStatementList()) {
            Set timePartitionSlotSet = dataPartitionQueryParamMap.computeIfAbsent(insertRowStatement.getDevicePath().getFullPath(), k -> new HashSet());
            timePartitionSlotSet.add(insertRowStatement.getTimePartitionSlot());
        }
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (Map.Entry entry : dataPartitionQueryParamMap.entrySet()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath((String)entry.getKey());
            dataPartitionQueryParam.setTimePartitionSlotList(new ArrayList((Collection)entry.getValue()));
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        return this.getAnalysisForWriting(analysis, dataPartitionQueryParams, userName);
    }

    @Override
    public Analysis visitInsertRows(InsertRowsStatement insertRowsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        this.validateSchema(analysis, insertRowsStatement, context);
        InsertRowsStatement realInsertRowsStatement = (InsertRowsStatement)this.removeLogicalView(analysis, insertRowsStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setStatement(realInsertRowsStatement);
        return this.computeAnalysisForInsertRows(analysis, realInsertRowsStatement, context.getSession().getUserName());
    }

    private Analysis computeAnalysisForMultiTablets(Analysis analysis, InsertMultiTabletsStatement insertMultiTabletsStatement, String userName) {
        HashMap<String, Set> dataPartitionQueryParamMap = new HashMap<String, Set>();
        for (InsertTabletStatement insertTabletStatement : insertMultiTabletsStatement.getInsertTabletStatementList()) {
            Set timePartitionSlotSet = dataPartitionQueryParamMap.computeIfAbsent(insertTabletStatement.getDevicePath().getFullPath(), k -> new HashSet());
            timePartitionSlotSet.addAll(insertTabletStatement.getTimePartitionSlots());
        }
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (Map.Entry entry : dataPartitionQueryParamMap.entrySet()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath((String)entry.getKey());
            dataPartitionQueryParam.setTimePartitionSlotList(new ArrayList((Collection)entry.getValue()));
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        return this.getAnalysisForWriting(analysis, dataPartitionQueryParams, userName);
    }

    @Override
    public Analysis visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        this.validateSchema(analysis, insertMultiTabletsStatement, context);
        InsertMultiTabletsStatement realStatement = (InsertMultiTabletsStatement)this.removeLogicalView(analysis, insertMultiTabletsStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setStatement(realStatement);
        return this.computeAnalysisForMultiTablets(analysis, realStatement, context.getSession().getUserName());
    }

    @Override
    public Analysis visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        this.validateSchema(analysis, insertRowsOfOneDeviceStatement, context);
        InsertBaseStatement realInsertStatement = this.removeLogicalView(analysis, insertRowsOfOneDeviceStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setStatement(realInsertStatement);
        if (realInsertStatement instanceof InsertRowsOfOneDeviceStatement) {
            InsertRowsOfOneDeviceStatement realStatement = (InsertRowsOfOneDeviceStatement)realInsertStatement;
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(realStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(realStatement.getTimePartitionSlots());
            return this.getAnalysisForWriting(analysis, Collections.singletonList(dataPartitionQueryParam), context.getSession().getUserName());
        }
        return this.computeAnalysisForInsertRows(analysis, (InsertRowsStatement)realInsertStatement, context.getSession().getUserName());
    }

    @Override
    public Analysis visitPipeEnrichedInsert(PipeEnrichedInsertBaseStatement pipeEnrichedInsertBaseStatement, MPPQueryContext context) {
        Analysis analysis;
        InsertBaseStatement insertBaseStatement = pipeEnrichedInsertBaseStatement.getInsertBaseStatement();
        if (insertBaseStatement instanceof InsertTabletStatement) {
            analysis = this.visitInsertTablet((InsertTabletStatement)insertBaseStatement, context);
        } else if (insertBaseStatement instanceof InsertMultiTabletsStatement) {
            analysis = this.visitInsertMultiTablets((InsertMultiTabletsStatement)insertBaseStatement, context);
        } else if (insertBaseStatement instanceof InsertRowStatement) {
            analysis = this.visitInsertRow((InsertRowStatement)insertBaseStatement, context);
        } else if (insertBaseStatement instanceof InsertRowsStatement) {
            analysis = this.visitInsertRows((InsertRowsStatement)insertBaseStatement, context);
        } else if (insertBaseStatement instanceof InsertRowsOfOneDeviceStatement) {
            analysis = this.visitInsertRowsOfOneDevice((InsertRowsOfOneDeviceStatement)insertBaseStatement, context);
        } else {
            throw new UnsupportedOperationException("Unsupported insert statement type: " + insertBaseStatement.getClass().getName());
        }
        pipeEnrichedInsertBaseStatement.setInsertBaseStatement((InsertBaseStatement)analysis.getStatement());
        analysis.setStatement(pipeEnrichedInsertBaseStatement);
        return analysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSchema(Analysis analysis, InsertBaseStatement insertStatement, MPPQueryContext context) {
        long startTime = System.nanoTime();
        try {
            SchemaValidator.validate(this.schemaFetcher, insertStatement, context);
        }
        catch (SemanticException e) {
            analysis.setFinishQueryAfterAnalyze(true);
            if (e.getCause() instanceof IoTDBException) {
                IoTDBException exception = (IoTDBException)e.getCause();
                analysis.setFailStatus(RpcUtils.getStatus((int)exception.getErrorCode(), (String)exception.getMessage()));
            } else {
                analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage()));
            }
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleSchemaValidateCost(System.nanoTime() - startTime);
        }
        boolean hasFailedMeasurement = insertStatement.hasFailedMeasurements();
        if (hasFailedMeasurement) {
            String partialInsertMessage = String.format("Fail to insert measurements %s caused by %s", insertStatement.getFailedMeasurements(), insertStatement.getFailedMessages());
            logger.warn(partialInsertMessage);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), (String)partialInsertMessage));
        }
    }

    private InsertBaseStatement removeLogicalView(Analysis analysis, InsertBaseStatement insertBaseStatement) {
        try {
            return insertBaseStatement.removeLogicalView();
        }
        catch (SemanticException e) {
            analysis.setFinishQueryAfterAnalyze(true);
            if (e.getCause() instanceof IoTDBException) {
                IoTDBException exception = (IoTDBException)e.getCause();
                analysis.setFailStatus(RpcUtils.getStatus((int)exception.getErrorCode(), (String)exception.getMessage()));
            } else {
                analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage()));
            }
            return insertBaseStatement;
        }
    }

    @Override
    public Analysis visitLoadFile(LoadTsFileStatement loadTsFileStatement, MPPQueryContext context) {
        return new LoadTsfileAnalyzer(loadTsFileStatement, context, this.partitionFetcher, this.schemaFetcher).analyzeFileByFile();
    }

    @Override
    public Analysis visitPipeEnrichedLoadFile(PipeEnrichedLoadTsFileStatement pipeEnrichedLoadTsFileStatement, MPPQueryContext context) {
        Analysis analysis = this.visitLoadFile(pipeEnrichedLoadTsFileStatement.getLoadTsFileStatement(), context);
        analysis.setStatement(pipeEnrichedLoadTsFileStatement);
        return analysis;
    }

    private Analysis getAnalysisForWriting(Analysis analysis, List<DataPartitionQueryParam> dataPartitionQueryParams, String userName) {
        DataPartition dataPartition = this.partitionFetcher.getOrCreateDataPartition(dataPartitionQueryParams, userName);
        if (dataPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.DATABASE_NOT_EXIST.getStatusCode(), (String)"Database not exists and failed to create automatically because enable_auto_create_schema is FALSE."));
        }
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    @Override
    public Analysis visitShowTimeSeries(ShowTimeSeriesStatement showTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(showTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        if (showTimeSeriesStatement.isOrderByHeat()) {
            patternTree.constructTree();
            logger.debug("[StartFetchSchema]");
            ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree, context);
            this.updateSchemaTreeByViews(analysis, schemaTree);
            logger.debug("[EndFetchSchema]]");
            this.analyzeLastSource(analysis, Collections.singletonList(new TimeSeriesOperand(showTimeSeriesStatement.getPathPattern())), schemaTree);
            this.analyzeDataPartition(analysis, new QueryStatement(), schemaTree);
        }
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowStorageGroup(ShowDatabaseStatement showDatabaseStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showDatabaseStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowStorageGroupHeader(showDatabaseStatement.isDetailed()));
        return analysis;
    }

    @Override
    public Analysis visitShowTTL(ShowTTLStatement showTTLStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showTTLStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTTLHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowDevices(ShowDevicesStatement showDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showDevicesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showDevicesStatement.getPathPattern().concatNode("*"));
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(showDevicesStatement.hasSgCol() ? DatasetHeaderFactory.getShowDevicesWithSgHeader() : DatasetHeaderFactory.getShowDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowCluster(ShowClusterStatement showClusterStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showClusterStatement);
        if (showClusterStatement.isDetails()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowClusterDetailsHeader());
        } else {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowClusterHeader());
        }
        return analysis;
    }

    @Override
    public Analysis visitCountStorageGroup(CountDatabaseStatement countDatabaseStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countDatabaseStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountStorageGroupHeader());
        return analysis;
    }

    @Override
    public Analysis visitSchemaFetch(SchemaFetchStatement schemaFetchStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(schemaFetchStatement);
        SchemaPartition schemaPartition = this.partitionFetcher.getSchemaPartition(schemaFetchStatement.getPatternTree());
        analysis.setSchemaPartitionInfo(schemaPartition);
        if (schemaPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        return analysis;
    }

    @Override
    public Analysis visitCountDevices(CountDevicesStatement countDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countDevicesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countDevicesStatement.getPathPattern().concatNode("*"));
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountTimeSeries(CountTimeSeriesStatement countTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(countTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountLevelTimeSeries(CountLevelTimeSeriesStatement countLevelTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countLevelTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countLevelTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(countLevelTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountLevelTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountNodes(CountNodesStatement countStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countStatement.getPathPattern());
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartitionWithLevel(patternTree, countStatement.getAuthorityScope(), countStatement.getLevel());
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountNodesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowChildPaths(ShowChildPathsStatement showChildPathsStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildPathsStatement, showChildPathsStatement.getPartialPath(), showChildPathsStatement.getAuthorityScope(), DatasetHeaderFactory.getShowChildPathsHeader());
    }

    @Override
    public Analysis visitShowChildNodes(ShowChildNodesStatement showChildNodesStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildNodesStatement, showChildNodesStatement.getPartialPath(), showChildNodesStatement.getAuthorityScope(), DatasetHeaderFactory.getShowChildNodesHeader());
    }

    @Override
    public Analysis visitShowVersion(ShowVersionStatement showVersionStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showVersionStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowVersionHeader());
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private Analysis visitSchemaNodeManagementPartition(Statement statement, PartialPath path, PathPatternTree scope, DatasetHeader header) {
        Analysis analysis = new Analysis();
        analysis.setStatement(statement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(path);
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartition(patternTree, scope);
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(header);
        return analysis;
    }

    @Override
    public Analysis visitDeleteData(DeleteDataStatement deleteDataStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(deleteDataStatement);
        PathPatternTree patternTree = new PathPatternTree();
        deleteDataStatement.getPathList().forEach(arg_0 -> ((PathPatternTree)patternTree).appendPathPattern(arg_0));
        ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree, context);
        HashSet<String> deduplicatedDevicePaths = new HashSet<String>();
        if (schemaTree.hasLogicalViewMeasurement()) {
            this.updateSchemaTreeByViews(analysis, schemaTree);
            HashSet<PartialPath> deletePatternSet = new HashSet<PartialPath>(deleteDataStatement.getPathList());
            for (MeasurementPath measurementPath : (List)schemaTree.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left) {
                IMeasurementSchema measurementSchema = measurementPath.getMeasurementSchema();
                if (measurementSchema.isLogicalView()) {
                    LogicalViewSchema logicalViewSchema = (LogicalViewSchema)measurementSchema;
                    if (logicalViewSchema.isWritable()) {
                        PartialPath sourcePathOfAliasSeries = logicalViewSchema.getSourcePathIfWritable();
                        deletePatternSet.add(sourcePathOfAliasSeries);
                        deduplicatedDevicePaths.add(sourcePathOfAliasSeries.getDevice());
                    }
                    deletePatternSet.remove(measurementPath);
                    continue;
                }
                deduplicatedDevicePaths.add(measurementPath.getDevice());
            }
            deleteDataStatement.setPathList(new ArrayList<PartialPath>(deletePatternSet));
        } else {
            for (PartialPath devicePattern : patternTree.getAllDevicePaths()) {
                schemaTree.getMatchedDevices(devicePattern).forEach(deviceSchemaInfo -> deduplicatedDevicePaths.add(deviceSchemaInfo.getDevicePath().getFullPath()));
            }
        }
        analysis.setSchemaTree(schemaTree);
        HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
        deduplicatedDevicePaths.forEach(devicePath -> {
            DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
            queryParam.setDevicePath(devicePath);
            sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedDatabase((String)devicePath), key -> new ArrayList()).add(queryParam);
        });
        DataPartition dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
        analysis.setDataPartitionInfo(dataPartition);
        analysis.setFinishQueryAfterAnalyze(dataPartition.isEmpty());
        return analysis;
    }

    @Override
    public Analysis visitCreateSchemaTemplate(CreateSchemaTemplateStatement createTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        List<String> measurements = createTemplateStatement.getMeasurements();
        HashSet<String> measurementsSet = new HashSet<String>(measurements);
        if (measurementsSet.size() < measurements.size()) {
            throw new SemanticException("Measurement under template is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showNodesInSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowNodesInSchemaTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowSchemaTemplateHeader());
        return analysis;
    }

    private GroupByFilter initGroupByFilter(GroupByTimeComponent groupByTimeComponent) {
        long endTime;
        long startTime = groupByTimeComponent.isLeftCRightO() ? groupByTimeComponent.getStartTime() : groupByTimeComponent.getStartTime() + 1L;
        long l = endTime = groupByTimeComponent.isLeftCRightO() ? groupByTimeComponent.getEndTime() : groupByTimeComponent.getEndTime() + 1L;
        if (groupByTimeComponent.getInterval().containsMonth() || groupByTimeComponent.getSlidingStep().containsMonth()) {
            return new GroupByMonthFilter(groupByTimeComponent.getInterval(), groupByTimeComponent.getSlidingStep(), startTime, endTime, TimeZone.getTimeZone("+00:00"), TimestampPrecisionUtils.currPrecision);
        }
        return new GroupByFilter(groupByTimeComponent.getInterval().nonMonthDuration, groupByTimeComponent.getSlidingStep().nonMonthDuration, startTime, endTime);
    }

    @Override
    public Analysis visitSetSchemaTemplate(SetSchemaTemplateStatement setSchemaTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(setSchemaTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPathSetTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathSetTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(activateTemplateStatement);
        PartialPath activatePath = activateTemplateStatement.getPath();
        Pair<Template, PartialPath> templateSetInfo = this.schemaFetcher.checkTemplateSetInfo(activatePath);
        if (templateSetInfo == null) {
            throw new StatementAnalyzeException((Exception)((Object)new MetadataException(String.format("Path [%s] has not been set any template.", activatePath.getFullPath()))));
        }
        analysis.setTemplateSetInfo((Pair<Template, List<PartialPath>>)new Pair((Object)((Template)templateSetInfo.left), Collections.singletonList((PartialPath)templateSetInfo.right)));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(activatePath.concatNode("*"));
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(partition);
        return analysis;
    }

    @Override
    public Analysis visitBatchActivateTemplate(BatchActivateTemplateStatement batchActivateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(batchActivateTemplateStatement);
        HashMap<PartialPath, Pair<Template, PartialPath>> deviceTemplateSetInfoMap = new HashMap<PartialPath, Pair<Template, PartialPath>>(batchActivateTemplateStatement.getDevicePathList().size());
        for (PartialPath partialPath : batchActivateTemplateStatement.getDevicePathList()) {
            Pair<Template, PartialPath> templateSetInfo = this.schemaFetcher.checkTemplateSetInfo(partialPath);
            if (templateSetInfo == null) {
                throw new StatementAnalyzeException((Exception)((Object)new MetadataException(String.format("Path [%s] has not been set any template.", partialPath.getFullPath()))));
            }
            deviceTemplateSetInfoMap.put(partialPath, templateSetInfo);
        }
        analysis.setDeviceTemplateSetInfoMap(deviceTemplateSetInfoMap);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath devicePath : batchActivateTemplateStatement.getDevicePathList()) {
            patternTree.appendFullPath(devicePath.concatNode("*"));
        }
        SchemaPartition schemaPartition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartition);
        return analysis;
    }

    @Override
    public Analysis visitInternalBatchActivateTemplate(InternalBatchActivateTemplateStatement internalBatchActivateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(internalBatchActivateTemplateStatement);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath activatePath : internalBatchActivateTemplateStatement.getDeviceMap().keySet()) {
            patternTree.appendFullPath(activatePath.concatNode("*"));
        }
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(partition);
        return analysis;
    }

    @Override
    public Analysis visitShowPathsUsingTemplate(ShowPathsUsingTemplateStatement showPathsUsingTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPathsUsingTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathsUsingTemplateHeader());
        Pair<Template, List<PartialPath>> templateSetInfo = this.schemaFetcher.getAllPathsSetTemplate(showPathsUsingTemplateStatement.getTemplateName());
        if (templateSetInfo == null || templateSetInfo.right == null || ((List)templateSetInfo.right).isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        analysis.setTemplateSetInfo(templateSetInfo);
        PathPatternTree patternTree = new PathPatternTree();
        PartialPath rawPathPattern = showPathsUsingTemplateStatement.getPathPattern();
        ArrayList<PartialPath> specifiedPatternList = new ArrayList<PartialPath>();
        ((List)templateSetInfo.right).forEach(setPath -> {
            for (PartialPath specifiedPattern : rawPathPattern.alterPrefixPath(setPath)) {
                patternTree.appendPathPattern(specifiedPattern);
                specifiedPatternList.add(specifiedPattern);
            }
        });
        if (specifiedPatternList.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        analysis.setSpecifiedTemplateRelatedPathPatternList(specifiedPatternList);
        SchemaPartition partition = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(partition);
        if (partition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        return analysis;
    }

    @Override
    public Analysis visitShowQueries(ShowQueriesStatement showQueriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showQueriesStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowQueriesHeader());
        analysis.setVirtualSource(true);
        List<TDataNodeLocation> allRunningDataNodeLocations = this.getRunningDataNodeLocations();
        if (allRunningDataNodeLocations.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        if (allRunningDataNodeLocations.isEmpty()) {
            throw new StatementAnalyzeException("no Running DataNodes");
        }
        analysis.setRunningDataNodeLocations(allRunningDataNodeLocations);
        HashSet<Expression> sourceExpressions = new HashSet<Expression>();
        for (ColumnHeader columnHeader : analysis.getRespDatasetHeader().getColumnHeaders()) {
            sourceExpressions.add(TimeSeriesOperand.constructColumnHeaderExpression(columnHeader.getColumnName(), columnHeader.getColumnType()));
        }
        analysis.setSourceExpressions(sourceExpressions);
        sourceExpressions.forEach(expression -> this.analyzeExpressionType(analysis, (Expression)expression));
        this.analyzeWhere(analysis, showQueriesStatement);
        analysis.setMergeOrderParameter(new OrderByParameter(showQueriesStatement.getSortItemList()));
        return analysis;
    }

    private List<TDataNodeLocation> getRunningDataNodeLocations() {
        ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            TGetDataNodeLocationsResp showDataNodesResp = client.getRunningDataNodeLocations();
            if (showDataNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new StatementAnalyzeException("An error occurred when executing getRunningDataNodeLocations():" + showDataNodesResp.getStatus().getMessage());
            }
            List list = showDataNodesResp.getDataNodeLocationList();
            if (client != null) {
                client.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getRunningDataNodeLocations():" + e.getMessage());
            }
        }
    }

    private void analyzeWhere(Analysis analysis, ShowQueriesStatement showQueriesStatement) {
        WhereCondition whereCondition = showQueriesStatement.getWhereCondition();
        if (whereCondition == null) {
            return;
        }
        Expression whereExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(whereCondition.getPredicate(), ColumnHeaderConstant.showQueriesColumnHeaders);
        TSDataType outputType = this.analyzeExpressionType(analysis, whereExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format(WHERE_WRONG_TYPE_ERROR_MSG, outputType));
        }
        analysis.setWhereExpression(whereExpression);
    }

    private Pair<ISchemaTree, Integer> fetchSchemaOfPathsAndCount(List<PartialPath> pathList, Analysis analysis, MPPQueryContext context) {
        ISchemaTree schemaTree = analysis.getSchemaTree();
        if (schemaTree == null) {
            PathPatternTree pathPatternTree = new PathPatternTree();
            for (PartialPath path : pathList) {
                pathPatternTree.appendPathPattern(path);
            }
            schemaTree = this.schemaFetcher.fetchSchema(pathPatternTree, context);
        }
        int numOfExistPaths = 0;
        for (PartialPath path : pathList) {
            Pair<List<MeasurementPath>, Integer> pathPair = schemaTree.searchMeasurementPaths(path);
            numOfExistPaths += !((List)pathPair.left).isEmpty() ? 1 : 0;
        }
        return new Pair((Object)schemaTree, (Object)numOfExistPaths);
    }

    private Pair<List<PartialPath>, PartialPath> findAllViewsInPaths(List<PartialPath> pathList, ISchemaTree schemaTree) {
        ArrayList<MeasurementPath> result = new ArrayList<MeasurementPath>();
        for (PartialPath path : pathList) {
            Pair<List<MeasurementPath>, Integer> measurementPathList = schemaTree.searchMeasurementPaths(path);
            if (((List)measurementPathList.left).isEmpty()) {
                return new Pair(result, (Object)path);
            }
            for (MeasurementPath measurementPath : (List)measurementPathList.left) {
                if (!measurementPath.getMeasurementSchema().isLogicalView()) continue;
                result.add(measurementPath);
            }
        }
        return new Pair(result, null);
    }

    private Pair<List<Expression>, Analysis> analyzeQueryInLogicalViewStatement(Analysis analysis, QueryStatement queryStatement, MPPQueryContext context) {
        Analysis queryAnalysis = this.visitQuery(queryStatement, context);
        analysis.setSchemaTree(queryAnalysis.getSchemaTree());
        List<Pair<Expression, String>> outputExpressions = queryAnalysis.getOutputExpressions();
        if (queryAnalysis.isFailed()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(queryAnalysis.getFailStatus());
            return new Pair(null, (Object)analysis);
        }
        if (outputExpressions == null) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Columns in the query statement is empty. Please check your SQL."));
            return new Pair(null, (Object)analysis);
        }
        if (queryAnalysis.useLogicalView()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create a view based on existing views. Check the query in your SQL."));
            return new Pair(null, (Object)analysis);
        }
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (Pair<Expression, String> thisPair : outputExpressions) {
            expressionList.add((Expression)thisPair.left);
        }
        return new Pair(expressionList, (Object)analysis);
    }

    private void checkViewsInSource(Analysis analysis, List<Expression> sourceExpressionList, MPPQueryContext context) {
        ArrayList<PartialPath> pathsNeedCheck = new ArrayList<PartialPath>();
        for (Expression expression : sourceExpressionList) {
            if (!(expression instanceof TimeSeriesOperand)) continue;
            pathsNeedCheck.add(((TimeSeriesOperand)expression).getPath());
        }
        Pair<ISchemaTree, Integer> schemaOfNeedToCheck = this.fetchSchemaOfPathsAndCount(pathsNeedCheck, analysis, context);
        if (((Integer)schemaOfNeedToCheck.right).intValue() != pathsNeedCheck.size()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create a view based on non-exist time series."));
            return;
        }
        Pair<List<PartialPath>, PartialPath> viewInSourceCheckResult = this.findAllViewsInPaths(pathsNeedCheck, (ISchemaTree)schemaOfNeedToCheck.left);
        if (viewInSourceCheckResult.right != null) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)("Path " + ((PartialPath)viewInSourceCheckResult.right).toString() + " does not exist! You can not create a view based on non-exist time series.")));
            return;
        }
        if (!((List)viewInSourceCheckResult.left).isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create a view based on existing views."));
        }
    }

    private void checkPathsInCreateLogicalView(Analysis analysis, CreateLogicalViewStatement createLogicalViewStatement) {
        Pair<Boolean, String> checkResult = createLogicalViewStatement.checkAllPaths();
        if (Boolean.FALSE.equals(checkResult.left)) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.ILLEGAL_PATH.getStatusCode(), (String)("The path " + (String)checkResult.right + " is illegal.")));
            return;
        }
        List<PartialPath> targetPathList = createLogicalViewStatement.getTargetPathList();
        HashSet<String> targetStringSet = new HashSet<String>();
        for (PartialPath path : targetPathList) {
            boolean repeatPathNotExist = targetStringSet.add(path.toString());
            if (repeatPathNotExist) continue;
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.ILLEGAL_PATH.getStatusCode(), (String)String.format("Path [%s] is redundant in target paths.", path)));
            return;
        }
        if (createLogicalViewStatement.getSourceExpressionList().size() != targetPathList.size()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)String.format("The number of target paths (%d) and sources (%d) are miss matched! Please check your SQL.", createLogicalViewStatement.getTargetPathList().size(), createLogicalViewStatement.getSourceExpressionList().size())));
            return;
        }
        try {
            for (PartialPath path : createLogicalViewStatement.getTargetPathList()) {
                this.checkIsTemplateCompatible(path, null);
            }
        }
        catch (Exception e) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create view under template."));
        }
    }

    @Override
    public Analysis visitCreateLogicalView(CreateLogicalViewStatement createLogicalViewStatement, MPPQueryContext context) {
        QueryStatement queryStatement;
        Analysis analysis = new Analysis();
        context.setQueryType(QueryType.WRITE);
        analysis.setStatement(createLogicalViewStatement);
        if (createLogicalViewStatement.getViewExpression() == null && (queryStatement = createLogicalViewStatement.getQueryStatement()) != null) {
            Pair<List<Expression>, Analysis> queryAnalysisPair = this.analyzeQueryInLogicalViewStatement(analysis, queryStatement, context);
            if (((Analysis)queryAnalysisPair.right).isFinishQueryAfterAnalyze()) {
                return analysis;
            }
            if (queryAnalysisPair.left != null) {
                try {
                    createLogicalViewStatement.setSourceExpressions((List)queryAnalysisPair.left);
                }
                catch (UnsupportedViewException e) {
                    analysis.setFinishQueryAfterAnalyze(true);
                    analysis.setFailStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                    return analysis;
                }
            }
        }
        createLogicalViewStatement.parseIntoItemIfNecessary();
        this.checkPathsInCreateLogicalView(analysis, createLogicalViewStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        List<Expression> sourceExpressionList = createLogicalViewStatement.getSourceExpressionList();
        this.checkViewsInSource(analysis, sourceExpressionList, context);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath thisFullPath : createLogicalViewStatement.getTargetPathList()) {
            patternTree.appendFullPath(thisFullPath);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitShowLogicalView(ShowLogicalViewStatement showLogicalViewStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        Analysis analysis = new Analysis();
        analysis.setStatement(showLogicalViewStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showLogicalViewStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowLogicalViewHeader());
        return analysis;
    }
}

