/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionTsFileExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionFakeExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionTsFileExtractor;
import org.apache.iotdb.db.pipe.metric.PipeExtractorMetrics;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionExtractor
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionExtractor.class);
    private final AtomicBoolean hasBeenStarted = new AtomicBoolean(false);
    private PipeHistoricalDataRegionExtractor historicalExtractor;
    private PipeRealtimeDataRegionExtractor realtimeExtractor;
    private String taskID;
    private String pipeName;
    private long creationTime;
    private int dataRegionId;

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validateAttributeValueRange("extractor.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("extractor.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, "Should not set both history.enable and realtime.enable to false.", new Object[]{validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true), validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)});
        this.constructHistoricalExtractor();
        this.constructRealtimeExtractor(validator.getParameters());
        this.historicalExtractor.validate(validator);
        this.realtimeExtractor.validate(validator);
    }

    private void constructHistoricalExtractor() {
        this.historicalExtractor = new PipeHistoricalDataRegionTsFileExtractor();
    }

    private void constructRealtimeExtractor(PipeParameters parameters) {
        if (!parameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) {
            this.realtimeExtractor = new PipeRealtimeDataRegionFakeExtractor();
            LOGGER.info("'{}' is set to false, use fake realtime extractor.", (Object)"extractor.realtime.enable");
            return;
        }
        this.realtimeExtractor = new PipeRealtimeDataRegionTsFileExtractor();
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        this.dataRegionId = ((PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment()).getRegionId();
        this.pipeName = configuration.getRuntimeEnvironment().getPipeName();
        this.creationTime = configuration.getRuntimeEnvironment().getCreationTime();
        this.taskID = this.pipeName + "_" + this.dataRegionId + "_" + this.creationTime;
        this.historicalExtractor.customize(parameters, configuration);
        this.realtimeExtractor.customize(parameters, configuration);
        PipeExtractorMetrics.getInstance().register(this);
    }

    public void start() throws Exception {
        if (this.hasBeenStarted.get()) {
            return;
        }
        this.hasBeenStarted.set(true);
        AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
        DataRegionId dataRegionIdObject = new DataRegionId(this.dataRegionId);
        while (true) {
            if (StorageEngine.getInstance().runIfPresent(dataRegionIdObject, dataRegion -> {
                dataRegion.writeLock(String.format("Pipe: starting %s", IoTDBDataRegionExtractor.class.getName()));
                try {
                    this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder);
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }) || StorageEngine.getInstance().runIfAbsent(dataRegionIdObject, () -> this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder))) {
                this.rethrowExceptionIfAny(exceptionHolder);
                return;
            }
            this.rethrowExceptionIfAny(exceptionHolder);
        }
    }

    private void startHistoricalExtractorAndRealtimeExtractor(AtomicReference<Exception> exceptionHolder) {
        try {
            this.realtimeExtractor.start();
            this.historicalExtractor.start();
        }
        catch (Exception e) {
            exceptionHolder.set(e);
            LOGGER.warn(String.format("Start historical extractor %s and realtime extractor %s error.", this.historicalExtractor, this.realtimeExtractor), (Throwable)e);
        }
    }

    private void rethrowExceptionIfAny(AtomicReference<Exception> exceptionHolder) {
        if (exceptionHolder.get() != null) {
            throw new PipeException("failed to start extractors.", (Throwable)exceptionHolder.get());
        }
    }

    public Event supply() throws Exception {
        Event event;
        Event event2 = event = this.historicalExtractor.hasConsumedAll() ? this.realtimeExtractor.supply() : this.historicalExtractor.supply();
        if (Objects.nonNull(event)) {
            if (event instanceof TabletInsertionEvent) {
                PipeExtractorMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                PipeExtractorMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeHeartbeatEvent) {
                PipeExtractorMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
            }
        }
        return event;
    }

    public void close() throws Exception {
        this.historicalExtractor.close();
        this.realtimeExtractor.close();
        PipeExtractorMetrics.getInstance().deregister(this.taskID);
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getDataRegionId() {
        return this.dataRegionId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getHistoricalTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.historicalExtractor.getPendingQueueSize() : 0;
    }

    public int getTabletInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTabletInsertionEventCount() : 0;
    }

    public int getRealtimeTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTsFileInsertionEventCount() : 0;
    }

    public int getPipeHeartbeatEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getPipeHeartbeatEventCount() : 0;
    }
}

