/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.NoPauseDetector;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.simple.SimpleConfig;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.core.type.IoTDBAutoGauge;
import org.apache.iotdb.metrics.core.type.IoTDBCounter;
import org.apache.iotdb.metrics.core.type.IoTDBGauge;
import org.apache.iotdb.metrics.core.type.IoTDBHistogram;
import org.apache.iotdb.metrics.core.type.IoTDBRate;
import org.apache.iotdb.metrics.core.type.IoTDBTimer;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;

public class IoTDBMetricManager
extends AbstractMetricManager {
    private final Clock clock = Clock.SYSTEM;
    private final DistributionStatisticConfig IoTDBDistributionStatisticConfig;

    private IoTDBMetricManager() {
        SimpleConfig config = SimpleConfig.DEFAULT;
        DistributionStatisticConfig defaultHistogramConfig = DistributionStatisticConfig.builder().expiry(config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
        DistributionStatisticConfig distributionStatisticConfig = DistributionStatisticConfig.builder().percentiles(new double[]{0.5, 0.99}).bufferLength(Integer.valueOf(2)).build().merge(defaultHistogramConfig);
        this.IoTDBDistributionStatisticConfig = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(config.step()).build());
    }

    public Counter createCounter() {
        return new IoTDBCounter();
    }

    public <T> AutoGauge createAutoGauge(T obj, ToDoubleFunction<T> mapper) {
        return new IoTDBAutoGauge<T>(obj, mapper);
    }

    public Gauge createGauge() {
        return new IoTDBGauge();
    }

    public Histogram createHistogram(MetricInfo metricInfo) {
        CumulativeDistributionSummary distributionSummary = new CumulativeDistributionSummary(null, this.clock, this.IoTDBDistributionStatisticConfig, 1.0, false);
        return new IoTDBHistogram((DistributionSummary)distributionSummary);
    }

    public Rate createRate() {
        return new IoTDBRate();
    }

    public Timer createTimer() {
        NoPauseDetector pauseDetector = new NoPauseDetector();
        CumulativeTimer timer = new CumulativeTimer(null, this.clock, this.IoTDBDistributionStatisticConfig, (PauseDetector)pauseDetector, TimeUnit.SECONDS, false);
        return new IoTDBTimer((io.micrometer.core.instrument.Timer)timer);
    }

    protected void removeMetric(MetricType type, MetricInfo metricInfo) {
    }

    public boolean stopFramework() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    public static IoTDBMetricManager getInstance() {
        return IoTDBMetricManagerHolder.INSTANCE;
    }

    private static class IoTDBMetricManagerHolder {
        private static final IoTDBMetricManager INSTANCE = new IoTDBMetricManager();

        private IoTDBMetricManagerHolder() {
        }
    }
}

