/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.config;

import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfig {
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfig.class);

    public String getPipeHardlinkBaseDirName() {
        return COMMON_CONFIG.getPipeHardlinkBaseDirName();
    }

    public String getPipeHardlinkTsFileDirName() {
        return COMMON_CONFIG.getPipeHardlinkTsFileDirName();
    }

    public String getPipeHardlinkWALDirName() {
        return COMMON_CONFIG.getPipeHardlinkWALDirName();
    }

    public boolean getPipeHardLinkWALEnabled() {
        return COMMON_CONFIG.getPipeHardLinkWALEnabled();
    }

    public int getPipeDataStructureTabletRowSize() {
        return COMMON_CONFIG.getPipeDataStructureTabletRowSize();
    }

    public int getPipeSubtaskExecutorMaxThreadNum() {
        return COMMON_CONFIG.getPipeSubtaskExecutorMaxThreadNum();
    }

    public int getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() {
        return COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount();
    }

    public long getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() {
        return COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration();
    }

    public long getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs() {
        return COMMON_CONFIG.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    }

    public long getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds() {
        return COMMON_CONFIG.getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds();
    }

    public int getPipeExtractorAssignerDisruptorRingBufferSize() {
        return COMMON_CONFIG.getPipeExtractorAssignerDisruptorRingBufferSize();
    }

    public long getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes() {
        return COMMON_CONFIG.getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes();
    }

    public int getPipeExtractorMatcherCacheSize() {
        return COMMON_CONFIG.getPipeExtractorMatcherCacheSize();
    }

    public long getPipeConnectorTimeoutMs() {
        return COMMON_CONFIG.getPipeConnectorTimeoutMs();
    }

    public int getPipeConnectorReadFileBufferSize() {
        return COMMON_CONFIG.getPipeConnectorReadFileBufferSize();
    }

    public long getPipeConnectorRetryIntervalMs() {
        return COMMON_CONFIG.getPipeConnectorRetryIntervalMs();
    }

    public int getPipeConnectorPendingQueueSize() {
        return COMMON_CONFIG.getPipeConnectorPendingQueueSize();
    }

    public boolean isPipeConnectorRPCThriftCompressionEnabled() {
        return COMMON_CONFIG.isPipeConnectorRPCThriftCompressionEnabled();
    }

    public int getPipeAsyncConnectorSelectorNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorSelectorNumber();
    }

    public int getPipeAsyncConnectorCoreClientNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorCoreClientNumber();
    }

    public int getPipeAsyncConnectorMaxClientNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorMaxClientNumber();
    }

    public boolean isSeperatedPipeHeartbeatEnabled() {
        return COMMON_CONFIG.isSeperatedPipeHeartbeatEnabled();
    }

    public int getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() {
        return COMMON_CONFIG.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta();
    }

    public long getPipeMetaSyncerInitialSyncDelayMinutes() {
        return COMMON_CONFIG.getPipeMetaSyncerInitialSyncDelayMinutes();
    }

    public long getPipeMetaSyncerSyncIntervalMinutes() {
        return COMMON_CONFIG.getPipeMetaSyncerSyncIntervalMinutes();
    }

    public long getPipeMetaSyncerAutoRestartPipeCheckIntervalRound() {
        return COMMON_CONFIG.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound();
    }

    public boolean getPipeAutoRestartEnabled() {
        return COMMON_CONFIG.getPipeAutoRestartEnabled();
    }

    public boolean getPipeAirGapReceiverEnabled() {
        return COMMON_CONFIG.getPipeAirGapReceiverEnabled();
    }

    public int getPipeAirGapReceiverPort() {
        return COMMON_CONFIG.getPipeAirGapReceiverPort();
    }

    public int getPipeMaxAllowedPendingTsFileEpochPerDataRegion() {
        return COMMON_CONFIG.getPipeMaxAllowedPendingTsFileEpochPerDataRegion();
    }

    public int getPipeMaxAllowedPinnedMemTableCount() {
        return COMMON_CONFIG.getPipeMaxAllowedPinnedMemTableCount();
    }

    public boolean getPipeMemoryManagementEnabled() {
        return COMMON_CONFIG.getPipeMemoryManagementEnabled();
    }

    public int getPipeMemoryAllocateMaxRetries() {
        return COMMON_CONFIG.getPipeMemoryAllocateMaxRetries();
    }

    public long getPipeMemoryAllocateRetryIntervalInMs() {
        return COMMON_CONFIG.getPipeMemoryAllocateRetryIntervalInMs();
    }

    public long getPipeMemoryAllocateMinSizeInBytes() {
        return COMMON_CONFIG.getPipeMemoryAllocateMinSizeInBytes();
    }

    public long getPipeMemoryAllocateForTsFileSequenceReaderInBytes() {
        return COMMON_CONFIG.getPipeMemoryAllocateForTsFileSequenceReaderInBytes();
    }

    public long getPipeMemoryExpanderIntervalSeconds() {
        return COMMON_CONFIG.getPipeMemoryExpanderIntervalSeconds();
    }

    public void printAllConfigs() {
        LOGGER.info("PipeHardlinkBaseDirName: {}", (Object)this.getPipeHardlinkBaseDirName());
        LOGGER.info("PipeHardlinkTsFileDirName: {}", (Object)this.getPipeHardlinkTsFileDirName());
        LOGGER.info("PipeHardlinkWALDirName: {}", (Object)this.getPipeHardlinkWALDirName());
        LOGGER.info("PipeHardLinkWALEnabled: {}", (Object)this.getPipeHardLinkWALEnabled());
        LOGGER.info("PipeDataStructureTabletRowSize: {}", (Object)this.getPipeDataStructureTabletRowSize());
        LOGGER.info("PipeSubtaskExecutorMaxThreadNum: {}", (Object)this.getPipeSubtaskExecutorMaxThreadNum());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration());
        LOGGER.info("PipeSubtaskExecutorPendingQueueMaxBlockingTimeMs: {}", (Object)this.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs());
        LOGGER.info("PipeSubtaskExecutorCronHeartbeatEventIntervalSeconds: {}", (Object)this.getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds());
        LOGGER.info("PipeExtractorAssignerDisruptorRingBufferSize: {}", (Object)this.getPipeExtractorAssignerDisruptorRingBufferSize());
        LOGGER.info("PipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes: {}", (Object)this.getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes());
        LOGGER.info("PipeExtractorMatcherCacheSize: {}", (Object)this.getPipeExtractorMatcherCacheSize());
        LOGGER.info("PipeConnectorTimeoutMs: {}", (Object)this.getPipeConnectorTimeoutMs());
        LOGGER.info("PipeConnectorReadFileBufferSize: {}", (Object)this.getPipeConnectorReadFileBufferSize());
        LOGGER.info("PipeConnectorRetryIntervalMs: {}", (Object)this.getPipeConnectorRetryIntervalMs());
        LOGGER.info("PipeConnectorPendingQueueSize: {}", (Object)this.getPipeConnectorPendingQueueSize());
        LOGGER.info("PipeConnectorRPCThriftCompressionEnabled: {}", (Object)this.isPipeConnectorRPCThriftCompressionEnabled());
        LOGGER.info("PipeAsyncConnectorSelectorNumber: {}", (Object)this.getPipeAsyncConnectorSelectorNumber());
        LOGGER.info("PipeAsyncConnectorCoreClientNumber: {}", (Object)this.getPipeAsyncConnectorCoreClientNumber());
        LOGGER.info("PipeAsyncConnectorMaxClientNumber: {}", (Object)this.getPipeAsyncConnectorMaxClientNumber());
        LOGGER.info("SeperatedPipeHeartbeatEnabled: {}", (Object)this.isSeperatedPipeHeartbeatEnabled());
        LOGGER.info("PipeHeartbeatIntervalSecondsForCollectingPipeMeta: {}", (Object)this.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta());
        LOGGER.info("PipeMetaSyncerInitialSyncDelayMinutes: {}", (Object)this.getPipeMetaSyncerInitialSyncDelayMinutes());
        LOGGER.info("PipeMetaSyncerSyncIntervalMinutes: {}", (Object)this.getPipeMetaSyncerSyncIntervalMinutes());
        LOGGER.info("PipeMetaSyncerAutoRestartPipeCheckIntervalRound: {}", (Object)this.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound());
        LOGGER.info("PipeAutoRestartEnabled: {}", (Object)this.getPipeAutoRestartEnabled());
        LOGGER.info("PipeAirGapReceiverEnabled: {}", (Object)this.getPipeAirGapReceiverEnabled());
        LOGGER.info("PipeAirGapReceiverPort: {}", (Object)this.getPipeAirGapReceiverPort());
        LOGGER.info("PipeMaxAllowedPendingTsFileEpochPerDataRegion: {}", (Object)this.getPipeMaxAllowedPendingTsFileEpochPerDataRegion());
        LOGGER.info("PipeMaxAllowedPinnedMemTableCount: {}", (Object)this.getPipeMaxAllowedPinnedMemTableCount());
        LOGGER.info("PipeMemoryManagementEnabled: {}", (Object)this.getPipeMemoryManagementEnabled());
        LOGGER.info("PipeMemoryAllocateMaxRetries: {}", (Object)this.getPipeMemoryAllocateMaxRetries());
        LOGGER.info("PipeMemoryAllocateRetryIntervalInMs: {}", (Object)this.getPipeMemoryAllocateRetryIntervalInMs());
        LOGGER.info("PipeMemoryAllocateMinSizeInBytes: {}", (Object)this.getPipeMemoryAllocateMinSizeInBytes());
        LOGGER.info("PipeMemoryAllocateForTsFileSequenceReaderInBytes: {}", (Object)this.getPipeMemoryAllocateForTsFileSequenceReaderInBytes());
    }

    private PipeConfig() {
    }

    public static PipeConfig getInstance() {
        return PipeConfigHolder.INSTANCE;
    }

    private static class PipeConfigHolder {
        private static final PipeConfig INSTANCE = new PipeConfig();

        private PipeConfigHolder() {
        }
    }
}

