/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.iotdb.tsfile.encoding.bitpacking.IntPacker;
import org.apache.iotdb.tsfile.encoding.encoder.IntRleEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.SprintzEncoder;
import org.apache.iotdb.tsfile.encoding.fire.IntFire;
import org.apache.iotdb.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class IntSprintzEncoder
extends SprintzEncoder {
    IntPacker packer;
    IntFire firePred;
    protected Vector<Integer> values = new Vector();

    public IntSprintzEncoder() {
        this.firePred = new IntFire(2);
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    public int getOneItemMaxSize() {
        return 1 + (1 + this.Block_size) * 4;
    }

    @Override
    public long getMaxByteSize() {
        return 1L + (long)(this.values.size() + 1) * 4L;
    }

    protected Integer predict(Integer value, Integer preVlaue) throws TsFileEncodingException {
        Integer pred;
        if (this.predictMethod.equals("delta")) {
            pred = this.delta(value, preVlaue);
        } else if (this.predictMethod.equals("fire")) {
            pred = this.fire(value, preVlaue);
        } else {
            throw new TsFileEncodingException("Config: Predict Method {} of SprintzEncoder is not supported.");
        }
        pred = pred <= 0 ? Integer.valueOf(-2 * pred) : Integer.valueOf(2 * pred - 1);
        return pred;
    }

    @Override
    protected void bitPack() throws IOException {
        int preValue = this.values.get(0);
        this.values.remove(0);
        this.bitWidth = ReadWriteForEncodingUtils.getIntMaxBitWidth(this.values);
        this.packer = new IntPacker(this.bitWidth);
        byte[] bytes = new byte[this.bitWidth];
        int[] tmpBuffer = new int[this.Block_size];
        for (int i = 0; i < this.Block_size; ++i) {
            tmpBuffer[i] = this.values.get(i);
        }
        this.packer.pack8Values(tmpBuffer, 0, bytes);
        ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(this.bitWidth, this.byteCache, 1);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(preValue, this.byteCache);
        this.byteCache.write(bytes, 0, bytes.length);
    }

    protected Integer delta(Integer value, Integer preValue) {
        return value - preValue;
    }

    protected Integer fire(Integer value, Integer preValue) {
        int pred = this.firePred.predict(preValue);
        int err = value - pred;
        this.firePred.train(preValue, value, err);
        return err;
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        if (this.byteCache.size() > 0) {
            this.byteCache.writeTo(out);
        }
        if (!this.values.isEmpty()) {
            int size = this.values.size();
            ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(size |= 0x80, out, 1);
            IntRleEncoder encoder = new IntRleEncoder();
            for (int val : this.values) {
                encoder.encode(val, out);
            }
            encoder.flush(out);
        }
        this.reset();
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        if (!this.isFirstCached) {
            this.values.add(value);
            this.isFirstCached = true;
            return;
        }
        this.values.add(value);
        if (this.values.size() == this.Block_size + 1) {
            try {
                int pre = this.values.get(0);
                this.firePred.reset();
                for (int i = 1; i <= this.Block_size; ++i) {
                    int tmp = this.values.get(i);
                    this.values.set(i, this.predict(this.values.get(i), pre));
                    pre = tmp;
                }
                this.bitPack();
                this.isFirstCached = false;
                this.values.clear();
                ++this.groupNum;
                if (this.groupNum == this.groupMax) {
                    this.flush(out);
                }
            }
            catch (IOException e) {
                logger.error("Error occured when encoding INT32 Type value with with Sprintz", (Throwable)e);
            }
        }
    }
}

