/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFMatches
implements UDTF {
    private Pattern pattern;

    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateRequiredAttribute("regex").validateInputSeriesDataType(0, Type.TEXT);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.pattern = Pattern.compile(parameters.getString("regex"));
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putBoolean(row.getTime(), this.pattern.matcher(row.getString(0)).matches());
    }

    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        return this.pattern.matcher(row.getString(0)).matches();
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            String str = inputs[i].getStringValue(TSFileConfig.STRING_CHARSET);
            builder.writeBoolean(this.pattern.matcher(str).matches());
        }
    }
}

