/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.apache.iotdb.jdbc.StringUtils;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBPreparedStatement
extends IoTDBStatement
implements PreparedStatement {
    private String sql;
    private static final String METHOD_NOT_SUPPORTED_STRING = "Method not supported";
    private static final Logger logger = LoggerFactory.getLogger(IoTDBPreparedStatement.class);
    private final Map<Integer, String> parameters = new HashMap<Integer, String>();

    IoTDBPreparedStatement(IoTDBConnection connection, IClientRPCService.Iface client, Long sessionId, String sql, ZoneId zoneId) throws SQLException {
        super(connection, client, sessionId, zoneId);
        this.sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.createCompleteSql(this.sql, this.parameters));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.createCompleteSql(this.sql, this.parameters));
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.createCompleteSql(this.sql, this.parameters));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return new ParameterMetaData(){

            @Override
            public int getParameterCount() {
                return IoTDBPreparedStatement.this.parameters.size();
            }

            @Override
            public int isNullable(int param) {
                return 2;
            }

            @Override
            public boolean isSigned(int param) {
                try {
                    return Integer.parseInt((String)IoTDBPreparedStatement.this.parameters.get(param)) < 0;
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public int getPrecision(int param) {
                return ((String)IoTDBPreparedStatement.this.parameters.get(param)).length();
            }

            @Override
            public int getScale(int param) {
                try {
                    double d = Double.parseDouble((String)IoTDBPreparedStatement.this.parameters.get(param));
                    if (d >= 1.0) {
                        d -= (double)((long)d);
                    }
                    if (d == 0.0) {
                        return 0;
                    }
                    d *= 10.0;
                    int count = 1;
                    while (d - (double)((long)d) != 0.0) {
                        d *= 10.0;
                        ++count;
                    }
                    return count;
                }
                catch (Exception e) {
                    return 0;
                }
            }

            @Override
            public int getParameterType(int param) {
                return 0;
            }

            @Override
            public String getParameterTypeName(int param) {
                return null;
            }

            @Override
            public String getParameterClassName(int param) {
                return null;
            }

            @Override
            public int getParameterMode(int param) {
                return 0;
            }

            @Override
            public <T> T unwrap(Class<T> iface) {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) {
                return false;
            }
        };
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
        this.parameters.put(parameterIndex, Boolean.toString(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Binary binary = new Binary(x);
        this.parameters.put(parameterIndex, binary.getStringValue(TSFileConfig.STRING_CHARSET));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
        this.parameters.put(parameterIndex, Double.toString(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) {
        this.parameters.put(parameterIndex, Float.toString(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) {
        this.parameters.put(parameterIndex, Integer.toString(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) {
        this.parameters.put(parameterIndex, Long.toString(x));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLException("The parameter cannot be null");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLException("The parameter cannot be null");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else {
            throw new SQLException(String.format("Can''t infer the SQL type to use for an instance of %s. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()));
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (!(x instanceof BigDecimal)) {
            this.setObject(parameterIndex, x, targetSqlType, 0);
        } else {
            this.setObject(parameterIndex, x, targetSqlType, ((BigDecimal)x).scale());
        }
    }

    @Override
    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        if (parameterObj == null) {
            this.setNull(parameterIndex, 1111);
        } else {
            try {
                block1 : switch (targetSqlType) {
                    case 16: {
                        if (parameterObj instanceof Boolean) {
                            this.setBoolean(parameterIndex, (Boolean)parameterObj);
                            break;
                        }
                        if (parameterObj instanceof String) {
                            if ("true".equalsIgnoreCase((String)parameterObj) || "Y".equalsIgnoreCase((String)parameterObj)) {
                                this.setBoolean(parameterIndex, true);
                                break;
                            }
                            if ("false".equalsIgnoreCase((String)parameterObj) || "N".equalsIgnoreCase((String)parameterObj)) {
                                this.setBoolean(parameterIndex, false);
                                break;
                            }
                            if (((String)parameterObj).matches("-?\\d+\\.?\\d*")) {
                                this.setBoolean(parameterIndex, !((String)parameterObj).matches("-?[0]+[.]*[0]*"));
                                break;
                            }
                            throw new SQLException("No conversion from " + parameterObj + " to Types.BOOLEAN possible.");
                        }
                        if (parameterObj instanceof Number) {
                            int intValue = ((Number)parameterObj).intValue();
                            this.setBoolean(parameterIndex, intValue != 0);
                            break;
                        }
                        throw new SQLException("No conversion from " + parameterObj + " to Types.BOOLEAN possible.");
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.setNumericObject(parameterIndex, parameterObj, targetSqlType, scale);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        if (parameterObj instanceof BigDecimal) {
                            this.setString(parameterIndex, StringUtils.fixDecimalExponent(StringUtils.consistentToString((BigDecimal)parameterObj)));
                            break;
                        }
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case 2005: {
                        if (parameterObj instanceof Clob) {
                            this.setClob(parameterIndex, (Clob)parameterObj);
                            break;
                        }
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
                    }
                    case 91: 
                    case 93: {
                        java.util.Date parameterAsDate;
                        if (parameterObj instanceof String) {
                            ParsePosition pp = new ParsePosition(0);
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, false), Locale.US);
                            parameterAsDate = ((DateFormat)sdf).parse((String)parameterObj, pp);
                        } else {
                            parameterAsDate = (Date)parameterObj;
                        }
                        switch (targetSqlType) {
                            case 91: {
                                if (parameterAsDate instanceof Date) {
                                    this.setDate(parameterIndex, (Date)parameterAsDate);
                                    break block1;
                                }
                                this.setDate(parameterIndex, new Date(parameterAsDate.getTime()));
                                break block1;
                            }
                            case 93: {
                                if (parameterAsDate instanceof Timestamp) {
                                    this.setTimestamp(parameterIndex, (Timestamp)parameterAsDate);
                                    break block1;
                                }
                                this.setTimestamp(parameterIndex, new Timestamp(parameterAsDate.getTime()));
                                break block1;
                            }
                        }
                        logger.error("No type was matched");
                        break;
                    }
                    case 92: {
                        if (parameterObj instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, true), Locale.US);
                            this.setTime(parameterIndex, new Time(sdf.parse((String)parameterObj).getTime()));
                            break;
                        }
                        if (parameterObj instanceof Timestamp) {
                            Timestamp xT = (Timestamp)parameterObj;
                            this.setTime(parameterIndex, new Time(xT.getTime()));
                            break;
                        }
                        this.setTime(parameterIndex, (Time)parameterObj);
                        break;
                    }
                    case 1111: {
                        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
                    }
                    default: {
                        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
                    }
                }
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
            }
        }
    }

    private final String getDateTimePattern(String dt, boolean toTime) throws Exception {
        int i;
        int size;
        char c;
        int n;
        Object[] v;
        int z;
        int dtLength;
        int n2 = dtLength = dt != null ? dt.length() : 0;
        if (dtLength >= 8 && dtLength <= 10) {
            int dashCount = 0;
            boolean isDateOnly = true;
            for (int i2 = 0; i2 < dtLength; ++i2) {
                char c2 = dt.charAt(i2);
                if (!Character.isDigit(c2) && c2 != '-') {
                    isDateOnly = false;
                    break;
                }
                if (c2 != '-') continue;
                ++dashCount;
            }
            if (isDateOnly && dashCount == 2) {
                return "yyyy-MM-dd";
            }
        }
        boolean colonsOnly = true;
        for (int i3 = 0; i3 < dtLength; ++i3) {
            char c3 = dt.charAt(i3);
            if (Character.isDigit(c3) || c3 == ':') continue;
            colonsOnly = false;
            break;
        }
        if (colonsOnly) {
            return "HH:mm:ss";
        }
        StringReader reader = new StringReader(dt + " ");
        ArrayList<Object[]> vec = new ArrayList<Object[]>();
        ArrayList<Object[]> vecRemovelist = new ArrayList<Object[]>();
        Object[] nv = new Object[]{Character.valueOf('y'), new StringBuilder(), 0};
        vec.add(nv);
        if (toTime) {
            nv = new Object[]{Character.valueOf('h'), new StringBuilder(), 0};
            vec.add(nv);
        }
        while ((z = reader.read()) != -1) {
            char separator = (char)z;
            int maxvecs = vec.size();
            for (int count = 0; count < maxvecs; ++count) {
                v = (Object[])vec.get(count);
                n = (Integer)v[2];
                c = this.getSuccessor(((Character)v[0]).charValue(), n);
                if (!Character.isLetterOrDigit(separator)) {
                    if (c == ((Character)v[0]).charValue() && c != 'S') {
                        vecRemovelist.add(v);
                        continue;
                    }
                    ((StringBuilder)v[1]).append(separator);
                    if (c != 'X' && c != 89) continue;
                    v[2] = 4;
                    continue;
                }
                if (c == 'X') {
                    c = 'y';
                    nv = new Object[3];
                    nv[1] = new StringBuilder(((StringBuilder)v[1]).toString()).append('M');
                    nv[0] = Character.valueOf('M');
                    nv[2] = 1;
                    vec.add(nv);
                } else if (c == 'Y') {
                    c = 'M';
                    nv = new Object[3];
                    nv[1] = new StringBuilder(((StringBuilder)v[1]).toString()).append('d');
                    nv[0] = Character.valueOf('d');
                    nv[2] = 1;
                    vec.add(nv);
                }
                ((StringBuilder)v[1]).append(c);
                if (c == ((Character)v[0]).charValue()) {
                    v[2] = n + 1;
                    continue;
                }
                v[0] = Character.valueOf(c);
                v[2] = 1;
            }
            size = vecRemovelist.size();
            for (i = 0; i < size; ++i) {
                v = (Object[])vecRemovelist.get(i);
                vec.remove(v);
            }
            vecRemovelist.clear();
        }
        size = vec.size();
        for (i = 0; i < size; ++i) {
            boolean containsEnd;
            v = (Object[])vec.get(i);
            c = ((Character)v[0]).charValue();
            boolean bk = this.getSuccessor(c, n = ((Integer)v[2]).intValue()) != c;
            boolean atEnd = (c == 's' || c == 'm' || c == 'h' && toTime) && bk;
            boolean finishesAtDate = bk && c == 'd' && !toTime;
            boolean bl = containsEnd = ((StringBuilder)v[1]).toString().indexOf(87) != -1;
            if ((atEnd || finishesAtDate) && !containsEnd) continue;
            vecRemovelist.add(v);
        }
        size = vecRemovelist.size();
        for (i = 0; i < size; ++i) {
            vec.remove(vecRemovelist.get(i));
        }
        vecRemovelist.clear();
        v = (Object[])vec.get(0);
        StringBuilder format = (StringBuilder)v[1];
        format.setLength(format.length() - 1);
        return format.toString();
    }

    private final char getSuccessor(char c, int n) {
        return (char)(c == 'y' && n == 2 ? 88 : (c == 'y' && n < 4 ? 121 : (c == 'y' ? 77 : (c == 'M' && n == 2 ? 89 : (c == 'M' && n < 3 ? 77 : (c == 'M' ? 100 : (c == 'd' && n < 2 ? 100 : (c == 'd' ? 72 : (c == 'H' && n < 2 ? 72 : (c == 'H' ? 109 : (c == 'm' && n < 2 ? 109 : (c == 'm' ? 115 : (c == 's' && n < 2 ? 115 : 87)))))))))))));
    }

    private void setNumericObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        Number parameterAsNum;
        if (parameterObj instanceof Boolean) {
            parameterAsNum = (Boolean)parameterObj != false ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (parameterObj instanceof String) {
            switch (targetSqlType) {
                case -7: {
                    if ("1".equals(parameterObj) || "0".equals(parameterObj)) {
                        parameterAsNum = Integer.valueOf((String)parameterObj);
                        break;
                    }
                    boolean parameterAsBoolean = "true".equalsIgnoreCase((String)parameterObj);
                    parameterAsNum = parameterAsBoolean ? Integer.valueOf(1) : Integer.valueOf(0);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    parameterAsNum = Integer.valueOf((String)parameterObj);
                    break;
                }
                case -5: {
                    parameterAsNum = Long.valueOf((String)parameterObj);
                    break;
                }
                case 7: {
                    parameterAsNum = Float.valueOf((String)parameterObj);
                    break;
                }
                case 6: 
                case 8: {
                    parameterAsNum = Double.valueOf((String)parameterObj);
                    break;
                }
                default: {
                    parameterAsNum = new BigDecimal((String)parameterObj);
                    break;
                }
            }
        } else {
            parameterAsNum = (Number)parameterObj;
        }
        switch (targetSqlType) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                this.setInt(parameterIndex, parameterAsNum.intValue());
                break;
            }
            case -5: {
                this.setLong(parameterIndex, parameterAsNum.longValue());
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, parameterAsNum.floatValue());
                break;
            }
            case 6: {
                this.setFloat(parameterIndex, parameterAsNum.floatValue());
                break;
            }
            case 8: {
                this.setDouble(parameterIndex, parameterAsNum.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                if (parameterAsNum instanceof BigDecimal) {
                    BigDecimal scaledBigDecimal = null;
                    try {
                        scaledBigDecimal = ((BigDecimal)parameterAsNum).setScale(scale);
                    }
                    catch (ArithmeticException ex) {
                        try {
                            scaledBigDecimal = ((BigDecimal)parameterAsNum).setScale(scale, 4);
                        }
                        catch (ArithmeticException arEx) {
                            throw new SQLException("Can't set scale of '" + scale + "' for DECIMAL argument '" + parameterAsNum + "'");
                        }
                    }
                    this.setBigDecimal(parameterIndex, scaledBigDecimal);
                    break;
                }
                if (parameterAsNum instanceof BigInteger) {
                    this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)parameterAsNum, scale));
                    break;
                }
                this.setBigDecimal(parameterIndex, BigDecimal.valueOf(parameterAsNum.doubleValue()));
                break;
            }
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setString(int parameterIndex, String x) {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            long time = x.getTime();
            String timeprecision = this.client.getProperties().getTimestampPrecision();
            switch (timeprecision.toLowerCase()) {
                case "ms": {
                    break;
                }
                case "us": {
                    time *= 1000L;
                    break;
                }
                case "ns": {
                    time *= 1000000L;
                    break;
                }
            }
            this.setLong(parameterIndex, time);
        }
        catch (TException e) {
            logger.error(String.format("set time error when iotdb prepared statement :%s ", e.getMessage()));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            ZonedDateTime zonedDateTime = null;
            long time = x.getTime();
            String timeprecision = this.client.getProperties().getTimestampPrecision();
            switch (timeprecision.toLowerCase()) {
                case "ms": {
                    break;
                }
                case "us": {
                    time *= 1000L;
                    break;
                }
                case "ns": {
                    time *= 1000000L;
                    break;
                }
            }
            zonedDateTime = cal != null ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.of(cal.getTimeZone().getID())) : ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), this.zoneId);
            this.parameters.put(parameterIndex, zonedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
        catch (TException e) {
            logger.error(String.format("set time error when iotdb prepared statement :%s ", e.getMessage()));
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(x.getTime()), this.zoneId);
        this.parameters.put(parameterIndex, zonedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        ZonedDateTime zonedDateTime = null;
        zonedDateTime = cal != null ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(x.getTime()), ZoneId.of(cal.getTimeZone().getID())) : ZonedDateTime.ofInstant(Instant.ofEpochMilli(x.getTime()), this.zoneId);
        this.parameters.put(parameterIndex, zonedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Parameter only supports BOOLEAN,INT32,INT64,FLOAT,DOUBLE,TEXT data type");
    }

    private String createCompleteSql(String sql, Map<Integer, String> parameters) throws SQLException {
        List<String> parts = this.splitSqlStatement(sql);
        StringBuilder newSql = new StringBuilder(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("SQL {}", (Object)sql);
                logger.debug("parameters {}", (Object)parameters.size());
            }
            if (!parameters.containsKey(i)) {
                throw new SQLException("Parameter #" + i + " is unset");
            }
            newSql.append(parameters.get(i));
            newSql.append(parts.get(i));
        }
        return newSql.toString();
    }

    private List<String> splitSqlStatement(String sql) {
        ArrayList<String> parts = new ArrayList<String>();
        int apCount = 0;
        int off = 0;
        boolean skip = false;
        block5: for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (skip) {
                skip = false;
                continue;
            }
            switch (c) {
                case '\'': {
                    ++apCount;
                    continue block5;
                }
                case '\\': {
                    skip = true;
                    continue block5;
                }
                case '?': {
                    if ((apCount & 1) != 0) continue block5;
                    parts.add(sql.substring(off, i));
                    off = i + 1;
                    continue block5;
                }
            }
        }
        parts.add(sql.substring(off));
        return parts;
    }
}

