/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupModifyPeerException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.IllegalPeerEndpointException;
import org.apache.iotdb.consensus.exception.IllegalPeerNumException;
import org.apache.iotdb.consensus.exception.PeerAlreadyInConsensusGroupException;
import org.apache.iotdb.consensus.exception.PeerNotInConsensusGroupException;
import org.apache.iotdb.consensus.iot.IoTConsensusServerImpl;
import org.apache.iotdb.consensus.iot.client.AsyncIoTConsensusServiceClient;
import org.apache.iotdb.consensus.iot.client.IoTConsensusClientPool;
import org.apache.iotdb.consensus.iot.client.SyncIoTConsensusServiceClient;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManager;
import org.apache.iotdb.consensus.iot.service.IoTConsensusRPCService;
import org.apache.iotdb.consensus.iot.service.IoTConsensusRPCServiceProcessor;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensus
implements IConsensus {
    private final Logger logger = LoggerFactory.getLogger(IoTConsensus.class);
    private final TEndPoint thisNode;
    private final int thisNodeId;
    private final File storageDir;
    private final IStateMachine.Registry registry;
    private final Map<ConsensusGroupId, IoTConsensusServerImpl> stateMachineMap = new ConcurrentHashMap<ConsensusGroupId, IoTConsensusServerImpl>();
    private final IoTConsensusRPCService service;
    private final RegisterManager registerManager = new RegisterManager();
    private final IoTConsensusConfig config;
    private final IClientManager<TEndPoint, AsyncIoTConsensusServiceClient> clientManager;
    private final IClientManager<TEndPoint, SyncIoTConsensusServiceClient> syncClientManager;
    private final ScheduledExecutorService retryService;

    public IoTConsensus(ConsensusConfig config, IStateMachine.Registry registry) {
        this.thisNode = config.getThisNodeEndPoint();
        this.thisNodeId = config.getThisNodeId();
        this.storageDir = new File(config.getStorageDir());
        this.config = config.getIotConsensusConfig();
        this.registry = registry;
        this.service = new IoTConsensusRPCService(this.thisNode, config.getIotConsensusConfig());
        this.clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new IoTConsensusClientPool.AsyncIoTConsensusServiceClientPoolFactory(config.getIotConsensusConfig()));
        this.syncClientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new IoTConsensusClientPool.SyncIoTConsensusServiceClientPoolFactory(config.getIotConsensusConfig()));
        this.retryService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.LOG_DISPATCHER_RETRY_EXECUTOR.getName());
        IoTConsensusMemoryManager.getInstance().init(config.getIotConsensusConfig().getReplication().getAllocateMemoryForConsensus(), config.getIotConsensusConfig().getReplication().getAllocateMemoryForQueue());
    }

    @Override
    public synchronized void start() throws IOException {
        this.initAndRecover();
        this.service.initAsyncedServiceImpl(new IoTConsensusRPCServiceProcessor(this));
        try {
            this.registerManager.register((IService)this.service);
        }
        catch (StartupException e) {
            throw new IOException(e);
        }
    }

    private void initAndRecover() throws IOException {
        if (!this.storageDir.exists()) {
            if (!this.storageDir.mkdirs()) {
                throw new IOException(String.format("Unable to create consensus dir at %s", this.storageDir));
            }
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storageDir.toPath());){
                for (Path path : stream) {
                    String[] items = path.getFileName().toString().split("_");
                    ConsensusGroupId consensusGroupId = ConsensusGroupId.Factory.create((int)Integer.parseInt(items[0]), (int)Integer.parseInt(items[1]));
                    IoTConsensusServerImpl consensus = new IoTConsensusServerImpl(path.toString(), new Peer(consensusGroupId, this.thisNodeId, this.thisNode), new ArrayList<Peer>(), (IStateMachine)this.registry.apply(consensusGroupId), this.retryService, this.clientManager, this.syncClientManager, this.config);
                    this.stateMachineMap.put(consensusGroupId, consensus);
                    consensus.start();
                }
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.stateMachineMap.values().parallelStream().forEach(IoTConsensusServerImpl::stop);
        this.clientManager.close();
        this.syncClientManager.close();
        this.registerManager.deregisterAll();
        this.retryService.shutdown();
        try {
            this.retryService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("{}: interrupted when shutting down add Executor with exception {}", (Object)this, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public TSStatus write(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        IoTConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (impl.isReadOnly()) {
            return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY);
        }
        if (!impl.isActive()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT, (String)"peer is inactive and not ready to receive sync log request.");
        }
        return impl.write(request);
    }

    @Override
    public DataSet read(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        return Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId)).read(request);
    }

    @Override
    public void createLocalPeer(ConsensusGroupId groupId, List<Peer> peers) throws ConsensusException {
        int consensusGroupSize = peers.size();
        if (consensusGroupSize == 0) {
            throw new IllegalPeerNumException(consensusGroupSize);
        }
        if (!peers.contains(new Peer(groupId, this.thisNodeId, this.thisNode))) {
            throw new IllegalPeerEndpointException(this.thisNode, peers);
        }
        AtomicBoolean exist = new AtomicBoolean(true);
        Optional.ofNullable(this.stateMachineMap.computeIfAbsent(groupId, k -> {
            exist.set(false);
            String path = IoTConsensus.buildPeerDir(this.storageDir, groupId);
            File file = new File(path);
            if (!file.mkdirs()) {
                this.logger.warn("Unable to create consensus dir for group {} at {}", (Object)groupId, (Object)path);
                return null;
            }
            IoTConsensusServerImpl impl = new IoTConsensusServerImpl(path, new Peer(groupId, this.thisNodeId, this.thisNode), peers, (IStateMachine)this.registry.apply(groupId), this.retryService, this.clientManager, this.syncClientManager, this.config);
            impl.start();
            return impl;
        })).orElseThrow(() -> new ConsensusException(String.format("Unable to create consensus dir for group %s", groupId)));
        if (exist.get()) {
            throw new ConsensusGroupAlreadyExistException(groupId);
        }
    }

    @Override
    public void deleteLocalPeer(ConsensusGroupId groupId) throws ConsensusException {
        AtomicBoolean exist = new AtomicBoolean(false);
        this.stateMachineMap.computeIfPresent(groupId, (k, v) -> {
            exist.set(true);
            v.stop();
            FileUtils.deleteDirectory((File)new File(IoTConsensus.buildPeerDir(this.storageDir, groupId)));
            return null;
        });
        if (!exist.get()) {
            throw new ConsensusGroupNotExistException(groupId);
        }
    }

    @Override
    public void addRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        IoTConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (impl.getConfiguration().contains(peer)) {
            throw new PeerAlreadyInConsensusGroupException(groupId, peer);
        }
        try {
            this.logger.info("[IoTConsensus] inactivate new peer: {}", (Object)peer);
            impl.inactivePeer(peer);
            this.logger.info("[IoTConsensus] notify current peers to build sync log...");
            impl.checkAndLockSafeDeletedSearchIndex();
            impl.notifyPeersToBuildSyncLogChannel(peer);
            this.logger.info("[IoTConsensus] start to take snapshot...");
            impl.takeSnapshot();
            this.logger.info("[IoTConsensus] start to transit snapshot...");
            impl.transitSnapshot(peer);
            this.logger.info("[IoTConsensus] trigger new peer to load snapshot...");
            impl.triggerSnapshotLoad(peer);
            this.logger.info("[IoTConsensus] activate new peer...");
            impl.activePeer(peer);
            this.logger.info("[IoTConsensus] do spot clean...");
            this.doSpotClean(peer, impl);
        }
        catch (ConsensusGroupModifyPeerException e) {
            throw new ConsensusException(e.getMessage());
        }
    }

    private void doSpotClean(Peer peer, IoTConsensusServerImpl impl) {
        try {
            impl.cleanupRemoteSnapshot(peer);
        }
        catch (ConsensusGroupModifyPeerException e) {
            this.logger.warn("[IoTConsensus] failed to cleanup remote snapshot", (Throwable)e);
        }
    }

    @Override
    public void removeRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        IoTConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (!impl.getConfiguration().contains(peer)) {
            throw new PeerNotInConsensusGroupException(groupId, peer.toString());
        }
        try {
            impl.notifyPeersToRemoveSyncLogChannel(peer);
        }
        catch (ConsensusGroupModifyPeerException e) {
            throw new ConsensusException(e.getMessage());
        }
        try {
            impl.inactivePeer(peer);
            impl.waitTargetPeerUntilSyncLogCompleted(peer);
        }
        catch (ConsensusGroupModifyPeerException e) {
            throw new ConsensusException(e.getMessage());
        }
    }

    @Override
    public void transferLeader(ConsensusGroupId groupId, Peer newLeader) throws ConsensusException {
        throw new ConsensusException("IoTConsensus does not support leader transfer");
    }

    @Override
    public void triggerSnapshot(ConsensusGroupId groupId) throws ConsensusException {
        IoTConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        try {
            impl.takeSnapshot();
        }
        catch (ConsensusGroupModifyPeerException e) {
            throw new ConsensusException(e.getMessage());
        }
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public boolean isLeaderReady(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        if (!this.stateMachineMap.containsKey(groupId)) {
            return null;
        }
        return new Peer(groupId, this.thisNodeId, this.thisNode);
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        return new ArrayList<ConsensusGroupId>(this.stateMachineMap.keySet());
    }

    public IoTConsensusServerImpl getImpl(ConsensusGroupId groupId) {
        return this.stateMachineMap.get(groupId);
    }

    public static String buildPeerDir(File storageDir, ConsensusGroupId groupId) {
        return storageDir + File.separator + groupId.getType().getValue() + "_" + groupId.getId();
    }
}

