/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.ConfigNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.cache.node.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupCache;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.route.RegionRouteCache;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadCache.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final long HEARTBEAT_INTERVAL = CONF.getHeartbeatIntervalInMs();
    private final Map<Integer, BaseNodeCache> nodeCacheMap = new ConcurrentHashMap<Integer, BaseNodeCache>();
    private final Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroupCache>();
    private final Map<TConsensusGroupId, RegionRouteCache> regionRouteCacheMap = new ConcurrentHashMap<TConsensusGroupId, RegionRouteCache>();

    public void initHeartbeatCache(IManager configManager) {
        this.initNodeHeartbeatCache(configManager.getNodeManager().getRegisteredConfigNodes(), configManager.getNodeManager().getRegisteredDataNodes());
        this.initRegionGroupHeartbeatCache(configManager.getPartitionManager().getAllReplicaSets());
    }

    private void initNodeHeartbeatCache(List<TConfigNodeLocation> registeredConfigNodes, List<TDataNodeConfiguration> registeredDataNodes) {
        int CURRENT_NODE_ID = ConfigNodeHeartbeatCache.CURRENT_NODE_ID;
        this.nodeCacheMap.clear();
        registeredConfigNodes.forEach(configNodeLocation -> {
            int configNodeId = configNodeLocation.getConfigNodeId();
            if (configNodeId != CURRENT_NODE_ID) {
                this.nodeCacheMap.put(configNodeId, new ConfigNodeHeartbeatCache(configNodeId));
            }
        });
        this.nodeCacheMap.put(ConfigNodeHeartbeatCache.CURRENT_NODE_ID, new ConfigNodeHeartbeatCache(CURRENT_NODE_ID, ConfigNodeHeartbeatCache.CURRENT_NODE_STATISTICS));
        registeredDataNodes.forEach(dataNodeConfiguration -> {
            int dataNodeId = dataNodeConfiguration.getLocation().getDataNodeId();
            this.nodeCacheMap.put(dataNodeId, new DataNodeHeartbeatCache(dataNodeId));
        });
    }

    private void initRegionGroupHeartbeatCache(List<TRegionReplicaSet> regionReplicaSets) {
        this.regionGroupCacheMap.clear();
        regionReplicaSets.forEach(regionReplicaSet -> {
            TConsensusGroupId consensusGroupId = regionReplicaSet.getRegionId();
            this.regionGroupCacheMap.put(consensusGroupId, new RegionGroupCache(consensusGroupId));
            this.regionRouteCacheMap.put(consensusGroupId, new RegionRouteCache(consensusGroupId));
        });
    }

    public void clearHeartbeatCache() {
        this.nodeCacheMap.clear();
        this.regionGroupCacheMap.clear();
    }

    public void cacheConfigNodeHeartbeatSample(int nodeId, TConfigNodeHeartbeatResp resp) {
        long receiveTime = System.currentTimeMillis();
        this.nodeCacheMap.computeIfAbsent(nodeId, empty -> new ConfigNodeHeartbeatCache(nodeId)).cacheHeartbeatSample(new NodeHeartbeatSample(resp, receiveTime));
    }

    public void cacheDataNodeHeartbeatSample(int nodeId, NodeHeartbeatSample sample) {
        this.nodeCacheMap.computeIfAbsent(nodeId, empty -> new DataNodeHeartbeatCache(nodeId)).cacheHeartbeatSample(sample);
    }

    public void cacheRegionHeartbeatSample(TConsensusGroupId regionGroupId, int nodeId, RegionHeartbeatSample sample) {
        this.regionGroupCacheMap.computeIfAbsent(regionGroupId, empty -> new RegionGroupCache(regionGroupId)).cacheHeartbeatSample(nodeId, sample);
    }

    public void cacheLeaderSample(TConsensusGroupId regionGroupId, Pair<Long, Integer> leaderSample) {
        this.regionRouteCacheMap.computeIfAbsent(regionGroupId, empty -> new RegionRouteCache(regionGroupId)).cacheLeaderSample(leaderSample);
    }

    public Map<Integer, Pair<NodeStatistics, NodeStatistics>> updateNodeStatistics() {
        HashMap<Integer, Pair<NodeStatistics, NodeStatistics>> differentNodeStatisticsMap = new HashMap<Integer, Pair<NodeStatistics, NodeStatistics>>();
        this.nodeCacheMap.forEach((nodeId, nodeCache) -> {
            NodeStatistics preNodeStatistics = nodeCache.getPreviousStatistics().deepCopy();
            if (nodeCache.periodicUpdate()) {
                differentNodeStatisticsMap.put((Integer)nodeId, (Pair<NodeStatistics, NodeStatistics>)new Pair((Object)preNodeStatistics, (Object)nodeCache.getStatistics()));
            }
        });
        return differentNodeStatisticsMap;
    }

    public Map<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> updateRegionGroupStatistics() {
        HashMap<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> differentRegionGroupStatisticsMap = new HashMap<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>>();
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> {
            RegionGroupStatistics preRegionGroupStatistics = regionGroupCache.getPreviousStatistics().deepCopy();
            if (regionGroupCache.periodicUpdate()) {
                differentRegionGroupStatisticsMap.put((TConsensusGroupId)regionGroupId, (Pair<RegionGroupStatistics, RegionGroupStatistics>)new Pair((Object)preRegionGroupStatistics, (Object)regionGroupCache.getStatistics()));
            }
        });
        return differentRegionGroupStatisticsMap;
    }

    public Map<TConsensusGroupId, Pair<Integer, Integer>> updateRegionGroupLeader() {
        HashMap<TConsensusGroupId, Pair<Integer, Integer>> differentRegionGroupLeaderMap = new HashMap<TConsensusGroupId, Pair<Integer, Integer>>();
        this.regionRouteCacheMap.forEach((regionGroupId, regionRouteCache) -> {
            int prevLeader = regionRouteCache.getLeaderId();
            if (regionRouteCache.periodicUpdate()) {
                differentRegionGroupLeaderMap.put((TConsensusGroupId)regionGroupId, (Pair<Integer, Integer>)new Pair((Object)prevLeader, (Object)regionRouteCache.getLeaderId()));
            }
        });
        return differentRegionGroupLeaderMap;
    }

    public NodeStatus getNodeStatus(int nodeId) {
        BaseNodeCache nodeCache = this.nodeCacheMap.get(nodeId);
        return nodeCache == null ? NodeStatus.Unknown : nodeCache.getNodeStatus();
    }

    public String getNodeStatusWithReason(int nodeId) {
        BaseNodeCache nodeCache = this.nodeCacheMap.get(nodeId);
        return nodeCache == null ? NodeStatus.Unknown.getStatus() + "(NoHeartbeat)" : nodeCache.getNodeStatusWithReason();
    }

    public Map<Integer, String> getNodeStatusWithReason() {
        return this.nodeCacheMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BaseNodeCache)e.getValue()).getNodeStatusWithReason()));
    }

    public List<Integer> filterConfigNodeThroughStatus(NodeStatus ... status) {
        return this.nodeCacheMap.entrySet().stream().filter(nodeCacheEntry -> nodeCacheEntry.getValue() instanceof ConfigNodeHeartbeatCache && Arrays.stream(status).anyMatch(s -> s.equals((Object)((BaseNodeCache)nodeCacheEntry.getValue()).getNodeStatus()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<Integer> filterDataNodeThroughStatus(NodeStatus ... status) {
        return this.nodeCacheMap.entrySet().stream().filter(nodeCacheEntry -> nodeCacheEntry.getValue() instanceof DataNodeHeartbeatCache && Arrays.stream(status).anyMatch(s -> s.equals((Object)((BaseNodeCache)nodeCacheEntry.getValue()).getNodeStatus()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public double getFreeDiskSpace(int dataNodeId) {
        DataNodeHeartbeatCache dataNodeHeartbeatCache = (DataNodeHeartbeatCache)this.nodeCacheMap.get(dataNodeId);
        return dataNodeHeartbeatCache == null ? 0.0 : dataNodeHeartbeatCache.getFreeDiskSpace();
    }

    public Map<Integer, Long> getAllDataNodeLoadScores() {
        ConcurrentHashMap<Integer, Long> result = new ConcurrentHashMap<Integer, Long>();
        this.nodeCacheMap.forEach((dataNodeId, heartbeatCache) -> {
            if (heartbeatCache instanceof DataNodeHeartbeatCache) {
                result.put((Integer)dataNodeId, heartbeatCache.getLoadScore());
            }
        });
        return result;
    }

    public int getLowestLoadDataNode() {
        return this.nodeCacheMap.entrySet().stream().filter(nodeCacheEntry -> nodeCacheEntry.getValue() instanceof DataNodeHeartbeatCache).min(Comparator.comparingLong(nodeCacheEntry -> ((BaseNodeCache)nodeCacheEntry.getValue()).getLoadScore())).map(Map.Entry::getKey).orElse(-1);
    }

    public int getLowestLoadDataNode(List<Integer> dataNodeIds) {
        return dataNodeIds.stream().map(this.nodeCacheMap::get).filter(Objects::nonNull).min(Comparator.comparingLong(BaseNodeCache::getLoadScore)).map(BaseNodeCache::getNodeId).orElse(-1);
    }

    public void forceUpdateNodeCache(NodeType nodeType, int nodeId, NodeHeartbeatSample heartbeatSample) {
        switch (nodeType) {
            case ConfigNode: {
                this.nodeCacheMap.computeIfAbsent(nodeId, empty -> new ConfigNodeHeartbeatCache(nodeId)).forceUpdate(heartbeatSample);
                break;
            }
            default: {
                this.nodeCacheMap.computeIfAbsent(nodeId, empty -> new DataNodeHeartbeatCache(nodeId)).forceUpdate(heartbeatSample);
            }
        }
    }

    public void removeNodeCache(int nodeId) {
        this.nodeCacheMap.remove(nodeId);
    }

    public RegionStatus getRegionStatus(TConsensusGroupId consensusGroupId, int dataNodeId) {
        return this.regionGroupCacheMap.containsKey(consensusGroupId) ? this.regionGroupCacheMap.get(consensusGroupId).getStatistics().getRegionStatus(dataNodeId) : RegionStatus.Unknown;
    }

    public RegionGroupStatus getRegionGroupStatus(TConsensusGroupId consensusGroupId) {
        return this.regionGroupCacheMap.containsKey(consensusGroupId) ? this.regionGroupCacheMap.get(consensusGroupId).getStatistics().getRegionGroupStatus() : RegionGroupStatus.Disabled;
    }

    public Map<TConsensusGroupId, RegionGroupStatus> getRegionGroupStatus(List<TConsensusGroupId> consensusGroupIds) {
        ConcurrentHashMap<TConsensusGroupId, RegionGroupStatus> regionGroupStatusMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroupStatus>();
        for (TConsensusGroupId consensusGroupId : consensusGroupIds) {
            regionGroupStatusMap.put(consensusGroupId, this.getRegionGroupStatus(consensusGroupId));
        }
        return regionGroupStatusMap;
    }

    public List<TConsensusGroupId> filterRegionGroupThroughStatus(RegionGroupStatus ... status) {
        return this.regionGroupCacheMap.entrySet().stream().filter(regionGroupCacheEntry -> Arrays.stream(status).anyMatch(s -> s.equals((Object)((RegionGroupCache)regionGroupCacheEntry.getValue()).getStatistics().getRegionGroupStatus()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public int countRegionWithSpecifiedStatus(TConsensusGroupType type, RegionStatus ... status) {
        AtomicInteger result = new AtomicInteger(0);
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> {
            if (type.equals((Object)regionGroupId.getType())) {
                regionGroupCache.getStatistics().getRegionStatisticsMap().values().forEach(regionStatistics -> {
                    if (Arrays.stream(status).anyMatch(s -> s.equals((Object)regionStatistics.getRegionStatus()))) {
                        result.getAndIncrement();
                    }
                });
            }
        });
        return result.get();
    }

    public void forceUpdateRegionGroupCache(TConsensusGroupId regionGroupId, Map<Integer, RegionHeartbeatSample> heartbeatSampleMap) {
        this.regionGroupCacheMap.computeIfAbsent(regionGroupId, empty -> new RegionGroupCache(regionGroupId)).forceUpdate(heartbeatSampleMap);
    }

    public void removeRegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.regionGroupCacheMap.remove(consensusGroupId);
    }

    public Map<TConsensusGroupId, Integer> getRegionLeaderMap() {
        ConcurrentHashMap<TConsensusGroupId, Integer> regionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Integer>();
        this.regionRouteCacheMap.forEach((regionGroupId, regionRouteCache) -> regionLeaderMap.put((TConsensusGroupId)regionGroupId, regionRouteCache.getLeaderId()));
        return regionLeaderMap;
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRegionPriorityMap() {
        ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();
        this.regionRouteCacheMap.forEach((regionGroupId, regionRouteCache) -> {
            if (!RegionRouteCache.unReadyRegionPriority.equals(regionRouteCache.getRegionPriority())) {
                regionPriorityMap.put((TConsensusGroupId)regionGroupId, regionRouteCache.getRegionPriority());
            }
        });
        return regionPriorityMap;
    }

    public void waitForLeaderElection(List<TConsensusGroupId> regionGroupIds) {
        for (int retry = 0; retry < 10; ++retry) {
            AtomicBoolean allRegionLeaderElected = new AtomicBoolean(true);
            regionGroupIds.forEach(regionGroupId -> {
                if (!this.regionRouteCacheMap.containsKey(regionGroupId) || this.regionRouteCacheMap.get(regionGroupId).isRegionGroupUnready()) {
                    allRegionLeaderElected.set(false);
                }
            });
            if (allRegionLeaderElected.get()) {
                LOGGER.info("[RegionElection] The leader of RegionGroups: {} is elected.", regionGroupIds);
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(HEARTBEAT_INTERVAL);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupt when wait for leader election", (Throwable)e);
            }
        }
        LOGGER.warn("[RegionElection] The leader or priority of RegionGroups: {} is not determined after 10 heartbeat interval. Some function might fail.", regionGroupIds);
    }

    public void forceUpdateRegionLeader(TConsensusGroupId regionGroupId, int leaderId) {
        this.regionRouteCacheMap.computeIfAbsent(regionGroupId, empty -> new RegionRouteCache(regionGroupId)).forceUpdateRegionLeader(leaderId);
    }

    public void forceUpdateRegionPriority(TConsensusGroupId regionGroupId, TRegionReplicaSet regionPriority) {
        this.regionRouteCacheMap.computeIfAbsent(regionGroupId, empty -> new RegionRouteCache(regionGroupId)).forceUpdateRegionPriority(regionPriority);
    }

    public void removeRegionRouteCache(TConsensusGroupId regionGroupId) {
        this.regionRouteCacheMap.remove(regionGroupId);
    }

    public boolean existUnreadyRegionGroup() {
        return this.regionRouteCacheMap.values().stream().anyMatch(RegionRouteCache::isRegionGroupUnready);
    }
}

