/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.heartbeat;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.pipe.runtime.PipeRuntimeCoordinator;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.async.AsyncMethodCallback;

public class DataNodeHeartbeatHandler
implements AsyncMethodCallback<TDataNodeHeartbeatResp> {
    private final int nodeId;
    private final LoadCache loadCache;
    private final Map<Integer, Long> deviceNum;
    private final Map<Integer, Long> timeSeriesNum;
    private final Map<Integer, Long> regionDisk;
    private final Consumer<Map<Integer, Long>> seriesUsageRespProcess;
    private final Consumer<Map<Integer, Long>> deviceUsageRespProcess;
    private final PipeRuntimeCoordinator pipeRuntimeCoordinator;

    public DataNodeHeartbeatHandler(int nodeId, LoadCache loadCache, Map<Integer, Long> deviceNum, Map<Integer, Long> timeSeriesNum, Map<Integer, Long> regionDisk, Consumer<Map<Integer, Long>> seriesUsageRespProcess, Consumer<Map<Integer, Long>> deviceUsageRespProcess, PipeRuntimeCoordinator pipeRuntimeCoordinator) {
        this.nodeId = nodeId;
        this.loadCache = loadCache;
        this.deviceNum = deviceNum;
        this.timeSeriesNum = timeSeriesNum;
        this.regionDisk = regionDisk;
        this.seriesUsageRespProcess = seriesUsageRespProcess;
        this.deviceUsageRespProcess = deviceUsageRespProcess;
        this.pipeRuntimeCoordinator = pipeRuntimeCoordinator;
    }

    public void onComplete(TDataNodeHeartbeatResp heartbeatResp) {
        long receiveTime = System.currentTimeMillis();
        this.loadCache.cacheDataNodeHeartbeatSample(this.nodeId, new NodeHeartbeatSample(heartbeatResp, receiveTime));
        heartbeatResp.getJudgedLeaders().forEach((regionGroupId, isLeader) -> {
            this.loadCache.cacheRegionHeartbeatSample((TConsensusGroupId)regionGroupId, this.nodeId, new RegionHeartbeatSample(heartbeatResp.getHeartbeatTimestamp(), receiveTime, RegionStatus.parse((String)heartbeatResp.getStatus())));
            if (Boolean.TRUE.equals(isLeader)) {
                this.loadCache.cacheLeaderSample((TConsensusGroupId)regionGroupId, (Pair<Long, Integer>)new Pair((Object)heartbeatResp.getHeartbeatTimestamp(), (Object)this.nodeId));
            }
        });
        if (heartbeatResp.getRegionDeviceUsageMap() != null) {
            this.deviceNum.putAll(heartbeatResp.getRegionDeviceUsageMap());
            this.deviceUsageRespProcess.accept(heartbeatResp.getRegionDeviceUsageMap());
        }
        if (heartbeatResp.getRegionSeriesUsageMap() != null) {
            this.timeSeriesNum.putAll(heartbeatResp.getRegionSeriesUsageMap());
            this.seriesUsageRespProcess.accept(heartbeatResp.getRegionSeriesUsageMap());
        }
        if (heartbeatResp.getRegionDisk() != null) {
            this.regionDisk.putAll(heartbeatResp.getRegionDisk());
        }
        if (heartbeatResp.getPipeMetaList() != null) {
            this.pipeRuntimeCoordinator.parseHeartbeat(this.nodeId, heartbeatResp.getPipeMetaList());
        }
    }

    public void onError(Exception e) {
        if (ThriftClient.isConnectionBroken((Throwable)e)) {
            this.loadCache.forceUpdateNodeCache(NodeType.DataNode, this.nodeId, NodeHeartbeatSample.generateDefaultSample(NodeStatus.Unknown));
        }
    }
}

