/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileLock;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceBlockType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileResource.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    public static final String TEMP_SUFFIX = ".temp";
    public static final String BROKEN_SUFFIX = ".broken";
    public static final byte VERSION_NUMBER = 1;
    protected TsFileResource prev;
    protected TsFileResource next;
    private ITimeIndex timeIndex;
    private volatile ModificationFile modFile;
    private volatile ModificationFile compactionModFile;
    protected AtomicReference<TsFileResourceStatus> atomicStatus = new AtomicReference<TsFileResourceStatus>(TsFileResourceStatus.UNCLOSED);
    private TsFileLock tsFileLock = new TsFileLock();
    private final Random random = new Random();
    private boolean isSeq;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private DataRegion.SettleTsFileCallBack settleTsFileCallBack;
    public long maxPlanIndex = Long.MIN_VALUE;
    public long minPlanIndex = Long.MAX_VALUE;
    private long version = 0L;
    private long ramSize;
    private AtomicInteger tierLevel;
    private volatile long tsFileSize = -1L;
    private TsFileProcessor processor;
    private Map<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap = new HashMap<PartialPath, List<IChunkMetadata>>();
    private Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap = new HashMap<PartialPath, List<ReadOnlyMemChunk>>();
    private Map<PartialPath, ITimeSeriesMetadata> pathToTimeSeriesMetadataMap = new HashMap<PartialPath, ITimeSeriesMetadata>();
    private TsFileResource originTsFileResource;
    private ProgressIndex maxProgressIndex;
    private boolean isInsertionCompactionTaskCandidate = true;

    public TsFileResource() {
    }

    public TsFileResource(TsFileResource other) throws IOException {
        this.file = other.file;
        this.processor = other.processor;
        this.timeIndex = other.timeIndex;
        this.modFile = other.modFile;
        this.setAtomicStatus(other.getStatus());
        this.pathToChunkMetadataListMap = other.pathToChunkMetadataListMap;
        this.pathToReadOnlyMemChunkMap = other.pathToReadOnlyMemChunkMap;
        this.pathToTimeSeriesMetadataMap = other.pathToTimeSeriesMetadataMap;
        this.tsFileLock = other.tsFileLock;
        this.fsFactory = other.fsFactory;
        this.maxPlanIndex = other.maxPlanIndex;
        this.minPlanIndex = other.minPlanIndex;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.tsFileSize = other.tsFileSize;
        this.isSeq = other.isSeq;
        this.tierLevel = other.tierLevel;
        this.maxProgressIndex = other.maxProgressIndex;
    }

    public TsFileResource(File file) {
        this.file = file;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.isSeq = FilePathUtils.isSequence((String)this.file.getAbsolutePath());
        this.tierLevel = new AtomicInteger(TierManager.getInstance().getFileTierLevel(file));
    }

    public TsFileResource(File file, TsFileResourceStatus status) {
        this(file);
        this.setAtomicStatus(status);
    }

    public TsFileResource(File file, TsFileProcessor processor) {
        this.file = file;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.processor = processor;
        this.isSeq = processor.isSequence();
        this.tierLevel = new AtomicInteger(0);
    }

    public TsFileResource(Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap, Map<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap, TsFileResource originTsFileResource) throws IOException {
        this.file = originTsFileResource.file;
        this.timeIndex = originTsFileResource.timeIndex;
        this.pathToReadOnlyMemChunkMap = pathToReadOnlyMemChunkMap;
        this.pathToChunkMetadataListMap = pathToChunkMetadataListMap;
        this.generatePathToTimeSeriesMetadataMap();
        this.originTsFileResource = originTsFileResource;
        this.version = originTsFileResource.version;
        this.isSeq = originTsFileResource.isSeq;
        this.tierLevel = originTsFileResource.tierLevel;
    }

    public TsFileResource(File file, Map<String, Integer> deviceToIndex, long[] startTimes, long[] endTimes) {
        this.file = file;
        this.timeIndex = new DeviceTimeIndex(deviceToIndex, startTimes, endTimes);
    }

    public synchronized void serialize() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
        try {
            this.serializeTo(outputStream);
        }
        finally {
            outputStream.flush();
            fileOutputStream.getFD().sync();
            outputStream.close();
        }
        File src = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        File dest = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX);
        this.fsFactory.deleteIfExists(dest);
        this.fsFactory.moveFile(src, dest);
    }

    private void serializeTo(BufferedOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        this.timeIndex.serialize(outputStream);
        ReadWriteIOUtils.write((long)this.maxPlanIndex, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.minPlanIndex, (OutputStream)outputStream);
        if (this.modFile != null && this.modFile.exists()) {
            String modFileName = new File(this.modFile.getFilePath()).getName();
            ReadWriteIOUtils.write((String)modFileName, (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((String)null, (OutputStream)outputStream);
        }
        if (this.maxProgressIndex != null) {
            TsFileResourceBlockType.PROGRESS_INDEX.serialize(outputStream);
            this.maxProgressIndex.serialize((OutputStream)outputStream);
        } else {
            TsFileResourceBlockType.EMPTY_BLOCK.serialize(outputStream);
        }
    }

    public void deserialize() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            String modFileName;
            ReadWriteIOUtils.readByte((InputStream)inputStream);
            this.timeIndex = ITimeIndex.createTimeIndex(inputStream);
            this.maxPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.minPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            if (((InputStream)inputStream).available() > 0 && (modFileName = ReadWriteIOUtils.readString((InputStream)inputStream)) != null) {
                File modF = new File(this.file.getParentFile(), modFileName);
                this.modFile = new ModificationFile(modF.getPath());
            }
            while (((InputStream)inputStream).available() > 0) {
                TsFileResourceBlockType blockType = TsFileResourceBlockType.deserialize(ReadWriteIOUtils.readByte((InputStream)inputStream));
                if (blockType != TsFileResourceBlockType.PROGRESS_INDEX) continue;
                this.maxProgressIndex = ProgressIndexType.deserializeFrom((InputStream)inputStream);
            }
        }
    }

    public void updateStartTime(String device, long time) {
        this.timeIndex.updateStartTime(device, time);
    }

    public void updateEndTime(String device, long time) {
        this.timeIndex.updateEndTime(device, time);
    }

    public boolean resourceFileExists() {
        return this.file != null && this.fsFactory.getFile(this.file + RESOURCE_SUFFIX).exists();
    }

    public boolean tsFileExists() {
        return this.file != null && this.file.exists();
    }

    public boolean modFileExists() {
        return this.getModFile().exists();
    }

    public List<IChunkMetadata> getChunkMetadataList(PartialPath seriesPath) {
        return new ArrayList<IChunkMetadata>((Collection)this.pathToChunkMetadataListMap.get(seriesPath));
    }

    public List<ReadOnlyMemChunk> getReadOnlyMemChunk(PartialPath seriesPath) {
        return this.pathToReadOnlyMemChunkMap.get(seriesPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getModFile() {
        if (this.modFile == null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                if (this.modFile == null) {
                    this.modFile = ModificationFile.getNormalMods(this);
                }
            }
        }
        return this.modFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getCompactionModFile() {
        if (this.compactionModFile == null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                if (this.compactionModFile == null) {
                    this.compactionModFile = ModificationFile.getCompactionMods(this);
                }
            }
        }
        return this.compactionModFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetModFile() throws IOException {
        if (this.modFile != null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                this.modFile.close();
                this.modFile = null;
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getTsFile() {
        return this.file;
    }

    public String getTsFilePath() {
        return this.file.getPath();
    }

    public void increaseTierLevel() {
        this.tierLevel.addAndGet(1);
    }

    public int getTierLevel() {
        return this.tierLevel.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTsFileSize() {
        if (this.isClosed()) {
            if (this.tsFileSize == -1L) {
                TsFileResource tsFileResource = this;
                synchronized (tsFileResource) {
                    if (this.tsFileSize == -1L) {
                        this.tsFileSize = this.file.length();
                    }
                }
            }
            return this.tsFileSize;
        }
        return this.file.length();
    }

    public long getStartTime(String deviceId) {
        return this.timeIndex.getStartTime(deviceId);
    }

    public long getEndTime(String deviceId) {
        return this.timeIndex.getEndTime(deviceId);
    }

    public long getOrderTime(String deviceId, boolean ascending) {
        return ascending ? this.getStartTime(deviceId) : this.getEndTime(deviceId);
    }

    public long getFileStartTime() {
        return this.timeIndex.getMinStartTime();
    }

    public long getFileEndTime() {
        return this.timeIndex.getMaxEndTime();
    }

    public Set<String> getDevices() {
        return this.timeIndex.getDevices(this.file.getPath(), this);
    }

    public DeviceTimeIndex buildDeviceTimeIndex() throws IOException {
        this.readLock();
        try {
            DeviceTimeIndex deviceTimeIndex;
            block12: {
                BufferedInputStream inputStream = FSFactoryProducer.getFSFactory().getBufferedInputStream(this.file.getPath() + RESOURCE_SUFFIX);
                try {
                    ReadWriteIOUtils.readByte((InputStream)inputStream);
                    ITimeIndex timeIndexFromResourceFile = ITimeIndex.createTimeIndex(inputStream);
                    if (!(timeIndexFromResourceFile instanceof DeviceTimeIndex)) {
                        throw new IOException("cannot build DeviceTimeIndex from resource " + this.file.getPath());
                    }
                    deviceTimeIndex = (DeviceTimeIndex)timeIndexFromResourceFile;
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IOException("Can't read file " + this.file.getPath() + RESOURCE_SUFFIX + " from disk", e);
                    }
                }
                ((InputStream)inputStream).close();
            }
            return deviceTimeIndex;
        }
        finally {
            this.readUnlock();
        }
    }

    public ITimeIndex getTimeIndex() {
        return this.timeIndex;
    }

    public boolean definitelyNotContains(String device) {
        return this.timeIndex.definitelyNotContains(device);
    }

    public Pair<Long, Long> getPossibleStartTimeAndEndTime(PartialPath devicePattern, Set<String> deviceMatchInfo) {
        return this.timeIndex.getPossibleStartTimeAndEndTime(devicePattern, deviceMatchInfo);
    }

    public boolean isClosed() {
        return this.getStatus() != TsFileResourceStatus.UNCLOSED;
    }

    public void close() throws IOException {
        this.setStatus(TsFileResourceStatus.NORMAL);
        this.closeWithoutSettingStatus();
    }

    public void closeWithoutSettingStatus() throws IOException {
        if (this.modFile != null) {
            this.modFile.close();
            this.modFile = null;
        }
        if (this.compactionModFile != null) {
            this.compactionModFile.close();
            this.compactionModFile = null;
        }
        this.processor = null;
        this.pathToChunkMetadataListMap = null;
        this.pathToReadOnlyMemChunkMap = null;
        this.pathToTimeSeriesMetadataMap = null;
        this.timeIndex.close();
    }

    public TsFileProcessor getProcessor() {
        return this.processor;
    }

    public void writeLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeLock();
        } else {
            this.originTsFileResource.writeLock();
        }
    }

    public void writeUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeUnlock();
        } else {
            this.originTsFileResource.writeUnlock();
        }
    }

    public void readLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readLock();
        } else {
            this.originTsFileResource.readLock();
        }
    }

    public void readUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readUnlock();
        } else {
            this.originTsFileResource.readUnlock();
        }
    }

    public boolean tryWriteLock() {
        return this.tsFileLock.tryWriteLock();
    }

    public boolean tryReadLock() {
        return this.tsFileLock.tryReadLock();
    }

    public void removeModFile() throws IOException {
        this.getModFile().remove();
        this.modFile = null;
    }

    public boolean remove() {
        this.forceMarkDeleted();
        try {
            this.fsFactory.deleteIfExists(this.file);
            this.fsFactory.deleteIfExists(new File(this.file.getAbsolutePath() + ".meta"));
        }
        catch (IOException e) {
            LOGGER.error("TsFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        if (!this.removeResourceFile()) {
            return false;
        }
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + ".mods"));
        }
        catch (IOException e) {
            LOGGER.error("ModificationFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean removeResourceFile() {
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX));
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX + TEMP_SUFFIX));
        }
        catch (IOException e) {
            LOGGER.error("TsFileResource {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public void moveTo(File targetDir) throws IOException {
        this.fsFactory.moveFile(this.file, this.fsFactory.getFile(targetDir, this.file.getName()));
        this.fsFactory.moveFile(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX), this.fsFactory.getFile(targetDir, this.file.getName() + RESOURCE_SUFFIX));
        File originModFile = this.fsFactory.getFile(this.file.getPath() + ".mods");
        if (originModFile.exists()) {
            this.fsFactory.moveFile(originModFile, this.fsFactory.getFile(targetDir, this.file.getName() + ".mods"));
        }
    }

    public String toString() {
        return String.format("file is %s, status: %s", new Object[]{this.file.toString(), this.getStatus()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileResource that = (TsFileResource)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public boolean isDeleted() {
        return this.getStatus() == TsFileResourceStatus.DELETED;
    }

    public boolean isCompacting() {
        return this.getStatus() == TsFileResourceStatus.COMPACTING;
    }

    public boolean isCompactionCandidate() {
        return this.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE;
    }

    public boolean onRemote() {
        return !this.isDeleted() && !this.file.exists();
    }

    private boolean compareAndSetStatus(TsFileResourceStatus expectedValue, TsFileResourceStatus newValue) {
        return this.atomicStatus.compareAndSet(expectedValue, newValue);
    }

    private void setAtomicStatus(TsFileResourceStatus status) {
        this.atomicStatus.set(status);
    }

    public void setStatusForTest(TsFileResourceStatus status) {
        this.setAtomicStatus(status);
    }

    public boolean setStatus(TsFileResourceStatus status) {
        if (status == this.getStatus()) {
            return true;
        }
        switch (status) {
            case NORMAL: {
                return this.compareAndSetStatus(TsFileResourceStatus.UNCLOSED, TsFileResourceStatus.NORMAL) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTING, TsFileResourceStatus.NORMAL) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.NORMAL);
            }
            case UNCLOSED: {
                return false;
            }
            case DELETED: {
                return this.compareAndSetStatus(TsFileResourceStatus.NORMAL, TsFileResourceStatus.DELETED) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.DELETED);
            }
            case COMPACTING: {
                return this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.COMPACTING);
            }
            case COMPACTION_CANDIDATE: {
                return this.compareAndSetStatus(TsFileResourceStatus.NORMAL, TsFileResourceStatus.COMPACTION_CANDIDATE);
            }
        }
        return false;
    }

    public void forceMarkDeleted() {
        this.atomicStatus.set(TsFileResourceStatus.DELETED);
    }

    public TsFileResourceStatus getStatus() {
        return this.atomicStatus.get();
    }

    public boolean stillLives(long timeLowerBound) {
        return !this.isClosed() || this.timeIndex.stillLives(timeLowerBound);
    }

    public boolean isDeviceIdExist(String deviceId) {
        return this.timeIndex.checkDeviceIdExist(deviceId);
    }

    public boolean isSatisfied(String deviceId, Filter timeFilter, boolean isSeq, long ttl, boolean debug) {
        long endTime;
        if (deviceId == null) {
            return this.isSatisfied(timeFilter, isSeq, ttl, debug);
        }
        long[] startAndEndTime = this.timeIndex.getStartAndEndTime(deviceId);
        if (startAndEndTime == null) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        long startTime = startAndEndTime[0];
        long l = endTime = this.isClosed() || !isSeq ? startAndEndTime[1] : Long.MAX_VALUE;
        if (!this.isAlive(endTime, ttl)) {
            if (debug) {
                DEBUG_LOGGER.info("file {} is not satisfied because of ttl!", (Object)this.file);
            }
            return false;
        }
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", (Object)deviceId, (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    private boolean isSatisfied(Filter timeFilter, boolean isSeq, long ttl, boolean debug) {
        long endTime;
        long startTime = this.getFileStartTime();
        long l = endTime = this.isClosed() || !isSeq ? this.getFileEndTime() : Long.MAX_VALUE;
        if (startTime > endTime) {
            LOGGER.warn("startTime[{}] of TsFileResource[{}] is greater than its endTime[{}]", new Object[]{startTime, this, endTime});
            return false;
        }
        if (!this.isAlive(endTime, ttl)) {
            if (debug) {
                DEBUG_LOGGER.info("file {} is not satisfied because of ttl!", (Object)this.file);
            }
            return false;
        }
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: file {} is not satisfied because of time filter!", (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    public boolean isSatisfied(String deviceId, Filter timeFilter, boolean isSeq, boolean debug) {
        long endTime;
        if (this.definitelyNotContains(deviceId)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        long startTime = this.getStartTime(deviceId);
        long l = endTime = this.isClosed() || !isSeq ? this.getEndTime(deviceId) : Long.MAX_VALUE;
        if (startTime > endTime) {
            LOGGER.warn("startTime[{}] of TsFileResource[{}] is greater than its endTime[{}]", new Object[]{startTime, this, endTime});
            return false;
        }
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", (Object)deviceId, (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    private boolean isAlive(long time, long dataTTL) {
        return dataTTL == Long.MAX_VALUE || CommonDateTimeUtils.currentTime() - time <= dataTTL;
    }

    public void setProcessor(TsFileProcessor processor) {
        this.processor = processor;
    }

    public ITimeSeriesMetadata getTimeSeriesMetadata(PartialPath seriesPath) {
        if (this.pathToTimeSeriesMetadataMap.containsKey(seriesPath)) {
            return this.pathToTimeSeriesMetadataMap.get(seriesPath);
        }
        return null;
    }

    public void setTimeSeriesMetadata(PartialPath path, ITimeSeriesMetadata timeSeriesMetadata) {
        this.pathToTimeSeriesMetadataMap.put(path, timeSeriesMetadata);
    }

    public DataRegion.SettleTsFileCallBack getSettleTsFileCallBack() {
        return this.settleTsFileCallBack;
    }

    public void setSettleTsFileCallBack(DataRegion.SettleTsFileCallBack settleTsFileCallBack) {
        this.settleTsFileCallBack = settleTsFileCallBack;
    }

    public long getTimePartition() {
        return this.timeIndex.getTimePartition(this.file.getAbsolutePath());
    }

    public long getTimePartitionWithCheck() throws PartitionViolationException {
        return this.timeIndex.getTimePartitionWithCheck(this.file.toString());
    }

    public boolean isSpanMultiTimePartitions() {
        return this.timeIndex.isSpanMultiTimePartitions();
    }

    public TsFileResource createHardlink() {
        TsFileResource newResource;
        if (this.file == null || !this.file.exists()) {
            return null;
        }
        try {
            newResource = new TsFileResource(this);
        }
        catch (IOException e) {
            LOGGER.error("Cannot create hardlink for {}", (Object)this.file, (Object)e);
            return null;
        }
        while (true) {
            String hardlinkSuffix = "." + System.currentTimeMillis() + "_" + this.random.nextLong();
            File hardlink = new File(this.file.getAbsolutePath() + hardlinkSuffix);
            try {
                Files.createLink(Paths.get(hardlink.getAbsolutePath(), new String[0]), Paths.get(this.file.getAbsolutePath(), new String[0]));
                newResource.setFile(hardlink);
                if (this.modFile == null || !this.modFile.exists()) break;
                newResource.setModFile(this.modFile.createHardlink());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Cannot create hardlink for {}", (Object)this.file, (Object)e);
                return null;
            }
            break;
        }
        return newResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModFile(ModificationFile modFile) {
        TsFileResource tsFileResource = this;
        synchronized (tsFileResource) {
            this.modFile = modFile;
        }
    }

    public long calculateRamSize() {
        this.ramSize = this.timeIndex.calculateRamSize();
        return this.ramSize;
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void updatePlanIndexes(long planIndex) {
        if (planIndex == Long.MIN_VALUE || planIndex == Long.MAX_VALUE) {
            return;
        }
        if (planIndex < this.minPlanIndex || planIndex > this.maxPlanIndex) {
            this.maxPlanIndex = Math.max(this.maxPlanIndex, planIndex);
            this.minPlanIndex = Math.min(this.minPlanIndex, planIndex);
            if (this.isClosed()) {
                try {
                    this.serialize();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot serialize TsFileResource {} when updating plan index {}-{}", new Object[]{this, this.maxPlanIndex, planIndex});
                }
            }
        }
    }

    public static int getInnerCompactionCount(String fileName) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(fileName);
        return tsFileName.getInnerCompactionCnt();
    }

    public void updatePlanIndexes(TsFileResource another) {
        this.maxPlanIndex = Math.max(this.maxPlanIndex, another.maxPlanIndex);
        this.minPlanIndex = Math.min(this.minPlanIndex, another.minPlanIndex);
    }

    public boolean isPlanIndexOverlap(TsFileResource another) {
        return another.maxPlanIndex > this.minPlanIndex && another.minPlanIndex < this.maxPlanIndex;
    }

    public boolean isPlanRangeCovers(TsFileResource another) {
        return this.minPlanIndex < another.minPlanIndex && another.maxPlanIndex < this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public void setTimeIndex(ITimeIndex timeIndex) {
        this.timeIndex = timeIndex;
    }

    public static int compareFileName(TsFileResource o1, TsFileResource o2) {
        long ver2;
        String[] items1 = o1.getTsFile().getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getTsFile().getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            int cmpVersion = Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
            if (cmpVersion == 0) {
                int cmpInnerCompact = Long.compare(Long.parseLong(items1[2]), Long.parseLong(items2[2]));
                if (cmpInnerCompact == 0) {
                    return Long.compare(Long.parseLong(items1[3]), Long.parseLong(items2[3]));
                }
                return cmpInnerCompact;
            }
            return cmpVersion;
        }
        return cmp;
    }

    public static int checkAndCompareFileName(String fileName1, String fileName2) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName1 = TsFileNameGenerator.getTsFileName(fileName1);
        TsFileNameGenerator.TsFileName tsFileName2 = TsFileNameGenerator.getTsFileName(fileName2);
        long timeDiff = tsFileName1.getTime() - tsFileName2.getTime();
        if (timeDiff != 0L) {
            return timeDiff < 0L ? -1 : 1;
        }
        long versionDiff = tsFileName1.getVersion() - tsFileName2.getVersion();
        if (versionDiff != 0L) {
            return versionDiff < 0L ? -1 : 1;
        }
        return 0;
    }

    public static int compareFileCreationOrderByDesc(TsFileResource o1, TsFileResource o2) {
        try {
            TsFileNameGenerator.TsFileName n1 = TsFileNameGenerator.getTsFileName(o1.getTsFile().getName());
            TsFileNameGenerator.TsFileName n2 = TsFileNameGenerator.getTsFileName(o2.getTsFile().getName());
            long versionDiff = n2.getVersion() - n1.getVersion();
            if (versionDiff != 0L) {
                return versionDiff < 0L ? -1 : 1;
            }
            return 0;
        }
        catch (IOException e) {
            LOGGER.error("File name may not meet the standard naming specifications.", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public int compareIndexDegradePriority(TsFileResource tsFileResource) {
        int cmp = this.timeIndex.compareDegradePriority(tsFileResource.timeIndex);
        return cmp == 0 ? this.file.getAbsolutePath().compareTo(tsFileResource.file.getAbsolutePath()) : cmp;
    }

    public byte getTimeIndexType() {
        return this.timeIndex.getTimeIndexType();
    }

    public void setTimeIndexType(byte type) {
        switch (type) {
            case 1: {
                this.timeIndex = new DeviceTimeIndex();
                break;
            }
            case 2: {
                this.timeIndex = new FileTimeIndex();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public long getRamSize() {
        return this.ramSize;
    }

    public long degradeTimeIndex() {
        TimeIndexLevel timeIndexLevel = TimeIndexLevel.valueOf(this.getTimeIndexType());
        if (timeIndexLevel == TimeIndexLevel.FILE_TIME_INDEX) {
            return 0L;
        }
        long startTime = this.timeIndex.getMinStartTime();
        long endTime = this.timeIndex.getMaxEndTime();
        this.timeIndex = new FileTimeIndex(startTime, endTime);
        return this.ramSize - this.timeIndex.calculateRamSize();
    }

    private void generatePathToTimeSeriesMetadataMap() throws IOException {
        for (PartialPath path : this.pathToChunkMetadataListMap.keySet()) {
            this.pathToTimeSeriesMetadataMap.put(path, ResourceByPathUtils.getResourceInstance(path).generateTimeSeriesMetadata(this.pathToReadOnlyMemChunkMap.get(path), this.pathToChunkMetadataListMap.get(path)));
        }
    }

    public void deleteRemovedDeviceAndUpdateEndTime(Map<String, Long> lastTimeForEachDevice) {
        ITimeIndex newTimeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        for (Map.Entry<String, Long> entry : lastTimeForEachDevice.entrySet()) {
            newTimeIndex.updateStartTime(entry.getKey(), this.timeIndex.getStartTime(entry.getKey()));
            newTimeIndex.updateEndTime(entry.getKey(), entry.getValue());
        }
        this.timeIndex = newTimeIndex;
    }

    public void updateEndTime(Map<String, Long> lastTimeForEachDevice) {
        for (Map.Entry<String, Long> entry : lastTimeForEachDevice.entrySet()) {
            this.timeIndex.updateEndTime(entry.getKey(), entry.getValue());
        }
    }

    public boolean isFileInList() {
        return this.prev != null || this.next != null;
    }

    public void updateProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return;
        }
        this.maxProgressIndex = this.maxProgressIndex == null ? progressIndex : this.maxProgressIndex.updateToMinimumIsAfterProgressIndex(progressIndex);
    }

    public void setProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return;
        }
        this.maxProgressIndex = progressIndex;
    }

    public ProgressIndex getMaxProgressIndexAfterClose() throws IllegalStateException {
        if (this.getStatus().equals((Object)TsFileResourceStatus.UNCLOSED)) {
            throw new IllegalStateException("Should not get progress index from a unclosing TsFileResource.");
        }
        return this.getMaxProgressIndex();
    }

    public ProgressIndex getMaxProgressIndex() {
        return this.maxProgressIndex == null ? MinimumProgressIndex.INSTANCE : this.maxProgressIndex;
    }

    public boolean isEmpty() {
        return this.getDevices().isEmpty();
    }

    public String getDatabaseName() {
        return this.file.getParentFile().getParentFile().getParentFile().getName();
    }

    public String getDataRegionId() {
        return this.file.getParentFile().getParentFile().getName();
    }

    public boolean isInsertionCompactionTaskCandidate() {
        return !this.isSeq && this.isInsertionCompactionTaskCandidate;
    }

    public void setInsertionCompactionTaskCandidate(boolean insertionCompactionTaskCandidate) {
        this.isInsertionCompactionTaskCandidate = insertionCompactionTaskCandidate;
    }
}

