/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.DeviceInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;

public class TsFileResourceCandidate {
    public TsFileResource resource;
    public boolean selected;
    public boolean isValidCandidate;
    private Map<String, DeviceInfo> deviceInfoMap;
    private boolean hasDetailedDeviceInfo;

    protected TsFileResourceCandidate(TsFileResource tsFileResource) {
        this.resource = tsFileResource;
        this.selected = false;
        this.isValidCandidate = tsFileResource.getStatus() == TsFileResourceStatus.NORMAL;
    }

    public boolean unsealed() {
        return this.resource.getStatus() == TsFileResourceStatus.UNCLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDeviceInfos() throws IOException {
        if (this.deviceInfoMap != null) {
            return;
        }
        this.deviceInfoMap = new LinkedHashMap<String, DeviceInfo>();
        if (this.resource.getTimeIndexType() == 2) {
            this.resource.readLock();
            try {
                if (!this.resource.resourceFileExists()) {
                    this.hasDetailedDeviceInfo = false;
                    return;
                }
                DeviceTimeIndex timeIndex = this.resource.buildDeviceTimeIndex();
                for (String deviceId : timeIndex.getDevices()) {
                    this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, timeIndex.getStartTime(deviceId), timeIndex.getEndTime(deviceId)));
                }
            }
            finally {
                this.resource.readUnlock();
            }
        } else {
            for (String deviceId : this.resource.getDevices()) {
                this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, this.resource.getStartTime(deviceId), this.resource.getEndTime(deviceId)));
            }
        }
        this.hasDetailedDeviceInfo = true;
    }

    public void markAsSelected() {
        this.selected = true;
    }

    public List<DeviceInfo> getDevices() throws IOException {
        this.prepareDeviceInfos();
        return new ArrayList<DeviceInfo>(this.deviceInfoMap.values());
    }

    public DeviceInfo getDeviceInfoById(String deviceId) throws IOException {
        this.prepareDeviceInfos();
        return this.deviceInfoMap.get(deviceId);
    }

    public boolean containsDevice(String deviceId) throws IOException {
        this.prepareDeviceInfos();
        return this.deviceInfoMap.containsKey(deviceId);
    }

    public boolean hasDetailedDeviceInfo() throws IOException {
        this.prepareDeviceInfos();
        return this.hasDetailedDeviceInfo;
    }

    public boolean mayHasOverlapWithUnseqFile(DeviceInfo unseqFileDeviceInfo) throws IOException {
        this.prepareDeviceInfos();
        long endTime = this.containsDevice(unseqFileDeviceInfo.deviceId) ? this.getDeviceInfoById((String)unseqFileDeviceInfo.deviceId).endTime : this.resource.getFileEndTime();
        return unseqFileDeviceInfo.startTime <= endTime;
    }
}

